/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.modCompat.jei;

import java.util.ArrayList;
import java.util.List;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.util.recipes.PoweredCraftingManager;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import mezz.jei.plugins.vanilla.crafting.ShapedOreRecipeWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapedRecipesWrapper;
import mezz.jei.plugins.vanilla.crafting.ShapelessRecipeWrapper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class PoweredRecipeChecker {
    public static List<IPoweredRecipe> getValidRecipes(IJeiHelpers jeiHelpers) {
        CraftingRecipeValidator<ShapedOreRecipe> shapedOreRecipeValidator = new CraftingRecipeValidator<ShapedOreRecipe>(recipe -> new ShapedOreRecipeWrapper(jeiHelpers, recipe));
        CraftingRecipeValidator<ShapedRecipes> shapedRecipesValidator = new CraftingRecipeValidator<ShapedRecipes>(recipe -> new ShapedRecipesWrapper(jeiHelpers, recipe));
        CraftingRecipeValidator<ShapelessOreRecipe> shapelessOreRecipeValidator = new CraftingRecipeValidator<ShapelessOreRecipe>(recipe -> new ShapelessRecipeWrapper(jeiHelpers, (IRecipe)recipe));
        CraftingRecipeValidator<ShapelessRecipes> shapelessRecipesValidator = new CraftingRecipeValidator<ShapelessRecipes>(recipe -> new ShapelessRecipeWrapper(jeiHelpers, (IRecipe)recipe));
        ArrayList<IPoweredRecipe> validRecipes = new ArrayList<IPoweredRecipe>();
        for (IPoweredRecipe recipe2 : PoweredCraftingManager.getAllRecipes()) {
            if (recipe2 instanceof ShapedOreRecipe) {
                if (!shapedOreRecipeValidator.isRecipeValid((ShapedOreRecipe)recipe2)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapedRecipes) {
                if (!shapedRecipesValidator.isRecipeValid((ShapedRecipes)recipe2)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessOreRecipe) {
                if (!shapelessOreRecipeValidator.isRecipeValid((ShapelessOreRecipe)recipe2)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            if (recipe2 instanceof ShapelessRecipes) {
                if (!shapelessRecipesValidator.isRecipeValid((ShapelessRecipes)recipe2)) continue;
                validRecipes.add(recipe2);
                continue;
            }
            validRecipes.add(recipe2);
        }
        return validRecipes;
    }

    private static final class CraftingRecipeValidator<T extends IRecipe> {
        private static final int INVALID_COUNT = -1;
        private final IRecipeWrapperFactory<T> recipeWrapperFactory;

        public CraftingRecipeValidator(IRecipeWrapperFactory<T> recipeWrapperFactory) {
            this.recipeWrapperFactory = recipeWrapperFactory;
        }

        public boolean isRecipeValid(T recipe) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput == null || recipeOutput.func_190926_b()) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no output. {}", (Object)recipeInfo);
                return false;
            }
            NonNullList ingredients = recipe.func_192400_c();
            if (ingredients == null) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
                return false;
            }
            int inputCount = CraftingRecipeValidator.getInputCount((List<Ingredient>)ingredients);
            if (inputCount == -1) {
                return false;
            }
            if (inputCount > 9) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has too many inputs. {}", (Object)recipeInfo);
                return false;
            }
            if (inputCount == 0) {
                String recipeInfo = this.getInfo(recipe);
                Log.get().error("Recipe has no inputs. {}", (Object)recipeInfo);
                return false;
            }
            return true;
        }

        private String getInfo(T recipe) {
            IRecipeWrapper recipeWrapper = this.recipeWrapperFactory.getRecipeWrapper(recipe);
            return ErrorUtil.getInfoFromRecipe(recipe, (IRecipeWrapper)recipeWrapper);
        }

        protected static int getInputCount(List<Ingredient> ingredientList) {
            int inputCount = 0;
            for (Ingredient ingredient : ingredientList) {
                ItemStack[] input = ingredient.func_193365_a();
                if (input == null) {
                    return -1;
                }
                if (ingredient instanceof OreIngredient && input.length == 0) {
                    return -1;
                }
                ++inputCount;
            }
            return inputCount;
        }
    }
}

