/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.files.worldData;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import javax.annotation.Nullable;
import me.modmuss50.ftba.ConfigManager;
import me.modmuss50.ftba.files.worldData.WorldFormat;
import me.modmuss50.ftba.files.worldData.WorldHashManager;
import me.modmuss50.ftba.packets.PacketSendWorldData;
import me.modmuss50.ftba.util.TimerServerHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.World;
import net.minecraft.world.storage.ThreadedFileIOBase;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.apache.commons.io.FileUtils;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.util.serialization.SerializationUtil;

public class WorldDataManager {
    public static final String savename = "_ftbachievements.json";
    private WorldFormat format;
    private String worldHash;

    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        if (event.getWorld().field_72995_K) {
            return;
        }
        ThreadedFileIOBase.func_178779_a().func_75735_a(() -> {
            try {
                this.save(event.getWorld());
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to save world data manager", e);
            }
            return false;
        });
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) throws IOException {
        if (event.getWorld().field_72995_K) {
            return;
        }
        this.load(event.getWorld());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void worldClosed(WorldEvent.Unload event) throws IOException {
        if (event.getWorld().field_72995_K) {
            return;
        }
        this.save(event.getWorld());
    }

    public void load(World world) throws IOException {
        File file = new File(world.func_72860_G().func_75765_b(), savename);
        WorldFormat format = file.exists() ? (WorldFormat)SerializationUtil.GSON.fromJson(FileUtils.readFileToString((File)file), WorldFormat.class) : new WorldFormat();
        this.format = format;
        if (format.timerData != null) {
            TimerServerHandler.load(format.timerData);
        } else {
            TimerServerHandler.reset();
        }
        File hashFile = new File(world.func_72860_G().func_75765_b(), "ftba.dat");
        if (hashFile.exists()) {
            this.worldHash = FileUtils.readFileToString((File)hashFile);
        } else {
            this.worldHash = WorldHashManager.generateHash();
            FileUtils.writeStringToFile((File)hashFile, (String)this.worldHash);
        }
    }

    public void save(World world) throws IOException {
        this.format.timerData = TimerServerHandler.save();
        File file = new File(world.func_72860_G().func_75765_b(), savename);
        FileUtils.writeStringToFile((File)file, (String)SerializationUtil.GSON.toJson((Object)this.getFormatServer()), (Charset)Charsets.UTF_8);
    }

    @Nullable
    public WorldFormat getFormatServer() {
        return this.format;
    }

    public String getWorldHash() {
        return this.worldHash;
    }

    public void syncFormat() {
        PacketSendWorldData dataPacket = new PacketSendWorldData(ConfigManager.TINY_GSON.toJson((Object)this.getFormatServer()), this.getWorldHash());
        NetworkManager.sendToAll((INetworkPacket)dataPacket);
    }

    public void syncFormat(EntityPlayerMP player) {
        PacketSendWorldData dataPacket = new PacketSendWorldData(ConfigManager.TINY_GSON.toJson((Object)this.getFormatServer()), this.getWorldHash());
        NetworkManager.sendToPlayer((INetworkPacket)dataPacket, (EntityPlayerMP)player);
    }
}

