/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.client.hud;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.modmuss50.ftba.client.ClientDataManager;
import me.modmuss50.ftba.client.KeyBindings;
import me.modmuss50.ftba.client.gui.achivementGui.AchievementButton;
import me.modmuss50.ftba.client.hud.ClientHintRender;
import me.modmuss50.ftba.client.hud.HUDModes;
import me.modmuss50.ftba.client.hud.TeamHUDManager;
import me.modmuss50.ftba.client.hud.Timer;
import me.modmuss50.ftba.config.ConfigFeatures;
import me.modmuss50.ftba.files.config.FTBAchievement;
import me.modmuss50.ftba.files.runs.AchievementData;
import me.modmuss50.ftba.files.worldData.WorldFormat;
import me.modmuss50.ftba.util.ClientWorldPlayerCountHandler;
import me.modmuss50.ftba.util.TimerServerHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiChat;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ClientHudRenderer {
    public static int state = 3;
    public static boolean visible = true;
    private static boolean lastEnabled = true;
    public static int clientTick = 0;

    @SideOnly(value=Side.CLIENT)
    public static String getBookTitle(FTBAchievement ftbAchievement) {
        NBTTagCompound nbttagcompound;
        String s;
        if (AchievementButton.isValidBook(ftbAchievement.bookStack) && !StringUtils.func_151246_b((String)(s = (nbttagcompound = ftbAchievement.bookStack.func_77978_p()).func_74779_i("title")))) {
            return s;
        }
        return ftbAchievement.name;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        ++clientTick;
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderGameEvent(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.ALL) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (ConfigFeatures.INSTANCE.TeamSelection && TeamHUDManager.shouldShow()) {
            Gui.func_73734_a((int)3, (int)5, (int)137, (int)22, (int)Color.BLACK.getRGB());
            Gui.func_73734_a((int)5, (int)7, (int)135, (int)20, (int)Color.GRAY.getRGB());
            minecraft.field_71466_p.func_78276_b("Press " + KeyBindings.teamSlection.getDisplayName() + " to join a team", 10, 10, Color.WHITE.getRGB());
        }
        HUDModes mode = HUDModes.NOARMAL;
        if (minecraft.field_71462_r != null && ConfigFeatures.INSTANCE.ShowRunHash) {
            minecraft.field_71466_p.func_78276_b("#" + ClientDataManager.getWorldHash(), 5, 5, mode.textColor);
        }
        if (!ConfigFeatures.INSTANCE.AchievementHUD) {
            return;
        }
        if (!visible || ClientWorldPlayerCountHandler.getPlayerCount() != 1) {
            return;
        }
        if (minecraft.field_71474_y.field_74330_P || minecraft.field_71462_r != null && !(minecraft.field_71462_r instanceof GuiChat)) {
            return;
        }
        List<FTBAchievement> achievements = Collections.emptyList();
        if (ClientDataManager.getConfigFormat().achievements != null) {
            achievements = new ArrayList<FTBAchievement>(ClientDataManager.getConfigFormat().achievements);
        }
        ClientHintRender.render(event);
        int height = Math.max(15, achievements.size() * 12 + 11);
        int xPos = event.getResolution().func_78326_a() - 50;
        int yPos = event.getResolution().func_78328_b() - 25;
        if (state % 2 == 0) {
            xPos = 5;
        }
        if (state > 1) {
            yPos = 5;
        }
        Gui.func_73734_a((int)(xPos - 2), (int)(yPos - 2), (int)(xPos + 45), (int)(yPos + height + 2), (int)mode.backgroundRGBA);
        Gui.func_73734_a((int)xPos, (int)yPos, (int)(xPos + 43), (int)(yPos + height), (int)mode.secondaryColor);
        minecraft.field_71466_p.func_78276_b(Timer.getNiceTime(), xPos + 2, yPos + 4, mode.textColor);
        WorldFormat format = ClientDataManager.getWorldFormat();
        Collections.sort(achievements, (achievement1, achievement2) -> {
            if (format == null || format.triggedAchivements == null || achievement1 == null || achievement2 == null) {
                return 0;
            }
            if (format.triggedAchivements.contains(achievement1.name) && format.triggedAchivements.contains(achievement2.name)) {
                return (int)(format.achivementTimes.get(achievement1.name) - format.achivementTimes.get(achievement2.name));
            }
            return 0;
        });
        Collections.sort(achievements, (achievement1, achievement2) -> {
            if (format == null || format.triggedAchivements == null || achievement1 == null || achievement2 == null) {
                return 0;
            }
            if (format.triggedAchivements.contains(achievement1.name) && format.triggedAchivements.contains(achievement2.name)) {
                return 0;
            }
            if (format.triggedAchivements.contains(achievement1.name) && !format.triggedAchivements.contains(achievement2.name)) {
                return 1;
            }
            if (!format.triggedAchivements.contains(achievement1.name) && format.triggedAchivements.contains(achievement2.name)) {
                return -1;
            }
            return 0;
        });
        Object fastest = null;
        int i = 0;
        for (FTBAchievement achievement : achievements) {
            ++i;
            String title = ClientHudRenderer.getBookTitle(achievement);
            String name = format != null && format.triggedAchivements != null && format.triggedAchivements.contains(achievement.name) ? TextFormatting.GRAY + "" + TextFormatting.STRIKETHROUGH + title : title;
            boolean isComplete = false;
            if (format.triggedAchivements != null && format.triggedAchivements.contains(achievement.name)) {
                long time = format.achivementTimes.get(achievement.name);
                isComplete = true;
                String timeStr = TimerServerHandler.getNiceTimeFromLong(time);
                boolean hasFastest = false;
                if (fastest != null) {
                    for (AchievementData data : fastest.achievementData) {
                        long timeDiff;
                        if (!data.achievement.equals(achievement.name)) continue;
                        hasFastest = true;
                        long fastestTime = data.time;
                        TextFormatting color = TextFormatting.RED;
                        if (fastestTime > time) {
                            color = TextFormatting.GREEN;
                        }
                        boolean negative = (timeDiff = fastestTime - time) < 0L;
                        String prefix = "+";
                        if (negative) {
                            timeDiff = Math.abs(timeDiff);
                            prefix = "-";
                        }
                        timeStr = color + prefix + TimerServerHandler.getNiceTimeFromLong(timeDiff);
                    }
                }
                int strTrimLenght = 8;
                if (hasFastest) {
                    strTrimLenght = 7;
                }
                if (title.length() >= strTrimLenght) {
                    name = name.substring(0, Math.min(name.length(), strTrimLenght + 1)) + TextFormatting.RESET + TextFormatting.GRAY + "...";
                }
                name = name + TextFormatting.RESET + " " + TextFormatting.GREEN;
                if (!hasFastest) {
                    minecraft.field_71466_p.func_78276_b(TextFormatting.GREEN + timeStr, xPos + 40, yPos + i * 12 + 12, mode.textColor);
                } else {
                    minecraft.field_71466_p.func_78276_b(TextFormatting.GREEN + timeStr, xPos + 33, yPos + i * 12 + 12, mode.textColor);
                }
            }
            if (!isComplete && ClientDataManager.percentageMap != null && ClientDataManager.percentageMap.containsKey(achievement.name)) {
                String percentage = TextFormatting.AQUA + ClientDataManager.percentageMap.get(achievement.name);
                if (!ClientDataManager.percentageMap.get(achievement.name).equals("150%")) {
                    if (percentage.length() > 5) {
                        minecraft.field_71466_p.func_78276_b(percentage, xPos + 70, yPos + i * 12 + 12, mode.textColor);
                    } else {
                        minecraft.field_71466_p.func_78276_b(percentage, xPos + 80, yPos + i * 12 + 12, mode.textColor);
                    }
                }
            }
            minecraft.field_71466_p.func_78276_b(name, xPos + 1, yPos + i * 12 + 12, mode.textColor);
        }
    }
}

