/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.client.gui.poweredCrafting;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import me.modmuss50.ftba.FTBAchievements;
import me.modmuss50.ftba.api.IPoweredRecipe;
import me.modmuss50.ftba.blocks.crafting.TilePoweredCraftingTable;
import me.modmuss50.ftba.client.gui.poweredCrafting.SlotPoweredCrafting;
import me.modmuss50.ftba.util.recipes.PoweredCraftingManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutableTriple;
import org.apache.commons.lang3.tuple.Pair;

public class ContainerCraftingTable
extends ContainerWorkbench {
    World field_75161_g;
    BlockPos field_178145_h;
    EntityPlayer field_192390_i;
    TilePoweredCraftingTable tile;
    public int power = 0;
    public int maxPower = 0;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Short>> shortValues;
    private final ArrayList<MutableTriple<IntSupplier, IntConsumer, Integer>> integerValues;
    private Integer[] integerParts;

    public ContainerCraftingTable(EntityPlayer player, World worldIn, BlockPos posIn) {
        super(player.field_71071_by, worldIn, posIn);
        this.field_75161_g = worldIn;
        this.field_178145_h = posIn;
        player.field_71070_bA = this;
        this.field_192390_i = player;
        this.tile = (TilePoweredCraftingTable)worldIn.func_175625_s(posIn);
        this.shortValues = new ArrayList();
        this.integerValues = new ArrayList();
        this.addIntegerSync((Pair<IntSupplier, IntConsumer>)Pair.of(() -> (int)this.tile.getEnergy(), value -> {
            this.power = value;
        }));
        this.addIntegerSync((Pair<IntSupplier, IntConsumer>)Pair.of(() -> (int)this.tile.getMaxPower(), value -> {
            this.maxPower = value;
        }));
    }

    public void addIntegerSync(Pair<IntSupplier, IntConsumer> syncables) {
        this.addIntegerSync(Collections.singletonList(syncables));
    }

    public void addIntegerSync(List<Pair<IntSupplier, IntConsumer>> syncables) {
        for (Pair<IntSupplier, IntConsumer> syncable : syncables) {
            this.integerValues.add((MutableTriple<IntSupplier, IntConsumer, Integer>)MutableTriple.of((Object)syncable.getLeft(), (Object)syncable.getRight(), (Object)0));
        }
        this.integerValues.trimToSize();
        this.integerParts = new Integer[this.integerValues.size()];
    }

    protected void func_192389_a(World worldIn, EntityPlayer player, InventoryCrafting inventoryCrafting, InventoryCraftResult craftResult) {
        if (!worldIn.field_72995_K) {
            EntityPlayerMP entityplayermp = (EntityPlayerMP)player;
            ItemStack itemstack = ItemStack.field_190927_a;
            List<IPoweredRecipe> recipes = PoweredCraftingManager.findAllMatchingRecipe(inventoryCrafting, worldIn);
            for (IPoweredRecipe irecipe : recipes) {
                if (irecipe == null || !irecipe.func_192399_d() && worldIn.func_82736_K().func_82766_b("doLimitedCrafting") || !irecipe.enabled(player) && !((EntityPlayerMP)player).field_70170_p.field_72995_K || !this.tile.canUseEnergy(irecipe.powerUsage())) continue;
                craftResult.func_193056_a((IRecipe)irecipe);
                itemstack = irecipe.func_77572_b(inventoryCrafting);
                break;
            }
            craftResult.func_70299_a(0, itemstack);
            entityplayermp.field_71135_a.func_147359_a((Packet)new SPacketSetSlot(this.field_75152_c, 0, itemstack));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        if (this.field_75161_g.func_180495_p(this.field_178145_h).func_177230_c() != FTBAchievements.poweredCraftingTable) {
            return false;
        }
        return playerIn.func_70092_e((double)this.field_178145_h.func_177958_n() + 0.5, (double)this.field_178145_h.func_177956_o() + 0.5, (double)this.field_178145_h.func_177952_p() + 0.5) <= 64.0;
    }

    public Slot func_75146_a(Slot slotIn) {
        if (slotIn instanceof SlotCrafting && !(slotIn instanceof SlotPoweredCrafting)) {
            SlotPoweredCrafting newSlot = null;
            try {
                newSlot = new SlotPoweredCrafting(this.getPlayer((SlotCrafting)slotIn), this.field_75162_e, (IInventory)this.field_75160_f, slotIn.getSlotIndex(), slotIn.field_75223_e, slotIn.field_75221_f, this);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                throw new RuntimeException("Failed to get player from slot", e);
            }
            return super.func_75146_a((Slot)newSlot);
        }
        return super.func_75146_a(slotIn);
    }

    public EntityPlayer getPlayer(SlotCrafting slotCrafting) throws IllegalAccessException, NoSuchFieldException {
        Field field = ReflectionHelper.findField(slotCrafting.getClass(), (String[])new String[]{"player", "field_75238_b", "b"});
        field.setAccessible(true);
        return (EntityPlayer)field.get(slotCrafting);
    }

    public void func_75142_b() {
        super.func_75142_b();
        for (IContainerListener listener : this.field_75149_d) {
            int supplied;
            int i = 0;
            if (!this.shortValues.isEmpty()) {
                for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                    supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                    if (supplied != (Short)mutableTriple.getRight()) {
                        listener.func_71112_a((Container)this, i, supplied);
                        mutableTriple.setRight((Object)((short)supplied));
                    }
                    ++i;
                }
            }
            if (this.integerValues.isEmpty()) continue;
            for (MutableTriple mutableTriple : this.integerValues) {
                supplied = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                if (supplied != (Integer)mutableTriple.getRight()) {
                    listener.func_71112_a((Container)this, i, supplied >> 16);
                    listener.func_71112_a((Container)this, i + 1, (int)((short)(supplied & 0xFFFF)));
                    mutableTriple.setRight((Object)supplied);
                }
                i += 2;
            }
        }
    }

    public void func_75132_a(IContainerListener listener) {
        super.func_75132_a(listener);
        int i = 0;
        if (!this.shortValues.isEmpty()) {
            for (MutableTriple<IntSupplier, IntConsumer, Short> mutableTriple : this.shortValues) {
                short s = (short)((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, (int)s);
                mutableTriple.setRight((Object)s);
                ++i;
            }
        }
        if (!this.integerValues.isEmpty()) {
            for (MutableTriple mutableTriple : this.integerValues) {
                int n = ((IntSupplier)mutableTriple.getLeft()).getAsInt();
                listener.func_71112_a((Container)this, i, n >> 16);
                listener.func_71112_a((Container)this, i + 1, (int)((short)(n & 0xFFFF)));
                mutableTriple.setRight((Object)n);
                i += 2;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_75137_b(int id, int value) {
        if (id < this.shortValues.size()) {
            ((IntConsumer)this.shortValues.get(id).getMiddle()).accept((short)value);
            this.shortValues.get(id).setRight((Object)((short)value));
        } else if (id - this.shortValues.size() < this.integerValues.size() * 2) {
            if ((id - this.shortValues.size()) % 2 == 0) {
                this.integerParts[(id - this.shortValues.size()) / 2] = value;
            } else {
                ((IntConsumer)this.integerValues.get((id - this.shortValues.size()) / 2).getMiddle()).accept((this.integerParts[(id - this.shortValues.size()) / 2] & 0xFFFF) << 16 | value & 0xFFFF);
            }
        }
    }
}

