/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.client;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.modmuss50.ftba.client.ClientDataManager;
import me.modmuss50.ftba.files.config.ConfigFormat;
import me.modmuss50.ftba.files.config.FTBAchievement;
import me.modmuss50.ftba.files.runs.AchievementData;
import me.modmuss50.ftba.files.runs.RunData;
import me.modmuss50.ftba.files.runs.RunManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import reborncore.common.util.serialization.SerializationUtil;

public class RunComparison {
    @Nullable
    private static RunData runData;

    @Nullable
    public static RunData getRunData() {
        return runData;
    }

    public static void setRunData(@Nullable RunData runData) {
        RunComparison.runData = runData;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static RunData downloadFastest() {
        try {
            String json = IOUtils.toString((URL)new URL("http://ftb.world/fastestTime.json"));
            RunData temp = (RunData)SerializationUtil.GSON.fromJson(json, RunData.class);
            if (RunComparison.isRunValid(temp)) {
                return temp;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public static RunData loadUserFastest() {
        RunData fastest = null;
        for (RunData runData : RunManager.getRuns()) {
            if (!RunComparison.isRunValid(runData)) continue;
            if (fastest == null) {
                fastest = runData;
                continue;
            }
            if (runData.totalTime >= fastest.totalTime) continue;
            fastest = runData;
        }
        return fastest;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isRunValid(RunData data) {
        ConfigFormat format = ClientDataManager.getConfigFormat();
        boolean hasAllAchievements = true;
        ArrayList<String> runAchs = new ArrayList<String>();
        for (AchievementData achRemote : data.achievementData) {
            runAchs.add(achRemote.achievement);
        }
        for (FTBAchievement achClient : format.achievements) {
            if (runAchs.contains(achClient.name)) continue;
            hasAllAchievements = false;
        }
        return hasAllAchievements;
    }

    public static void main(String[] args) throws IOException {
        RunComparison.downloadFastest();
    }
}

