/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba.blocks.resGen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import me.modmuss50.ftba.api.IResGenHandler;
import me.modmuss50.ftba.api.IResGenUpgrade;
import me.modmuss50.ftba.config.ConfigResourceGen;
import me.modmuss50.ftba.config.DuplicationResource;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import reborncore.api.power.IPowerConfig;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.ItemUtils;

public class TileResGen
extends TilePowerAcceptor
implements IResGenHandler {
    public static PowerConfig powerConfig = new PowerConfig();
    public float progress;
    public float speedModifier = 1.0f;
    public float powerModifier = 1.0f;
    public int luckModifier = 0;
    public boolean running = false;
    public boolean lastRunning = false;
    public List<DuplicationResource> duplicationResources = new ArrayList<DuplicationResource>();
    public DuplicationResource currentResource;
    public int rr_int;

    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        List frameList = this.field_145850_b.func_72872_a(EntityItemFrame.class, new AxisAlignedBB((double)this.func_174877_v().func_177958_n() - 0.1, (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p() - 0.1, (double)this.func_174877_v().func_177958_n() + 1.1, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 1.1));
        List<ItemStack> frameItems = frameList.stream().map(EntityItemFrame::func_82335_i).collect(Collectors.toList());
        boolean allEmpty = frameItems.stream().allMatch(ItemStack::func_190926_b);
        if (!allEmpty) {
            List<ItemStack> nonUpgrades = this.computeUpgrades(frameItems);
            List<DuplicationResource> resources = nonUpgrades.stream().map(this::getResource).filter(Objects::nonNull).collect(Collectors.toList());
            if (resources.isEmpty()) {
                this.running = false;
            } else {
                this.running = true;
                this.tryCreateResource(resources);
            }
        } else {
            this.running = false;
        }
        if (this.lastRunning != this.running) {
            this.updateActive();
        }
        this.lastRunning = this.running;
    }

    private void tryCreateResource(List<DuplicationResource> resources) {
        double powerUsage;
        if (!resources.contains(this.currentResource)) {
            ++this.rr_int;
            this.rr_int %= resources.size();
            this.currentResource = resources.get(this.rr_int);
        }
        if (this.canUseEnergy(powerUsage = (double)Math.max((float)this.currentResource.powerUsage * this.powerModifier, 1.0f)) || this.currentResource.powerUsage == 0) {
            if (this.progress >= (float)this.currentResource.processTime) {
                boolean madeItem;
                BlockPos up = this.func_174877_v().func_177984_a();
                TileEntity tileEntity = this.field_145850_b.func_175625_s(up);
                IItemHandler itemHandler = null;
                if (tileEntity != null && tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP)) {
                    itemHandler = (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.UP);
                }
                int amount = 1;
                for (int bonusLuck = this.luckModifier - this.field_145850_b.field_73012_v.nextInt(100); bonusLuck > 0; bonusLuck -= this.field_145850_b.field_73012_v.nextInt(100) + 1) {
                    ++amount;
                }
                if (itemHandler != null) {
                    ItemStack stack = this.currentResource.stack.func_77946_l();
                    stack.func_190920_e(amount);
                    madeItem = ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)stack, (boolean)false).func_190926_b();
                } else {
                    for (int x = 0; x < amount; ++x) {
                        EntityItem item = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)(this.func_174877_v().func_177956_o() + 1), (double)this.func_174877_v().func_177952_p() + 0.5, this.currentResource.stack.func_77946_l());
                        item.field_70159_w += this.field_145850_b.field_73012_v.nextDouble() / 4.0 - 0.1;
                        item.field_70181_x += this.field_145850_b.field_73012_v.nextDouble() / 2.0;
                        item.field_70179_y += this.field_145850_b.field_73012_v.nextDouble() / 4.0 - 0.1;
                        item.func_70288_d();
                        this.field_145850_b.func_72838_d((Entity)item);
                    }
                    madeItem = true;
                }
                this.progress = 0.0f;
                this.currentResource = null;
                if (madeItem) {
                    this.useEnergy(powerUsage);
                }
            } else {
                this.progress += this.speedModifier;
            }
        }
    }

    private List<ItemStack> computeUpgrades(List<ItemStack> frameItems) {
        List<ItemStack> upgradeItems = frameItems.stream().filter(is -> IResGenUpgrade.class.isInstance(is.func_77973_b())).collect(Collectors.toList());
        this.reset();
        upgradeItems.forEach(is -> ((IResGenUpgrade)is.func_77973_b()).processUpgrade((ItemStack)is, this));
        ArrayList<ItemStack> nonUpgrades = new ArrayList<ItemStack>(frameItems);
        nonUpgrades.removeAll(upgradeItems);
        return nonUpgrades;
    }

    public void updateActive() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(this.running));
        this.field_145850_b.func_180501_a(this.field_174879_c, state, 3);
    }

    public DuplicationResource getResource(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        if (ConfigResourceGen.duplicationResources == null || ConfigResourceGen.duplicationResources.isEmpty()) {
            return null;
        }
        for (DuplicationResource resource : ConfigResourceGen.duplicationResources) {
            if (!ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)resource.stack, (boolean)true, (boolean)true, (boolean)false)) continue;
            return resource;
        }
        return null;
    }

    public float getProcessTime(DuplicationResource resource) {
        if (resource != null) {
            return (float)resource.processTime * (1.0f - this.speedModifier);
        }
        return -1.0f;
    }

    public double getBaseMaxPower() {
        return 25000.0;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return 512.0;
    }

    public boolean canAcceptEnergy(EnumFacing enumFacing) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing enumFacing) {
        return false;
    }

    public IPowerConfig getPowerConfig() {
        return powerConfig;
    }

    @Override
    public void reset() {
        this.speedModifier = 1.0f;
        this.powerModifier = 1.0f;
        this.luckModifier = 0;
    }

    @Override
    public void addSpeedModifier(float speed) {
        this.speedModifier *= 1.0f + speed;
    }

    @Override
    public void addPowerModifier(float power) {
        this.powerModifier += power;
    }

    @Override
    public void addLuckModifier(int luck) {
        this.luckModifier += luck;
    }

    public boolean canBeUpgraded() {
        return false;
    }

    private static class PowerConfig
    implements IPowerConfig {
        private PowerConfig() {
        }

        public boolean eu() {
            return true;
        }

        public boolean tesla() {
            return true;
        }

        public boolean internal() {
            return true;
        }

        public boolean forge() {
            return true;
        }
    }
}

