/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.ftba;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.annotation.Nullable;
import me.modmuss50.ftba.files.config.BlockTrigger;
import me.modmuss50.ftba.files.config.ConfigFormat;
import me.modmuss50.ftba.files.config.CraftingTrigger;
import me.modmuss50.ftba.files.config.FTBAchievement;
import me.modmuss50.ftba.files.config.GuiTrigger;
import me.modmuss50.ftba.files.config.LeaderboardData;
import net.minecraft.item.ItemStack;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import reborncore.common.util.serialization.ItemStackSerializer;
import reborncore.common.util.serialization.SerializationUtil;

public class ConfigManager {
    private static ConfigFormat config;
    public static File configFile;
    public static final Gson TINY_GSON;

    public static void load() throws IOException {
        if (!configFile.exists()) {
            ConfigManager.genDefault();
            FileUtils.writeStringToFile((File)configFile, (String)SerializationUtil.GSON.toJson((Object)config));
        } else {
            config = (ConfigFormat)SerializationUtil.GSON.fromJson(FileUtils.readFileToString((File)configFile), ConfigFormat.class);
        }
    }

    public static void save() throws IOException {
        FileUtils.writeStringToFile((File)configFile, (String)SerializationUtil.GSON.toJson((Object)config));
    }

    public static void reload() throws IOException {
        config = (ConfigFormat)SerializationUtil.GSON.fromJson(FileUtils.readFileToString((File)configFile), ConfigFormat.class);
    }

    @Nullable
    public static FTBAchievement getAchivementFromName(String name) {
        for (FTBAchievement achievement : ConfigManager.config.achievements) {
            if (!achievement.name.equals(name)) continue;
            return achievement;
        }
        return null;
    }

    public static int getMaxInputs() {
        if (ConfigManager.config.inputTriggers == null) {
            return 0;
        }
        return ConfigManager.config.inputTriggers.size();
    }

    public static ConfigFormat getConfig() {
        return config;
    }

    public static File getConfigFile() {
        return configFile;
    }

    @Nullable
    public static BlockTrigger getTriggerFromMeta(int meta) {
        if (ConfigManager.config.inputTriggers == null || ConfigManager.config.inputTriggers.size() <= meta) {
            return null;
        }
        return ConfigManager.config.inputTriggers.get(meta);
    }

    public static int getMetaFromTrigger(BlockTrigger trigger) {
        if (!ConfigManager.config.inputTriggers.contains(trigger)) {
            return 0;
        }
        return ConfigManager.config.inputTriggers.indexOf(trigger);
    }

    private static void genDefault() {
        config = new ConfigFormat();
        ConfigManager.config.achievements = new ArrayList<FTBAchievement>();
        ConfigManager.config.craftingTriggers = new ArrayList<CraftingTrigger>();
        ConfigManager.config.inputTriggers = new ArrayList<BlockTrigger>();
        ConfigManager.config.guiTriggers = new ArrayList<GuiTrigger>();
        LeaderboardData leaderboardData = new LeaderboardData();
        leaderboardData.packName = "UNNAMED";
        ConfigManager.config.leaderboard = leaderboardData;
    }

    public static String getConfigHash() throws IOException {
        FileInputStream fis = new FileInputStream(configFile);
        String md5 = DigestUtils.md5Hex((InputStream)fis);
        fis.close();
        return md5;
    }

    static {
        TINY_GSON = new GsonBuilder().enableComplexMapKeySerialization().registerTypeAdapter(ItemStack.class, (Object)new ItemStackSerializer()).create();
    }
}

