/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.smart;

import blusunrize.immersiveengineering.api.energy.wires.WireApi;
import blusunrize.immersiveengineering.client.models.smart.ConnModelReal;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;

public class ConnLoader
implements ICustomModelLoader {
    public static final String RESOURCE_LOCATION = "models/block/smartmodel/conn_";
    public static Map<String, ImmutableMap<String, String>> textureReplacements = new HashMap<String, ImmutableMap<String, String>>();
    public static Map<String, ResourceLocation> baseModels = new HashMap<String, ResourceLocation>();

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        ConnModelReal.cache.invalidateAll();
    }

    public boolean accepts(@Nonnull ResourceLocation modelLocation) {
        return modelLocation.func_110623_a().contains(RESOURCE_LOCATION);
    }

    @Nonnull
    public IModel loadModel(@Nonnull ResourceLocation modelLocation) {
        String name;
        ResourceLocation r;
        String resourcePath = modelLocation.func_110623_a();
        int pos = resourcePath.indexOf("conn_");
        if (pos >= 0 && (r = baseModels.get(name = resourcePath.substring(pos += 5))) != null) {
            if (textureReplacements.containsKey(name)) {
                return new ConnModelBase(r, textureReplacements.get(name));
            }
            return new ConnModelBase(r);
        }
        return ModelLoaderRegistry.getMissingModel();
    }

    static {
        WireApi.registerConnectorForRender("conn_lv", new ResourceLocation("immersiveengineering:block/connector/connector_lv.obj"), null);
        WireApi.registerConnectorForRender("rel_lv", new ResourceLocation("immersiveengineering:block/connector/connector_lv.obj"), (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/connector_connector_lv", (Object)"immersiveengineering:blocks/connector_relay_lv"));
        WireApi.registerConnectorForRender("conn_mv", new ResourceLocation("immersiveengineering:block/connector/connector_mv.obj"), null);
        WireApi.registerConnectorForRender("rel_mv", new ResourceLocation("immersiveengineering:block/connector/connector_mv.obj"), (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/connector_connector_mv", (Object)"immersiveengineering:blocks/connector_relay_mv"));
        WireApi.registerConnectorForRender("conn_hv", new ResourceLocation("immersiveengineering:block/connector/connector_hv.obj"), null);
        WireApi.registerConnectorForRender("rel_hv", new ResourceLocation("immersiveengineering:block/connector/relay_hv.obj"), null);
        WireApi.registerConnectorForRender("conn_struct", new ResourceLocation("immersiveengineering:block/connector/connector_structural.obj.ie"), null);
        WireApi.registerConnectorForRender("conn_redstone", new ResourceLocation("immersiveengineering:block/connector/connector_redstone.obj.ie"), null);
        WireApi.registerConnectorForRender("conn_probe", new ResourceLocation("immersiveengineering:block/connector/connector_probe.obj.ie"), null);
        WireApi.registerConnectorForRender("breaker_off", new ResourceLocation("immersiveengineering:block/connector/breaker_switch_off.obj.ie"), null);
        WireApi.registerConnectorForRender("breaker_on", new ResourceLocation("immersiveengineering:block/connector/breaker_switch_on.obj.ie"), null);
        WireApi.registerConnectorForRender("e_meter", new ResourceLocation("immersiveengineering:block/connector/e_meter.obj"), null);
        WireApi.registerConnectorForRender("redstone_breaker", new ResourceLocation("immersiveengineering:block/connector/redstone_breaker.obj.ie"), null);
        WireApi.registerConnectorForRender("transformer_hv_left", new ResourceLocation("immersiveengineering:block/connector/transformer_hv_left.obj"), null);
        WireApi.registerConnectorForRender("transformer_hv_right", new ResourceLocation("immersiveengineering:block/connector/transformer_hv_right.obj"), null);
        WireApi.registerConnectorForRender("transformer_mv_left", new ResourceLocation("immersiveengineering:block/connector/transformer_mv_left.obj"), null);
        WireApi.registerConnectorForRender("transformer_mv_right", new ResourceLocation("immersiveengineering:block/connector/transformer_mv_right.obj"), null);
        WireApi.registerConnectorForRender("transformer_mv_post", new ResourceLocation("immersiveengineering:block/connector/transformer_post.obj"), null);
        WireApi.registerConnectorForRender("e_lantern", new ResourceLocation("immersiveengineering:block/metal_device/e_lantern.obj"), null);
        WireApi.registerConnectorForRender("e_lantern_on", new ResourceLocation("immersiveengineering:block/metal_device/e_lantern.obj"), (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/metal_device1_electric_lantern", (Object)"immersiveengineering:blocks/metal_device1_electric_lantern_on"));
        WireApi.registerConnectorForRender("floodlight", new ResourceLocation("immersiveengineering:block/metal_device/floodlight.obj.ie"), null);
        WireApi.registerConnectorForRender("floodlight_on", new ResourceLocation("immersiveengineering:block/metal_device/floodlight.obj.ie"), (ImmutableMap<String, String>)ImmutableMap.of((Object)"#immersiveengineering:blocks/metal_device1_floodlight", (Object)"immersiveengineering:blocks/metal_device1_floodlight_on"));
        WireApi.registerConnectorForRender("balloon", new ResourceLocation("immersiveengineering:block/balloon.obj.ie"), null);
        WireApi.registerConnectorForRender("razor_wire", new ResourceLocation("immersiveengineering:block/razor_wire.obj.ie"), null);
        WireApi.registerConnectorForRender("feedthrough", new ResourceLocation("immersiveengineering:block/smartmodel/feedthrough"), null);
    }

    private class ConnModelBase
    implements IModel {
        ResourceLocation base;
        ImmutableMap<String, String> texReplace;

        public ConnModelBase(ResourceLocation b, ImmutableMap<String, String> t) {
            this.base = b;
            this.texReplace = t;
        }

        public ConnModelBase(ResourceLocation b) {
            this(b, (ImmutableMap<String, String>)ImmutableMap.of());
        }

        @Nonnull
        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.base);
        }

        @Nonnull
        public Collection<ResourceLocation> getTextures() {
            try {
                ArrayList<ResourceLocation> ret = new ArrayList<ResourceLocation>(ModelLoaderRegistry.getModel((ResourceLocation)this.base).getTextures());
                for (String tex : this.texReplace.values()) {
                    ret.add(new ResourceLocation(tex));
                }
                ret.add(new ResourceLocation("immersiveengineering".toLowerCase(Locale.ENGLISH) + ":blocks/wire"));
                return ret;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Nonnull
        public IBakedModel bake(@Nonnull IModelState state, @Nonnull VertexFormat format, @Nonnull Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)this.base);
                if (model instanceof OBJModel) {
                    model = model.retexture(this.texReplace);
                    OBJModel obj = (OBJModel)model;
                    model = obj.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                }
                return new ConnModelReal(model.bake(state, format, bakedTextureGetter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

