/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.common.base.Stopwatch;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import net.darkhax.gamestages.data.GameStageSaveHandler;
import net.darkhax.gamestages.data.IStageData;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.util.BlockSnapshot;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.events.IExcavateFilter;
import oreexcavation.groups.BlockEntry;
import oreexcavation.groups.BlockGroups;
import oreexcavation.handlers.EventHandler;
import oreexcavation.overrides.ToolOverride;
import oreexcavation.overrides.ToolOverrideDefault;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ExcavateShape;
import oreexcavation.undo.BlockHistory;
import oreexcavation.undo.ExcavateHistory;
import oreexcavation.utils.BigItemStack;
import oreexcavation.utils.ToolEffectiveCheck;
import oreexcavation.utils.XPHelper;
import org.apache.logging.log4j.Level;

public class MiningAgent {
    private ItemStack blockStack = null;
    private Item origTool;
    public final List<BlockPos> minedBlocks = new ArrayList<BlockPos>();
    private final List<BlockPos> checkedBlocks = new ArrayList<BlockPos>();
    private final ArrayDeque<BlockPos> scheduled = new ArrayDeque();
    public final EntityPlayerMP player;
    public final BlockPos origin;
    public final UUID playerID;
    public EnumFacing facing = EnumFacing.SOUTH;
    public ExcavateShape shape = null;
    private final ExcavateHistory history;
    public final List<BlockEntry> blockGroup = new ArrayList<BlockEntry>();
    private final List<IExcavateFilter> filters = new ArrayList<IExcavateFilter>();
    public final IBlockState state;
    private final Block block;
    private final int meta;
    public ToolOverride toolProps = ToolOverrideDefault.DEFAULT;
    private boolean subtypes = true;
    private boolean strictSubs = false;
    public final List<BigItemStack> drops = new ArrayList<BigItemStack>();
    public int experience = 0;
    private static Method m_createStack = null;

    public MiningAgent(EntityPlayerMP player, BlockPos origin, IBlockState state) {
        this.player = player;
        this.origin = origin;
        this.playerID = player.func_110124_au();
        this.state = state;
        this.block = state.func_177230_c();
        this.meta = this.block.func_176201_c(state);
        this.history = new ExcavateHistory(player.field_70170_p.field_73011_w.getDimension());
        this.blockGroup.addAll(BlockGroups.INSTANCE.getGroup(state));
        this.strictSubs = BlockGroups.INSTANCE.isStrict(state);
        ItemStack held = player.func_184586_b(EnumHand.MAIN_HAND);
        Item item = this.origTool = held.func_190926_b() ? null : held.func_77973_b();
        if (!held.func_190926_b()) {
            ToolOverride to = ToolOverrideHandler.INSTANCE.getOverride(held);
            this.toolProps = to != null ? to : this.toolProps;
        }
    }

    public UUID getPlayerID() {
        return this.playerID;
    }

    public void setOverride(ToolOverride override) {
        this.toolProps = override;
    }

    public void addFilter(IExcavateFilter filter) {
        this.filters.add(filter);
    }

    public void init() {
        if (m_createStack != null) {
            try {
                this.blockStack = (ItemStack)m_createStack.invoke((Object)this.block, this.state);
                if (this.blockStack == null || this.blockStack.func_190926_b()) {
                    this.blockStack = null;
                }
            }
            catch (Exception e) {
                this.blockStack = null;
            }
        }
        this.subtypes = !this.strictSubs ? this.blockStack == null || !this.blockStack.func_77981_g() : false;
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                for (int k = -1; k <= 1; ++k) {
                    this.appendBlock(this.origin.func_177982_a(i, j, k));
                }
            }
        }
    }

    public MiningAgent setShape(ExcavateShape shape, EnumFacing facing) {
        this.shape = shape;
        this.facing = facing;
        return this;
    }

    public boolean tickMiner(Stopwatch timer) {
        if (this.origin == null || this.player == null || !this.player.func_70089_S() || this.minedBlocks.size() >= this.toolProps.getLimit()) {
            return true;
        }
        for (int n = 0; !(this.scheduled.isEmpty() || n >= this.toolProps.getSpeed() || this.minedBlocks.size() >= this.toolProps.getLimit() || ExcavationSettings.tpsGuard && timer.elapsed(TimeUnit.MILLISECONDS) > 40L); ++n) {
            String blockStage;
            IStageData stage;
            Item heldItem;
            ItemStack heldStack = this.player.func_184586_b(EnumHand.MAIN_HAND);
            Item item = heldItem = heldStack.func_190926_b() ? null : heldStack.func_77973_b();
            if (heldItem != this.origTool) {
                return true;
            }
            if (!this.hasEnergy(this.player)) {
                return true;
            }
            BlockPos pos = this.scheduled.poll();
            if (pos == null) continue;
            if (this.player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)this.toolProps.getRange()) {
                this.checkedBlocks.add(pos);
                continue;
            }
            IBlockState s = this.player.field_70170_p.func_180495_p(pos);
            Block b = s.func_177230_c();
            int m = b.func_176201_c(s);
            if (EventHandler.isBlockBlacklisted(s) || !b.func_176209_a(s, false)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            boolean flag = b == this.block && (this.subtypes || m == this.meta);
            boolean bl = flag = flag || BlockGroups.INSTANCE.quickCheck(this.blockGroup, s);
            if (!flag && this.blockStack != null && !this.strictSubs) {
                ItemStack stack;
                try {
                    stack = (ItemStack)m_createStack.invoke((Object)b, s);
                }
                catch (Exception e) {
                    stack = null;
                }
                if (stack != null && !stack.func_190926_b() && stack.func_77973_b() == this.blockStack.func_77973_b() && stack.func_77952_i() == this.blockStack.func_77952_i()) {
                    flag = true;
                }
            }
            if (ExcavationSettings.gamestagesInstalled && (stage = GameStageSaveHandler.getPlayerData((UUID)this.player.func_110124_au())) != null && !StringUtils.func_151246_b((String)(blockStage = BlockGroups.INSTANCE.getStage(s))) && !stage.hasStage(blockStage)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            if (!flag) continue;
            if (ExcavationSettings.maxUndos > 0) {
                this.player.field_70170_p.captureBlockSnapshots = true;
                this.player.field_70170_p.capturedBlockSnapshots.clear();
            }
            if (!ExcavationSettings.ignoreTools && !ToolEffectiveCheck.canHarvestBlock(this.player.field_70170_p, s, pos, (EntityPlayer)this.player)) {
                this.checkedBlocks.add(pos);
                continue;
            }
            if (this.player.field_71134_c.func_180237_b(pos) || this.player.field_70170_p.func_180495_p(pos).func_177230_c() == Blocks.field_150350_a) {
                if (ExcavationSettings.maxUndos > 0) {
                    this.player.field_70170_p.captureBlockSnapshots = false;
                    EventHandler.captureAgent = null;
                    while (this.player.field_70170_p.capturedBlockSnapshots.size() > 0) {
                        BlockSnapshot snap = (BlockSnapshot)this.player.field_70170_p.capturedBlockSnapshots.get(0);
                        if (pos.equals((Object)snap.getPos())) {
                            this.history.addRecordedBlock(new BlockHistory(snap));
                        }
                        this.player.field_70170_p.capturedBlockSnapshots.remove(0);
                        this.player.field_70170_p.markAndNotifyBlock(snap.getPos(), this.player.field_70170_p.func_72964_e(snap.getPos().func_177958_n() >> 4, snap.getPos().func_177952_p() >> 4), snap.getReplacedBlock(), snap.getCurrentBlock(), snap.getFlag());
                    }
                    EventHandler.captureAgent = this;
                }
                if (!this.player.func_184812_l_()) {
                    this.player.func_71024_bL().func_75113_a(this.toolProps.getExaustion());
                    if (this.toolProps.getExperience() > 0) {
                        XPHelper.addXP((EntityPlayer)this.player, -this.toolProps.getExperience(), false);
                    }
                }
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -1; j <= 1; ++j) {
                        for (int k = -1; k <= 1; ++k) {
                            this.appendBlock(pos.func_177982_a(i, j, k));
                        }
                    }
                }
                this.minedBlocks.add(pos);
            } else {
                OreExcavation.logger.warn("Block harvest failed unexpectedly.\nBlock: " + s + "\nTool: " + heldStack + "\nPos: " + pos.toString());
            }
            this.player.field_70170_p.capturedBlockSnapshots.clear();
            this.player.field_70170_p.captureBlockSnapshots = false;
            this.checkedBlocks.add(pos);
        }
        if (!this.player.func_184812_l_()) {
            XPHelper.syncXP(this.player);
        }
        return this.scheduled.size() <= 0 || this.minedBlocks.size() >= this.toolProps.getLimit();
    }

    public void appendBlock(BlockPos pos) {
        if (pos == null || this.checkedBlocks.contains(pos) || this.scheduled.contains(pos)) {
            return;
        }
        if (this.player.func_70011_f((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()) > (double)this.toolProps.getRange() || !this.player.field_70170_p.func_175723_af().func_177746_a(pos) || !this.player.func_175151_a(pos, this.facing, this.player.func_184614_ca())) {
            return;
        }
        if (this.shape != null && !this.shape.isValid(this.origin, pos, this.facing)) {
            return;
        }
        for (IExcavateFilter filter : this.filters) {
            if (filter.canHarvest(this.player, this, pos)) continue;
            return;
        }
        this.scheduled.add(pos);
    }

    private boolean hasEnergy(EntityPlayerMP player) {
        return !(!(this.toolProps.getExaustion() <= 0.0f) && player.func_71024_bL().func_75116_a() <= 0 || this.toolProps.getExperience() > 0 && XPHelper.getPlayerXP((EntityPlayer)player) < (long)this.toolProps.getExperience());
    }

    public void dropEverything() {
        MiningAgent ca = EventHandler.captureAgent;
        EventHandler.captureAgent = null;
        this.history.setRecievedStacks(this.drops);
        this.history.setRecievedXP(this.experience);
        for (BigItemStack bigStack : this.drops) {
            for (ItemStack stack : bigStack.getCombinedStacks()) {
                EntityItem eItem;
                if (!ExcavationSettings.autoPickup) {
                    eItem = new EntityItem(this.player.field_70170_p, (double)this.origin.func_177958_n() + 0.5, (double)this.origin.func_177956_o() + 0.5, (double)this.origin.func_177952_p() + 0.5, stack);
                    this.player.field_70170_p.func_72838_d((Entity)eItem);
                    continue;
                }
                eItem = new EntityItem(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, stack);
                this.player.field_70170_p.func_72838_d((Entity)eItem);
            }
        }
        if (this.experience > 0) {
            EntityXPOrb orb = ExcavationSettings.autoPickup ? new EntityXPOrb(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, this.experience) : new EntityXPOrb(this.player.field_70170_p, (double)this.origin.func_177958_n(), (double)this.origin.func_177956_o(), (double)this.origin.func_177952_p(), this.experience);
            this.player.field_70170_p.func_72838_d((Entity)orb);
        }
        this.drops.clear();
        this.experience = 0;
        EventHandler.captureAgent = ca;
    }

    public void addItemDrop(ItemStack stack) {
        for (BigItemStack bigStack : this.drops) {
            if (!bigStack.equals(stack)) continue;
            bigStack.stackSize += stack.func_190916_E();
            return;
        }
        this.drops.add(new BigItemStack(stack));
    }

    public void addExperience(int value) {
        this.experience += value;
    }

    public boolean hasMinedPosition(BlockPos pos) {
        return this.checkedBlocks.contains(pos);
    }

    public ExcavateHistory getHistory() {
        return this.history;
    }

    static {
        try {
            m_createStack = Block.class.getDeclaredMethod("func_180643_i", IBlockState.class);
            m_createStack.setAccessible(true);
        }
        catch (Exception e1) {
            try {
                m_createStack = Block.class.getDeclaredMethod("getSilkTouchDrop", IBlockState.class);
                m_createStack.setAccessible(true);
            }
            catch (Exception e2) {
                OreExcavation.logger.log(Level.INFO, "Unable to use block hooks for excavation", (Throwable)e2);
            }
        }
    }
}

