/*
 * Decompiled with CFR 0.152.
 */
package oreexcavation.handlers;

import com.google.gson.JsonObject;
import java.io.File;
import net.minecraftforge.common.config.Configuration;
import oreexcavation.core.ExcavationSettings;
import oreexcavation.core.OreExcavation;
import oreexcavation.groups.BlockBlacklist;
import oreexcavation.groups.BlockGroups;
import oreexcavation.groups.ItemBlacklist;
import oreexcavation.overrides.ToolOverrideHandler;
import oreexcavation.shapes.ShapeRegistry;
import oreexcavation.utils.JsonHelper;
import org.apache.logging.log4j.Level;

public class ConfigHandler {
    public static Configuration config;

    public static void initConfigs() {
        if (config == null) {
            OreExcavation.logger.log(Level.ERROR, "Config attempted to be loaded before it was initialised!");
            return;
        }
        config.load();
        ExcavationSettings.mineLimit = config.getInt("Limit", "general", 128, 1, Integer.MAX_VALUE, "The maximum number of blocks that can be excavated at once");
        ExcavationSettings.mineSpeed = config.getInt("Speed", "general", 64, 1, Integer.MAX_VALUE, "How many blocks per tick can be excavated");
        ExcavationSettings.mineRange = config.getInt("Range", "general", 16, 1, Integer.MAX_VALUE, "How far from the origin an excavation can travel");
        ExcavationSettings.exaustion = config.getFloat("Exaustion", "general", 0.1f, 0.0f, Float.MAX_VALUE, "Amount of exaustion per block excavated");
        ExcavationSettings.experience = config.getInt("Experience", "general", 0, 0, Integer.MAX_VALUE, "Experience cost per block excavated");
        ExcavationSettings.openHand = config.getBoolean("Open Hand", "general", true, "Allow excavation with an open hand");
        ExcavationSettings.mustHold = config.getBoolean("Must Hold", "general", true, "Allows players to cancel excavation by releasing the keys");
        ExcavationSettings.useSideHit = config.getBoolean("Use Side Hit", "general", true, "Use the side of the block hit to determine shape mining direction");
        ExcavationSettings.invertTBlacklist = config.getBoolean("Invert Tool Blacklist", "general", false, "Inverts the tool blacklist to function as a whitelist");
        ExcavationSettings.invertBBlacklist = config.getBoolean("Invert Block Blacklist", "general", false, "Inverts the block blacklist to function as a whitelist");
        ExcavationSettings.ignoreTools = config.getBoolean("Ignore Tool", "general", false, "Ignores whether or not the held tool is valid");
        ExcavationSettings.altTools = config.getBoolean("Alt Tools", "general", false, "Use alternate check for tool validity (e.g. swords on webs)");
        ExcavationSettings.toolClass = config.getBoolean("Only Standard Types", "general", false, "Limit excavation to standard tool types (Picks, Shoves, Axes & Shears)");
        ExcavationSettings.mineMode = config.getInt("Mode", "general", 0, -1, 2, "Excavation mode (-1 Disabled, 0 = Keybind, 1 = Sneak, 2 = Always)");
        ExcavationSettings.tpsGuard = config.getBoolean("TPS Guard", "general", true, "Temporarily reduces excavation speed if TPS begins to slow down");
        ExcavationSettings.autoPickup = config.getBoolean("Auto Pickup", "general", false, "Skips spawning drops in world adding them directly to your inventory");
        ExcavationSettings.allowShapes = config.getBoolean("Allow Shapes", "general", true, "Allow players to use shape mining");
        ExcavationSettings.maxUndos = config.getInt("Max Undos", "general", 0, 0, Integer.MAX_VALUE, "How many excavations should be kept in undo history (may lead to exploits or instability)");
        ExcavationSettings.gamestage = config.getString("Game Stage", "general", "", "The default game stage required to unlock excavations (requires gamestages to be installed)");
        String[] tbl = config.getStringList("Tool Blacklist", "general", new String[0], "Tools blacklisted from excavating");
        String[] bbl = config.getStringList("Block Blacklist", "general", new String[0], "Blocks blacklisted from being excavated");
        BlockBlacklist.INSTANCE.loadList(bbl);
        ItemBlacklist.INSTANCE.loadList(tbl);
        config.save();
        File fileOverrides = new File("config/oreexcavation_overrides.json");
        if (fileOverrides.exists()) {
            ToolOverrideHandler.INSTANCE.loadOverrides(JsonHelper.ReadFromFile(fileOverrides));
        } else {
            JsonObject json = ToolOverrideHandler.INSTANCE.getDefaultOverrides();
            JsonHelper.WriteToFile(fileOverrides, json);
            ToolOverrideHandler.INSTANCE.loadOverrides(json);
        }
        ShapeRegistry.INSTANCE.loadShapes(new File("config/oreexcavation_shapes.json"));
        File fileGroups = new File("config/oreexcavation_groups.json");
        if (fileGroups.exists()) {
            BlockGroups.INSTANCE.readFromJson(JsonHelper.ReadFromFile(fileGroups));
        } else {
            JsonObject json = BlockGroups.INSTANCE.getDefaultJson();
            JsonHelper.WriteToFile(fileGroups, json);
            BlockGroups.INSTANCE.readFromJson(json);
        }
    }
}

