/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.tools;

import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.items.BuildingTool;
import com.direwolf20.buildinggadgets.items.ExchangerTool;
import com.direwolf20.buildinggadgets.tools.BlacklistBlocks;
import com.direwolf20.buildinggadgets.tools.BuildingModes;
import com.direwolf20.buildinggadgets.tools.ExchangingModes;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.UndoState;
import com.direwolf20.buildinggadgets.tools.VectorTools;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class GadgetUtils {
    public static void pushUndoList(ItemStack stack, UndoState undoState) {
        NBTTagList undoStates;
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if ((undoStates = (NBTTagList)tagCompound.func_74781_a("undoStack")) == null) {
            undoStates = new NBTTagList();
        }
        if (undoStates.func_74745_c() >= 10) {
            undoStates.func_74744_a(0);
        }
        undoStates.func_74742_a((NBTBase)GadgetUtils.undoStateToNBT(undoState));
        tagCompound.func_74782_a("undoStack", (NBTBase)undoStates);
        stack.func_77982_d(tagCompound);
    }

    public static UndoState popUndoList(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagList undoStates = (NBTTagList)tagCompound.func_74781_a("undoStack");
        if (undoStates == null || undoStates.func_74745_c() == 0) {
            return null;
        }
        UndoState undoState = GadgetUtils.NBTToUndoState(undoStates.func_150305_b(undoStates.func_74745_c() - 1));
        undoStates.func_74744_a(undoStates.func_74745_c() - 1);
        tagCompound.func_74782_a("undoStack", (NBTBase)undoStates);
        return undoState;
    }

    public static NBTTagCompound undoStateToNBT(UndoState undoState) {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74768_a("dim", undoState.dimension);
        BlockPos startBlock = undoState.coordinates.get(0);
        int[] array = new int[undoState.coordinates.size()];
        int idx = 0;
        for (BlockPos coord : undoState.coordinates) {
            int px = (coord.func_177958_n() - startBlock.func_177958_n() & 0xFF) << 16;
            int py = (coord.func_177956_o() - startBlock.func_177956_o() & 0xFF) << 8;
            int pz = coord.func_177952_p() - startBlock.func_177952_p() & 0xFF;
            int p = px + py + pz;
            array[idx++] = p;
        }
        compound.func_74782_a("startBlock", (NBTBase)NBTUtil.func_186859_a((BlockPos)startBlock));
        compound.func_74783_a("undoIntCoords", array);
        return compound;
    }

    public static UndoState NBTToUndoState(NBTTagCompound compound) {
        int dim = compound.func_74762_e("dim");
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        int[] array = compound.func_74759_k("undoIntCoords");
        BlockPos startBlock = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("startBlock"));
        for (int i = 0; i <= array.length - 1; ++i) {
            int p = array[i];
            int x = startBlock.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
            int y = startBlock.func_177956_o() + (byte)((p & 0xFF00) >> 8);
            int z = startBlock.func_177952_p() + (byte)(p & 0xFF);
            coordinates.add(new BlockPos(x, y, z));
        }
        UndoState undoState = new UndoState(dim, coordinates);
        return undoState;
    }

    public static void setAnchor(ItemStack stack, ArrayList<BlockPos> coordinates) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        NBTTagList coords = new NBTTagList();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        for (BlockPos coord : coordinates) {
            coords.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)coord));
        }
        tagCompound.func_74782_a("anchorcoords", (NBTBase)coords);
        stack.func_77982_d(tagCompound);
    }

    public static ArrayList<BlockPos> getAnchor(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        ArrayList<BlockPos> coordinates = new ArrayList<BlockPos>();
        if (tagCompound == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            tagCompound = stack.func_77978_p();
            return coordinates;
        }
        NBTTagList coordList = (NBTTagList)tagCompound.func_74781_a("anchorcoords");
        if (coordList == null) {
            GadgetUtils.setAnchor(stack, coordinates);
            tagCompound = stack.func_77978_p();
            return coordinates;
        }
        if (coordList.func_74745_c() == 0) {
            return coordinates;
        }
        for (int i = 0; i < coordList.func_74745_c(); ++i) {
            coordinates.add(NBTUtil.func_186861_c((NBTTagCompound)coordList.func_150305_b(i)));
        }
        return coordinates;
    }

    public static void setToolRange(ItemStack stack, int range) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74768_a("range", range);
        stack.func_77982_d(tagCompound);
    }

    public static int getToolRange(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null || tagCompound.func_74762_e("range") == 0) {
            GadgetUtils.setToolRange(stack, 1);
            tagCompound = stack.func_77978_p();
            return 1;
        }
        return tagCompound.func_74762_e("range");
    }

    public static void setToolBlock(ItemStack stack, IBlockState state) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        NBTTagCompound stateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)stateTag, (IBlockState)state);
        tagCompound.func_74782_a("blockstate", (NBTBase)stateTag);
        stack.func_77982_d(tagCompound);
    }

    public static void setToolActualBlock(ItemStack stack, IBlockState state) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (state == null) {
            state = Blocks.field_150350_a.func_176223_P();
        }
        NBTTagCompound stateTag = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)stateTag, (IBlockState)state);
        tagCompound.func_74782_a("actualblockstate", (NBTBase)stateTag);
        stack.func_77982_d(tagCompound);
    }

    public static IBlockState getToolBlock(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            GadgetUtils.setToolBlock(stack, Blocks.field_150350_a.func_176223_P());
            tagCompound = stack.func_77978_p();
            return Blocks.field_150350_a.func_176223_P();
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("blockstate"));
    }

    public static IBlockState getToolActualBlock(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            GadgetUtils.setToolBlock(stack, Blocks.field_150350_a.func_176223_P());
            tagCompound = stack.func_77978_p();
            return Blocks.field_150350_a.func_176223_P();
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound.func_74775_l("actualblockstate"));
    }

    public static void selectBlock(ItemStack stack, EntityPlayer player) {
        TileEntity te;
        boolean validBlock = true;
        World world = player.field_70170_p;
        RayTraceResult lookingAt = VectorTools.getLookingAt(player);
        if (lookingAt == null) {
            return;
        }
        BlockPos pos = lookingAt.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        if (BlacklistBlocks.checkBlacklist(state.func_177230_c())) {
            validBlock = false;
        }
        if ((te = world.func_175625_s(pos)) != null) {
            if (te instanceof ConstructionBlockTileEntity) {
                if (((ConstructionBlockTileEntity)te).getBlockState() != null) {
                    GadgetUtils.setToolBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockState());
                    GadgetUtils.setToolActualBlock(stack, ((ConstructionBlockTileEntity)te).getActualBlockState());
                    return;
                }
                validBlock = false;
            } else {
                validBlock = false;
            }
        }
        if (!validBlock) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.invalidblock", new Object[0]).func_150261_e()), true);
            return;
        }
        if (state != null) {
            IBlockState placeState = InventoryManipulation.getSpecificStates(state, world, player, pos);
            IBlockState actualState = placeState.func_177230_c().func_176221_a(placeState, (IBlockAccess)world, pos);
            GadgetUtils.setToolBlock(stack, placeState);
            GadgetUtils.setToolActualBlock(stack, actualState);
        }
    }

    public static boolean anchorBlocks(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        ArrayList<BlockPos> currentCoords = GadgetUtils.getAnchor(stack);
        if (currentCoords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            if (startBlock == null || world.func_180495_p(startBlock) == Blocks.field_150350_a.func_176223_P()) {
                return false;
            }
            ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
            if (stack.func_77973_b() instanceof BuildingTool) {
                coords = BuildingModes.getBuildOrders(world, player, startBlock, sideHit, stack);
            } else if (stack.func_77973_b() instanceof ExchangerTool) {
                coords = ExchangingModes.getBuildOrders(world, player, startBlock, sideHit, stack);
            }
            GadgetUtils.setAnchor(stack, coords);
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorrender", new Object[0]).func_150261_e()), true);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.anchorremove", new Object[0]).func_150261_e()), true);
        }
        return true;
    }

    public static boolean useEnergy(ItemStack stack, int amount, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
        if (amount > energy.getEnergyStored()) {
            return false;
        }
        energy.extractEnergy(amount, false);
        return true;
    }

    public static String withSuffix(int count) {
        if (count < 1000) {
            return "" + count;
        }
        int exp = (int)(Math.log(count) / Math.log(1000.0));
        return String.format("%.1f%c", (double)count / Math.pow(1000.0, exp), Character.valueOf("kMGTPE".charAt(exp - 1)));
    }

    public static void writePOSToNBT(ItemStack stack, BlockPos pos, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        tagCompound.func_74782_a(tagName, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(ItemStack stack, BlockPos pos, String tagName, Integer dim) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
                stack.func_77982_d(tagCompound);
            }
            return;
        }
        NBTTagCompound posTag = NBTUtil.func_186859_a((BlockPos)pos);
        posTag.func_74768_a("dim", dim.intValue());
        tagCompound.func_74782_a(tagName, (NBTBase)posTag);
        stack.func_77982_d(tagCompound);
    }

    public static void writePOSToNBT(NBTTagCompound tagCompound, BlockPos pos, String tagName, Integer dim) {
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        if (pos == null) {
            if (tagCompound.func_74781_a(tagName) != null) {
                tagCompound.func_82580_o(tagName);
            }
            return;
        }
        tagCompound.func_74782_a(tagName, (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        tagCompound.func_74768_a("dim", dim.intValue());
    }

    public static BlockPos getPOSFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    public static BlockPos getPOSFromNBT(NBTTagCompound tagCompound, String tagName) {
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)posTag);
    }

    public static Integer getDIMFromNBT(ItemStack stack, String tagName) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagCompound posTag = tagCompound.func_74775_l(tagName);
        if (posTag.equals((Object)new NBTTagCompound())) {
            return null;
        }
        return posTag.func_74762_e("dim");
    }

    public static NBTTagCompound stateToCompound(IBlockState state) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTUtil.func_190009_a((NBTTagCompound)tagCompound, (IBlockState)state);
        return tagCompound;
    }

    public static IBlockState compoundToState(NBTTagCompound tagCompound) {
        if (tagCompound == null) {
            return null;
        }
        return NBTUtil.func_190008_d((NBTTagCompound)tagCompound);
    }

    public static int relPosToInt(BlockPos startPos, BlockPos relPos) {
        int px = (relPos.func_177958_n() - startPos.func_177958_n() & 0xFF) << 16;
        int py = (relPos.func_177956_o() - startPos.func_177956_o() & 0xFF) << 8;
        int pz = relPos.func_177952_p() - startPos.func_177952_p() & 0xFF;
        int p = px + py + pz;
        return p;
    }

    public static BlockPos relIntToPos(BlockPos startPos, int relInt) {
        int p = relInt;
        int x = startPos.func_177958_n() + (byte)((p & 0xFF0000) >> 16);
        int y = startPos.func_177956_o() + (byte)((p & 0xFF00) >> 8);
        int z = startPos.func_177952_p() + (byte)(p & 0xFF);
        return new BlockPos(x, y, z);
    }
}

