/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.items;

import com.direwolf20.buildinggadgets.Config;
import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.entities.BlockBuildEntity;
import com.direwolf20.buildinggadgets.items.FakeBuilderWorld;
import com.direwolf20.buildinggadgets.items.GenericGadget;
import com.direwolf20.buildinggadgets.tools.BuildingModes;
import com.direwolf20.buildinggadgets.tools.GadgetUtils;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.UndoState;
import com.direwolf20.buildinggadgets.tools.VectorTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class BuildingTool
extends GenericGadget {
    private static final FakeBuilderWorld fakeWorld = new FakeBuilderWorld();

    public BuildingTool() {
        this.setRegistryName("buildingtool");
        this.func_77655_b("buildinggadgets.buildingtool");
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78040_i);
        if (!Config.poweredByFE) {
            this.func_77656_e(Config.durabilityBuilder);
        }
    }

    public static void setToolMode(ItemStack stack, toolModes mode) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
        }
        tagCompound.func_74778_a("mode", mode.name());
        stack.func_77982_d(tagCompound);
    }

    public static toolModes getToolMode(ItemStack stack) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        toolModes mode = toolModes.BuildToMe;
        if (tagCompound == null) {
            BuildingTool.setToolMode(stack, mode);
            return mode;
        }
        try {
            mode = toolModes.valueOf(tagCompound.func_74779_i("mode"));
        }
        catch (Exception e) {
            BuildingTool.setToolMode(stack, mode);
        }
        return mode;
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag b) {
        super.func_77624_a(stack, player, list, b);
        list.add(TextFormatting.DARK_GREEN + I18n.func_135052_a((String)"tooltip.gadget.block", (Object[])new Object[0]) + ": " + GadgetUtils.getToolBlock(stack).func_177230_c().func_149732_F());
        list.add(TextFormatting.AQUA + I18n.func_135052_a((String)"tooltip.gadget.mode", (Object[])new Object[0]) + ": " + (Object)((Object)BuildingTool.getToolMode(stack)));
        if (BuildingTool.getToolMode(stack) != toolModes.BuildToMe) {
            list.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.gadget.range", (Object[])new Object[0]) + ": " + GadgetUtils.getToolRange(stack));
        }
        if (Config.poweredByFE) {
            IEnergyStorage energy = (IEnergyStorage)stack.getCapability(CapabilityEnergy.ENERGY, null);
            list.add(TextFormatting.WHITE + I18n.func_135052_a((String)"tooltip.gadget.energy", (Object[])new Object[0]) + ": " + GadgetUtils.withSuffix(energy.getEnergyStored()) + "/" + GadgetUtils.withSuffix(energy.getMaxEnergyStored()));
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(stack, player);
            } else {
                this.build(player, stack);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        player.func_184598_c(hand);
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                GadgetUtils.selectBlock(itemstack, player);
            } else {
                this.build(player, itemstack);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public void toggleMode(EntityPlayer player, ItemStack heldItem) {
        toolModes mode = BuildingTool.getToolMode(heldItem);
        mode = mode.next();
        BuildingTool.setToolMode(heldItem, mode);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.toolmode", new Object[0]).func_150261_e() + ": " + mode.name()), true);
    }

    public void setMode(EntityPlayer player, ItemStack heldItem, int modeInt) {
        toolModes mode = toolModes.values()[modeInt];
        BuildingTool.setToolMode(heldItem, mode);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.toolmode", new Object[0]).func_150261_e() + ": " + mode.name()), true);
    }

    public void rangeChange(EntityPlayer player, ItemStack heldItem) {
        int range = GadgetUtils.getToolRange(heldItem);
        range = player.func_70093_af() ? (range == 1 ? Config.maxRange : range - 1) : (range >= Config.maxRange ? 1 : range + 1);
        GadgetUtils.setToolRange(heldItem, range);
        player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.DARK_AQUA + new TextComponentTranslation("message.gadget.toolrange", new Object[0]).func_150261_e() + ": " + range), true);
    }

    public boolean build(EntityPlayer player, ItemStack stack) {
        World world = player.field_70170_p;
        ArrayList<BlockPos> coords = GadgetUtils.getAnchor(stack);
        if (coords.size() == 0) {
            RayTraceResult lookingAt = VectorTools.getLookingAt(player);
            if (lookingAt == null) {
                return false;
            }
            BlockPos startBlock = lookingAt.func_178782_a();
            EnumFacing sideHit = lookingAt.field_178784_b;
            coords = BuildingModes.getBuildOrders(world, player, startBlock, sideHit, stack);
        } else {
            GadgetUtils.setAnchor(stack, new ArrayList<BlockPos>());
        }
        ArrayList<BlockPos> undoCoords = new ArrayList<BlockPos>();
        HashSet<BlockPos> coordinates = new HashSet<BlockPos>(coords);
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof BuildingTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof BuildingTool)) {
            return false;
        }
        IBlockState blockState = GadgetUtils.getToolBlock(heldItem);
        if (blockState != Blocks.field_150350_a.func_176223_P()) {
            IBlockState state = Blocks.field_150350_a.func_176223_P();
            fakeWorld.setWorldAndState(player.field_70170_p, blockState, coordinates);
            for (BlockPos coordinate : coords) {
                if (fakeWorld.func_175624_G() != WorldType.field_180272_g) {
                    try {
                        state = blockState.func_185899_b((IBlockAccess)fakeWorld, coordinate);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (!BuildingTool.placeBlock(world, player, coordinate, state)) continue;
                undoCoords.add(coordinate);
            }
            if (undoCoords.size() > 0) {
                UndoState undoState = new UndoState(player.field_71093_bK, undoCoords);
                GadgetUtils.pushUndoList(heldItem, undoState);
            }
        }
        BuildingModes.sortByDistance(coords, player);
        return true;
    }

    public static boolean undoBuild(EntityPlayer player) {
        ItemStack heldItem = player.func_184614_ca();
        if (!(heldItem.func_77973_b() instanceof BuildingTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof BuildingTool)) {
            return false;
        }
        UndoState undoState = GadgetUtils.popUndoList(heldItem);
        if (undoState == null) {
            player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.AQUA + new TextComponentTranslation("message.gadget.nothingtoundo", new Object[0]).func_150261_e()), true);
            return false;
        }
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            IBlockState currentBlock = Blocks.field_150350_a.func_176223_P();
            ArrayList<BlockPos> undoCoords = undoState.coordinates;
            int dimension = undoState.dimension;
            ArrayList<BlockPos> failedRemovals = new ArrayList<BlockPos>();
            ItemStack silkTool = heldItem.func_77946_l();
            silkTool.func_77966_a(Enchantments.field_185306_r, 1);
            for (BlockPos coord : undoCoords) {
                currentBlock = world.func_180495_p(coord);
                ItemStack itemStack = currentBlock.func_177230_c().getPickBlock(currentBlock, null, world, coord, player);
                double distance = coord.func_185332_f(player.func_180425_c().func_177958_n(), player.func_180425_c().func_177956_o(), player.func_180425_c().func_177952_p());
                boolean sameDim = player.field_71093_bK == dimension;
                BlockEvent.BreakEvent e = new BlockEvent.BreakEvent(world, coord, currentBlock, player);
                boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)e);
                if (distance < 64.0 && sameDim && currentBlock != ModBlocks.effectBlock.func_176223_P() && !cancelled) {
                    if (currentBlock == Blocks.field_150350_a.func_176223_P()) continue;
                    currentBlock.func_177230_c().func_180657_a(world, player, coord, currentBlock, world.func_175625_s(coord), silkTool);
                    world.func_72838_d((Entity)new BlockBuildEntity(world, coord, (EntityLivingBase)player, currentBlock, 2, GadgetUtils.getToolActualBlock(heldItem), false));
                    continue;
                }
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + new TextComponentTranslation("message.gadget.undofailed", new Object[0]).func_150261_e()), true);
                failedRemovals.add(coord);
            }
            if (failedRemovals.size() != 0) {
                UndoState failedState = new UndoState(player.field_71093_bK, failedRemovals);
                GadgetUtils.pushUndoList(heldItem, failedState);
            }
        }
        return true;
    }

    public static boolean placeBlock(World world, EntityPlayer player, BlockPos pos, IBlockState setBlock) {
        boolean useItemSuccess;
        ItemStack heldItem = player.func_184614_ca();
        boolean useConstructionPaste = false;
        if (!(heldItem.func_77973_b() instanceof BuildingTool) && !((heldItem = player.func_184592_cb()).func_77973_b() instanceof BuildingTool)) {
            return false;
        }
        ItemStack itemStack = setBlock.func_177230_c().canSilkHarvest(world, pos, setBlock, player) ? InventoryManipulation.getSilkTouchDrop(setBlock) : setBlock.func_177230_c().getPickBlock(setBlock, null, world, pos, player);
        if (player.func_175149_v()) {
            return false;
        }
        NonNullList drops = NonNullList.func_191196_a();
        setBlock.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, setBlock, 0);
        int neededItems = 0;
        for (ItemStack drop : drops) {
            if (!drop.func_77973_b().equals(itemStack.func_77973_b())) continue;
            ++neededItems;
        }
        if (neededItems == 0) {
            neededItems = 1;
        }
        if (!world.func_175660_a(player, pos)) {
            return false;
        }
        BlockSnapshot blockSnapshot = BlockSnapshot.getBlockSnapshot((World)world, (BlockPos)pos);
        if (ForgeEventFactory.onPlayerBlockPlace((EntityPlayer)player, (BlockSnapshot)blockSnapshot, (EnumFacing)EnumFacing.UP, (EnumHand)EnumHand.MAIN_HAND).isCanceled()) {
            return false;
        }
        ItemStack constructionPaste = new ItemStack((Item)ModItems.constructionPaste);
        if (InventoryManipulation.countItem(itemStack, player) < neededItems) {
            if (InventoryManipulation.countPaste(player) < neededItems) {
                return false;
            }
            itemStack = constructionPaste.func_77946_l();
            useConstructionPaste = true;
        }
        if (Config.poweredByFE) {
            if (!GadgetUtils.useEnergy(heldItem, Config.energyCostBuilder, player)) {
                return false;
            }
        } else {
            if (heldItem.func_77952_i() >= heldItem.func_77958_k()) {
                return false;
            }
            heldItem.func_77972_a(1, (EntityLivingBase)player);
        }
        if (useItemSuccess = useConstructionPaste ? InventoryManipulation.usePaste(player, neededItems) : InventoryManipulation.useItem(itemStack, player, neededItems)) {
            world.func_72838_d((Entity)new BlockBuildEntity(world, pos, (EntityLivingBase)player, setBlock, 1, GadgetUtils.getToolActualBlock(heldItem), useConstructionPaste));
            return true;
        }
        return false;
    }

    public int func_77626_a(ItemStack stack) {
        return 20;
    }

    public static enum toolModes {
        BuildToMe,
        VerticalColumn,
        HorizontalColumn,
        VerticalWall,
        HorizontalWall,
        Stairs,
        Checkerboard;

        private static toolModes[] vals;

        public toolModes next() {
            return vals[(this.ordinal() + 1) % vals.length];
        }

        static {
            vals = toolModes.values();
        }
    }
}

