/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.eventhandlers;

import com.direwolf20.buildinggadgets.items.CopyPasteTool;
import com.direwolf20.buildinggadgets.tools.BlockMap;
import com.direwolf20.buildinggadgets.tools.InventoryManipulation;
import com.direwolf20.buildinggadgets.tools.PasteToolBufferBuilder;
import com.direwolf20.buildinggadgets.tools.UniqueItem;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TooltipRender {
    private static final int STACKS_PER_LINE = 8;

    @SideOnly(value=Side.CLIENT)
    public static void tooltipIfShift(List<String> tooltip, Runnable r) {
        if (GuiScreen.func_146272_n()) {
            r.run();
        }
    }

    @SubscribeEvent
    public static void onMakeTooltip(ItemTooltipEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = event.getItemStack();
        if (stack.func_77973_b() instanceof CopyPasteTool) {
            String UUID = CopyPasteTool.getUUID(stack);
            if (UUID == null) {
                return;
            }
            List tooltip = event.getToolTip();
            Map<UniqueItem, Integer> itemCountMap = TooltipRender.makeRequiredList(UUID);
            int count = itemCountMap.size();
            if (count > 0) {
                TooltipRender.tooltipIfShift(tooltip, () -> {
                    int lines = ((count - 1) / 8 + 1) * 2;
                    int width = Math.min(8, count) * 18;
                    String spaces = "\u00a7r\u00a7r\u00a7r\u00a7r\u00a7r";
                    while (mc.field_71466_p.func_78256_a(spaces) < width) {
                        spaces = spaces + " ";
                    }
                    for (int j = 0; j < lines; ++j) {
                        tooltip.add(spaces);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onDrawTooltip(RenderTooltipEvent.PostText event) {
        ItemStack stack = event.getStack();
        if (stack.func_77973_b() instanceof CopyPasteTool && GuiScreen.func_146272_n()) {
            String s;
            String UUID = CopyPasteTool.getUUID(stack);
            Map<UniqueItem, Integer> itemCountMap = TooltipRender.makeRequiredList(UUID);
            HashMap<ItemStack, Integer> itemStackCount = new HashMap<ItemStack, Integer>();
            for (Map.Entry<UniqueItem, Integer> entry2 : itemCountMap.entrySet()) {
                ItemStack itemStack = new ItemStack(entry2.getKey().item, 1, entry2.getKey().meta);
                itemStackCount.put(itemStack, entry2.getValue());
            }
            ArrayList list = new ArrayList(itemStackCount.entrySet());
            Comparator<Map.Entry> comparator = Comparator.comparing(entry -> (Integer)entry.getValue());
            comparator = comparator.reversed();
            comparator = comparator.thenComparing(Comparator.comparing(entry -> Item.func_150891_b((Item)((ItemStack)entry.getKey()).func_77973_b())));
            comparator = comparator.thenComparing(Comparator.comparing(entry -> ((ItemStack)entry.getKey()).func_77960_j()));
            list.sort(comparator);
            int count = itemStackCount.size();
            int bx = event.getX();
            int by = event.getY();
            List tooltip = event.getLines();
            int lines = (count - 1) / 8 + 1;
            int width = Math.min(8, count) * 18;
            int height = lines * 20 + 1;
            Iterator iterator = tooltip.iterator();
            while (iterator.hasNext() && !(s = (String)iterator.next()).trim().equals("\u00a77\u00a7r\u00a7r\u00a7r\u00a7r\u00a7r")) {
                by += 10;
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            Gui.func_73734_a((int)bx, (int)by, (int)(bx + width), (int)(by + height), (int)0x55000000);
            int j = 0;
            for (Map.Entry entry2 : list) {
                int hasAmt = InventoryManipulation.countItem((ItemStack)entry2.getKey(), (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
                int x = bx + j % 8 * 18;
                int y = by + j / 8 * 20;
                TooltipRender.renderRequiredBlocks((ItemStack)entry2.getKey(), x, y, hasAmt, (Integer)entry2.getValue());
                ++j;
            }
        }
    }

    private static void renderRequiredBlocks(ItemStack itemStack, int x, int y, int count, int req) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179097_i();
        RenderItem render = mc.func_175599_af();
        RenderHelper.func_74520_c();
        render.func_175042_a(itemStack, x, y);
        String s1 = count == Integer.MAX_VALUE ? "\u221e" : Integer.toString((int)((float)req));
        int w1 = mc.field_71466_p.func_78256_a(s1);
        int color = 0xFFFFFF;
        boolean hasReq = req > 0;
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)(x + 8 - w1 / 4), (float)(y + (hasReq ? 12 : 14)), (float)0.0f);
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        mc.field_71466_p.func_175063_a(s1, 0.0f, 0.0f, color);
        GlStateManager.func_179121_F();
        if (hasReq && count < req) {
            String fs = Integer.toString(req - count);
            String s2 = "(" + fs + ")";
            int w2 = mc.field_71466_p.func_78256_a(s2);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(x + 8 - w2 / 4), (float)(y + 17), (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
            mc.field_71466_p.func_175063_a(s2, 0.0f, 0.0f, 0xFF0000);
            GlStateManager.func_179121_F();
        }
        GlStateManager.func_179126_j();
    }

    public static Map<UniqueItem, Integer> makeRequiredList(String UUID) {
        HashMap<UniqueItem, Integer> itemCountMap = new HashMap<UniqueItem, Integer>();
        Map<IBlockState, UniqueItem> IntStackMap = CopyPasteTool.getBlockMapIntState(PasteToolBufferBuilder.getTagFromUUID(UUID)).getIntStackMap();
        ArrayList<BlockMap> blockMapList = CopyPasteTool.getBlockMapList(PasteToolBufferBuilder.getTagFromUUID(UUID));
        for (BlockMap blockMap : blockMapList) {
            UniqueItem uniqueItem = IntStackMap.get(blockMap.state);
            NonNullList drops = NonNullList.func_191196_a();
            blockMap.state.func_177230_c().getDrops(drops, (IBlockAccess)Minecraft.func_71410_x().field_71441_e, new BlockPos(0, 0, 0), blockMap.state, 0);
            int neededItems = 0;
            for (ItemStack drop : drops) {
                if (!drop.func_77973_b().equals(uniqueItem.item)) continue;
                ++neededItems;
            }
            if (neededItems == 0) {
                neededItems = 1;
            }
            if (uniqueItem.item == Items.field_190931_a) continue;
            boolean found = false;
            for (Map.Entry entry : itemCountMap.entrySet()) {
                if (!((UniqueItem)entry.getKey()).equals(uniqueItem)) continue;
                itemCountMap.put((UniqueItem)entry.getKey(), (Integer)itemCountMap.get(entry.getKey()) + neededItems);
                found = true;
                break;
            }
            if (found) continue;
            itemCountMap.put(uniqueItem, neededItems);
        }
        return itemCountMap;
    }
}

