/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.entities;

import com.direwolf20.buildinggadgets.ModBlocks;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlock;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockPowder;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class ConstructionBlockEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<BlockPos> FIXED = EntityDataManager.func_187226_a(ConstructionBlockEntity.class, (DataSerializer)DataSerializers.field_187200_j);
    private static final DataParameter<Boolean> MAKING = EntityDataManager.func_187226_a(ConstructionBlockEntity.class, (DataSerializer)DataSerializers.field_187198_h);
    public int despawning = -1;
    public int maxLife = 80;
    private BlockPos setPos;
    private EntityLivingBase spawnedBy;
    World field_70170_p;

    public ConstructionBlockEntity(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70170_p = worldIn;
    }

    public ConstructionBlockEntity(World worldIn, BlockPos spawnPos, boolean makePaste) {
        super(worldIn);
        this.func_70105_a(0.1f, 0.1f);
        this.field_70170_p = worldIn;
        this.func_70107_b(spawnPos.func_177958_n(), spawnPos.func_177956_o(), spawnPos.func_177952_p());
        this.setPos = spawnPos;
        this.setMakingPaste(makePaste);
    }

    public int getTicksExisted() {
        return this.field_70173_aa;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.maxLife) {
            this.setDespawning();
        }
        if (this.setPos != null && !(this.field_70170_p.func_180495_p(this.setPos).func_177230_c() instanceof ConstructionBlock) && !(this.field_70170_p.func_180495_p(this.setPos).func_177230_c() instanceof ConstructionBlockPowder)) {
            this.setDespawning();
        }
        if (this.isDespawning()) {
            this.despawnTick();
        }
    }

    public boolean isDespawning() {
        return this.despawning != -1;
    }

    private void setDespawning() {
        if (this.despawning == -1) {
            this.despawning = 0;
            if (this.setPos != null) {
                if (!this.getMakingPaste()) {
                    IBlockState tempState;
                    int opacity;
                    TileEntity te = this.field_70170_p.func_175625_s(this.setPos);
                    if (te instanceof ConstructionBlockTileEntity && (opacity = (tempState = ((ConstructionBlockTileEntity)te).getBlockState()).func_177230_c().getLightOpacity(tempState, (IBlockAccess)this.field_70170_p, this.setPos)) == 255) {
                        IBlockState tempSetBlock = ((ConstructionBlockTileEntity)te).getBlockState();
                        IBlockState tempActualSetBlock = ((ConstructionBlockTileEntity)te).getActualBlockState();
                        this.field_70170_p.func_175656_a(this.setPos, ModBlocks.constructionBlock.func_176223_P().func_177226_a((IProperty)ConstructionBlock.BRIGHT, (Comparable)Boolean.valueOf(false)));
                        te = this.field_70170_p.func_175625_s(this.setPos);
                        if (te instanceof ConstructionBlockTileEntity) {
                            ((ConstructionBlockTileEntity)te).setBlockState(tempSetBlock);
                            ((ConstructionBlockTileEntity)te).setActualBlockState(tempActualSetBlock);
                        }
                    }
                } else if (this.field_70170_p.func_180495_p(this.setPos) == ModBlocks.constructionBlockPowder.func_176223_P()) {
                    this.field_70170_p.func_175656_a(this.setPos, ModBlocks.constructionBlock.func_176223_P().func_177226_a((IProperty)ConstructionBlock.BRIGHT, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    private void despawnTick() {
        ++this.despawning;
        if (this.despawning > 1) {
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        this.field_70128_L = true;
    }

    public void setMakingPaste(Boolean paste) {
        this.field_70180_af.func_187227_b(MAKING, (Object)paste);
    }

    public boolean getMakingPaste() {
        return (Boolean)this.field_70180_af.func_187225_a(MAKING);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int id = additionalData.readInt();
    }

    public void writeSpawnData(ByteBuf buffer) {
        int id = -1;
        buffer.writeInt(id);
    }

    public void func_70014_b(NBTTagCompound compound) {
        compound.func_74768_a("despawning", this.despawning);
        compound.func_74768_a("ticksExisted", this.field_70173_aa);
        compound.func_74782_a("setPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.setPos));
        compound.func_74757_a("makingPaste", this.getMakingPaste());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.despawning = compound.func_74762_e("despawning");
        this.field_70173_aa = compound.func_74762_e("ticksExisted");
        this.setPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("setPos"));
        this.setMakingPaste(compound.func_74767_n("makingPaste"));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FIXED, (Object)BlockPos.field_177992_a);
        this.field_70180_af.func_187214_a(MAKING, (Object)false);
    }

    public boolean func_145770_h(double x, double y, double z) {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 0;
    }
}

