/*
 * Decompiled with CFR 0.152.
 */
package com.direwolf20.buildinggadgets.blocks;

import com.direwolf20.buildinggadgets.ModItems;
import com.direwolf20.buildinggadgets.blocks.ConstructionBlockTileEntity;
import com.direwolf20.buildinggadgets.blocks.Models.ConstructionBakedModel;
import com.direwolf20.buildinggadgets.blocks.Models.ConstructionID;
import com.direwolf20.buildinggadgets.blocks.Models.ConstructionProperty;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ConstructionBlock
extends Block
implements ITileEntityProvider {
    public static final ConstructionProperty FACADEID = new ConstructionProperty("facadeid");
    public static final PropertyBool BRIGHT = PropertyBool.func_177716_a((String)"bright");

    public ConstructionBlock() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149647_a(CreativeTabs.field_78030_b);
        this.func_149663_c("buildinggadgets.constructionblock");
        this.setRegistryName("constructionblock");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BRIGHT, (Comparable)Boolean.valueOf(true)));
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        StateMapperBase ignoreState = new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState iBlockState) {
                return ConstructionBakedModel.modelFacade;
            }
        };
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)ignoreState);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return ModItems.constructionPaste;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return false;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new ConstructionBlockTileEntity();
    }

    private static ConstructionBlockTileEntity getTE(World world, BlockPos pos) {
        return (ConstructionBlockTileEntity)world.func_175625_s(pos);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        IExtendedBlockState extendedBlockState = (IExtendedBlockState)super.getExtendedState(state, world, pos);
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        if (mimicBlock != null) {
            ConstructionID mimicID = new ConstructionID(mimicBlock);
            return extendedBlockState.withProperty((IUnlistedProperty)FACADEID, (Object)mimicID);
        }
        return extendedBlockState;
    }

    @Nullable
    protected IBlockState getActualMimicBlock(IBlockAccess blockAccess, BlockPos pos) {
        try {
            TileEntity te = blockAccess.func_175625_s(pos);
            if (te instanceof ConstructionBlockTileEntity) {
                return ((ConstructionBlockTileEntity)te).getActualBlockState();
            }
            return null;
        }
        catch (Exception var8) {
            return null;
        }
    }

    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{BRIGHT};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{FACADEID};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState mimicBlock = this.getActualMimicBlock(blockAccess, pos);
        return mimicBlock == null ? true : mimicBlock.func_177230_c().func_176225_a(mimicBlock, blockAccess, pos, side);
    }

    public boolean func_149662_c(IBlockState p_isFullBlock_1_) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        Boolean bright = (Boolean)state.func_177229_b((IProperty)BRIGHT);
        if (bright.booleanValue()) {
            return 0;
        }
        return 255;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        return mimicBlock == null ? true : mimicBlock.func_177230_c().doesSideBlockRendering(mimicBlock, world, pos, face);
    }

    @SideOnly(value=Side.CLIENT)
    public void initColorHandler(BlockColors blockColors) {
        blockColors.func_186722_a((state, world, pos, tintIndex) -> {
            IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
            return mimicBlock != null ? blockColors.func_186724_a(mimicBlock, world, pos, tintIndex) : -1;
        }, new Block[]{this});
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        IBlockState mimicBlock = this.getActualMimicBlock(worldIn, pos);
        try {
            return mimicBlock == null ? BlockFaceShape.SOLID : mimicBlock.func_177230_c().func_193383_a(worldIn, mimicBlock, pos, face);
        }
        catch (Exception var8) {
            return BlockFaceShape.SOLID;
        }
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        IBlockState mimicBlock = this.getActualMimicBlock((IBlockAccess)worldIn, pos);
        if (mimicBlock == null) {
            super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
        } else {
            try {
                mimicBlock.func_177230_c().func_185477_a(mimicBlock, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            }
            catch (Exception var8) {
                super.func_185477_a(state, worldIn, pos, entityBox, collidingBoxes, entityIn, isActualState);
            }
        }
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(worldIn, pos);
        if (mimicBlock == null) {
            return super.func_185496_a(blockState, worldIn, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_185496_a(mimicBlock, worldIn, pos);
        }
        catch (Exception var8) {
            return super.func_185496_a(blockState, worldIn, pos);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(source, pos);
        if (mimicBlock == null) {
            return super.func_185496_a(state, source, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_185496_a(mimicBlock, source, pos);
        }
        catch (Exception var8) {
            return super.func_185496_a(state, source, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock((IBlockAccess)worldIn, pos);
        if (mimicBlock == null) {
            return super.func_180640_a(state, worldIn, pos);
        }
        try {
            return mimicBlock.func_177230_c().func_180640_a(mimicBlock, worldIn, pos);
        }
        catch (Exception var8) {
            return super.func_180640_a(state, worldIn, pos);
        }
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        IBlockState mimicBlock = this.getActualMimicBlock(world, pos);
        if (mimicBlock == null) {
            return super.isNormalCube(state, world, pos);
        }
        try {
            return mimicBlock.func_177230_c().isNormalCube(mimicBlock, world, pos);
        }
        catch (Exception var8) {
            return super.isNormalCube(state, world, pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float func_185485_f(IBlockState state) {
        Boolean bright = (Boolean)state.func_177229_b((IProperty)BRIGHT);
        if (bright.booleanValue()) {
            return 1.0f;
        }
        return 0.2f;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BRIGHT, (Comparable)Boolean.valueOf(meta != 0));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)BRIGHT) != false ? 1 : 0;
    }
}

