/*
 * Decompiled with CFR 0.152.
 */
package forestry.database.gui;

import forestry.core.gui.Drawable;
import forestry.core.gui.GuiAnalyzerProvider;
import forestry.core.gui.slots.SlotFilteredInventory;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.gui.widgets.WidgetScrollBar;
import forestry.database.DatabaseHelper;
import forestry.database.DatabaseItem;
import forestry.database.gui.ContainerDatabase;
import forestry.database.gui.buttons.DatabaseButton;
import forestry.database.gui.buttons.GuiDatabaseButton;
import forestry.database.gui.widgets.WidgetDatabaseSlot;
import forestry.database.tiles.TileDatabase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiDatabase
extends GuiAnalyzerProvider<ContainerDatabase>
implements IScrollable {
    private static ResourceLocation CREATIVE_TABS = new ResourceLocation("textures/gui/container/creative_inventory/tabs.png");
    private static Drawable SCROLLBAR_SLIDER = new Drawable(CREATIVE_TABS, 232, 0, 12, 15);
    public final TileDatabase tile;
    private final ArrayList<WidgetDatabaseSlot> slots;
    private final ArrayList<DatabaseItem> sorted = new ArrayList();
    @Nullable
    private GuiTextField searchField;
    private WidgetScrollBar scrollBar;
    private boolean markedForSorting;
    @Nullable
    private DatabaseItem selectedItem;

    public GuiDatabase(TileDatabase tile, EntityPlayer player) {
        super("textures/gui/database_inventory.png", new ContainerDatabase(tile, player.field_71071_by), tile, 7, 140, 20, true, tile.getInternalInventory().func_70302_i_(), 0);
        this.tile = tile;
        this.slots = new ArrayList();
        this.field_146999_f = 218;
        this.field_147000_g = 202;
        ListIterator slotIterator = ((ContainerDatabase)this.container).field_75151_b.listIterator(36);
        while (slotIterator.hasNext()) {
            Slot slot = (Slot)slotIterator.next();
            if (!(slot instanceof SlotFilteredInventory)) continue;
            SlotFilteredInventory slotDatabase = (SlotFilteredInventory)slot;
            slotDatabase.setChangeWatcher(this);
        }
        for (int i = 0; i < 24; ++i) {
            WidgetDatabaseSlot slot = new WidgetDatabaseSlot(this.widgetManager);
            this.slots.add(slot);
            this.widgetManager.add(slot);
        }
        this.scrollBar = new WidgetScrollBar(this.widgetManager, 196, 19, 12, 90, SCROLLBAR_SLIDER);
        this.widgetManager.add(this.scrollBar);
        this.scrollBar.setParameters(this, 0, tile.func_70302_i_() / 4 - 6, 1);
        this.analyzer.init();
        this.analyzer.setSelectedSlot(-1);
    }

    @Nullable
    public DatabaseItem getSelectedItem() {
        return this.selectedItem;
    }

    public int getSize() {
        return this.sorted.size() - 1;
    }

    public int getRealSize() {
        return this.sorted.size();
    }

    public ItemStack getSelectedItemStack() {
        if (this.selectedItem == null) {
            return ItemStack.field_190927_a;
        }
        return this.selectedItem.itemStack;
    }

    public void markForSorting() {
        this.markedForSorting = true;
    }

    private void updateItems(String searchText) {
        if (this.markedForSorting) {
            this.sorted.clear();
            ArrayList<DatabaseItem> items = new ArrayList<DatabaseItem>();
            boolean firstEmpty = false;
            for (int invIndex = 0; invIndex < this.tile.func_70302_i_(); ++invIndex) {
                ItemStack stack = this.tile.func_70301_a(invIndex).func_77946_l();
                if (!stack.func_190926_b()) {
                    items.add(new DatabaseItem(stack, invIndex));
                    continue;
                }
                if (firstEmpty) continue;
                firstEmpty = true;
                items.add(new DatabaseItem(stack, invIndex));
            }
            DatabaseHelper.update(searchText, items, this.sorted);
            this.analyzer.updateSelected();
            this.updateViewedItems();
            this.markedForSorting = false;
        }
    }

    @Nullable
    public DatabaseItem getItem(int index) {
        if (this.sorted.isEmpty() || this.sorted.size() <= index || index < 0) {
            return null;
        }
        return this.sorted.get(index);
    }

    private void updateViewedItems() {
        int currentRow = this.scrollBar.getValue();
        if (currentRow < 0) {
            currentRow = 0;
        }
        int slotStart = currentRow * 4;
        int slotEnd = (currentRow + 6) * 4;
        if (slotEnd > this.tile.func_70302_i_()) {
            slotEnd = this.tile.func_70302_i_();
        }
        byte startRow = (byte)(currentRow % 2);
        int emptySlot = this.sorted.size() - 1;
        for (int invIndex = 0; invIndex < this.tile.func_70302_i_(); ++invIndex) {
            int xOffset;
            int yOffset;
            if (invIndex < slotStart || invIndex >= slotEnd) continue;
            int x = invIndex % 4;
            int y = invIndex / 4 - currentRow;
            if (startRow == 0) {
                yOffset = 25;
                xOffset = 17;
                if (y % 2 == 1) {
                    xOffset = 38;
                    yOffset = 38;
                    --y;
                }
            } else {
                yOffset = 25;
                xOffset = 38;
                if (y % 2 == 1) {
                    yOffset = 38;
                    xOffset = 17;
                    --y;
                }
            }
            int xPos = xOffset + x * 42;
            int yPos = yOffset + y / 2 * 25;
            int index = invIndex;
            if (this.sorted.size() <= index || this.sorted.isEmpty()) {
                index = emptySlot;
            }
            WidgetDatabaseSlot slot = this.slots.get(invIndex - slotStart);
            slot.update(xPos, yPos, index, index != emptySlot);
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.searchField = new GuiTextField(0, this.field_146289_q, this.field_147003_i + 101, this.field_147009_r + 6, 80, this.field_146289_q.field_78288_b);
        this.searchField.func_146203_f(50);
        this.searchField.func_146185_a(false);
        this.searchField.func_146193_g(0xFFFFFF);
        this.func_189646_b(new GuiDatabaseButton<Boolean>(0, this.field_147003_i - 18, this.field_147009_r, DatabaseHelper.ascending, this, DatabaseButton.SORT_DIRECTION_BUTTON));
        this.updateViewedItems();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        String searchText = this.searchField != null ? this.searchField.func_146179_b() : "";
        this.updateItems(searchText);
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.searchField != null && this.searchField.func_146201_a(typedChar, keyCode)) {
            this.scrollBar.setValue(0);
            this.markForSorting();
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        Slot slot = this.func_146975_c(mouseX, mouseY);
        if (slot != null && slot.getSlotIndex() == -1) {
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button instanceof GuiDatabaseButton) {
            GuiDatabaseButton databaseButton = (GuiDatabaseButton)button;
            databaseButton.onPressed();
        }
    }

    @Override
    protected void func_146976_a(float f, int mouseX, int mouseY) {
        super.func_146976_a(f, mouseX, mouseY);
        if (this.searchField != null) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            this.searchField.func_146194_f();
        }
    }

    @Override
    protected void drawBackground() {
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    @Override
    protected void addLedgers() {
    }

    @Override
    protected boolean centeredTitle() {
        return false;
    }

    @Override
    protected void drawSelectedSlot(int selectedSlot) {
    }

    @Override
    public ItemStack getSpecimen(int index) {
        DatabaseItem item = this.getSelectedItem();
        if (item == null) {
            return ItemStack.field_190927_a;
        }
        return item.itemStack;
    }

    @Override
    public boolean onUpdateSelected() {
        int index;
        int n = index = this.selectedItem == null ? -1 : this.sorted.indexOf(this.selectedItem);
        if (index >= 0) {
            this.analyzer.setSelectedSlot(index);
            return true;
        }
        return false;
    }

    @Override
    public void onSelection(int index, boolean changed) {
        this.selectedItem = index < 0 ? null : (this.sorted != null && index >= this.sorted.size() ? null : this.sorted.get(index));
    }

    @Override
    public int getSelectedSlot(int index) {
        DatabaseItem item = this.getItem(index);
        if (item == null) {
            return -1;
        }
        return 1 + item.invIndex;
    }

    @Override
    public void onScroll(int value) {
        this.updateViewedItems();
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.func_146978_c(0, 0, this.field_146999_f, this.field_147000_g, mouseX + this.field_147003_i, mouseY + this.field_147009_r);
    }

    @Override
    public void onSlotChanged(IInventory inventory, int slot) {
        super.onSlotChanged(inventory, slot);
        this.markForSorting();
    }
}

