/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import pl.asie.charset.lib.capability.CapabilityProviderFactory;
import pl.asie.charset.lib.capability.DummyCapabilityStorage;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;

@CharsetModule(name="tweak.shovelUntill", description="Left-clicking farmland with a shovel turns it back into dirt.", profile=ModuleProfile.FORCED)
public class CharsetTweakShovelUntill {
    public static final ResourceLocation capabilityLocation = new ResourceLocation("charset:shovel_untill_holder");
    @CapabilityInject(value=BlockDelayHolder.class)
    public static Capability<BlockDelayHolder> capability;
    public static CapabilityProviderFactory<BlockDelayHolder> provider;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        CapabilityManager.INSTANCE.register(BlockDelayHolder.class, (Capability.IStorage)DummyCapabilityStorage.get(), BlockDelayHolder::new);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.player.func_130014_f_().func_72820_D() % 100L == 37L && event.player.hasCapability(capability, null)) {
            ((BlockDelayHolder)event.player.getCapability(capability, null)).collectGarbage(event.player.func_130014_f_());
        }
    }

    @SubscribeEvent
    public void attachCaps(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayer) {
            if (provider == null) {
                provider = new CapabilityProviderFactory(capability);
            }
            event.addCapability(capabilityLocation, provider.create((Object)new BlockDelayHolder()));
        }
    }

    @SubscribeEvent
    public void getBreakSpeed(PlayerEvent.BreakSpeed event) {
        if (event.getEntityPlayer().hasCapability(capability, null) && !((BlockDelayHolder)event.getEntityPlayer().getCapability(capability, null)).canBreak(event.getEntityPlayer().func_130014_f_(), event.getPos())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        IBlockState state;
        if (event.getHand() != EnumHand.MAIN_HAND || event.getFace() != EnumFacing.UP) {
            return;
        }
        if (!event.getEntityPlayer().hasCapability(capability, null)) {
            return;
        }
        ItemStack tool = event.getEntityPlayer().func_184586_b(event.getHand());
        if (!tool.func_190926_b() && tool.func_77973_b().getToolClasses(tool).contains("shovel") && (state = event.getWorld().func_180495_p(event.getPos())).func_177230_c() == Blocks.field_150458_ak) {
            BlockEvent.BreakEvent fakeBreakEvent = new BlockEvent.BreakEvent(event.getWorld(), event.getPos(), state, event.getEntityPlayer());
            if (MinecraftForge.EVENT_BUS.post((Event)fakeBreakEvent)) {
                return;
            }
            ((BlockDelayHolder)Objects.requireNonNull(event.getEntityPlayer().getCapability(capability, null))).addBlock(event.getWorld(), event.getPos(), 3);
            event.getWorld().func_175656_a(event.getPos(), Blocks.field_150346_d.func_176223_P());
            event.getEntityPlayer().func_184609_a(event.getHand());
            event.setCanceled(true);
        }
    }

    public static class BlockDelayHolder {
        private final Object2LongMap<BlockPos> map = new Object2LongOpenHashMap();
        private int dimensionId = Integer.MIN_VALUE;

        public void addBlock(World world, BlockPos pos, int delay) {
            if (world.field_73011_w.getDimension() != this.dimensionId) {
                this.map.clear();
                this.dimensionId = world.field_73011_w.getDimension();
            }
            this.map.put((Object)pos, world.func_82737_E() + (long)delay);
        }

        public boolean canBreak(World world, BlockPos pos) {
            if (world.field_73011_w.getDimension() != this.dimensionId) {
                this.map.clear();
                return true;
            }
            long time = world.func_82737_E();
            return (Long)this.map.getOrDefault((Object)pos, (Object)0L) < time;
        }

        public void collectGarbage(World world) {
            if (world.field_73011_w.getDimension() != this.dimensionId) {
                this.map.clear();
                return;
            }
            long time = world.func_82737_E();
            this.map.object2LongEntrySet().removeIf(blockPosEntry -> blockPosEntry.getLongValue() < time);
        }
    }
}

