/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.module.tweak;

import net.minecraft.block.IGrowable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.lib.CharsetIMC;
import pl.asie.charset.lib.config.CharsetLoadConfigEvent;
import pl.asie.charset.lib.config.ConfigUtils;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.ItemUtils;
import pl.asie.charset.lib.utils.ThreeState;

@CharsetModule(name="tweak.rightClickHarvest", description="Harvest crops by right-clicking!", profile=ModuleProfile.FORCED)
public class CharsetTweakRightClickHarvest {
    private boolean whitelistRequired;
    @CharsetModule.Configuration
    public static Configuration config;

    @Mod.EventHandler
    public void onLoadConfig(CharsetLoadConfigEvent event) {
        this.whitelistRequired = ConfigUtils.getBoolean((Configuration)config, (String)"general", (String)"harvestingRequiresWhitelisting", (boolean)false, (String)"Does right-click-harvesting a crop require whitelisting?", (boolean)true);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        BlockPos pos;
        IBlockState state;
        World world = event.getWorld();
        if (!world.field_72995_K && event.getHand() == EnumHand.MAIN_HAND && event.getEntityPlayer().func_70093_af() && event.getEntityPlayer().func_184586_b(event.getHand()).func_190926_b() && (state = world.func_180495_p(pos = event.getPos())).func_177230_c() instanceof IGrowable && !((IGrowable)state.func_177230_c()).func_176473_a(world, pos, state, false) && !world.func_175623_d(pos.func_177977_b())) {
            ThreeState rightClickHarvest = CharsetIMC.INSTANCE.allows("rightClickHarvest", state.func_177230_c().getRegistryName()).otherwise(this.whitelistRequired ? ThreeState.NO : ThreeState.YES);
            if (rightClickHarvest == ThreeState.NO) {
                return;
            }
            NonNullList drops = NonNullList.func_191196_a();
            state.func_177230_c().getDrops(drops, (IBlockAccess)world, pos, state, 0);
            if (drops.size() >= 2) {
                ItemStack plantable = ItemStack.field_190927_a;
                for (ItemStack stack : drops) {
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IPlantable)) continue;
                    if (plantable.func_190926_b()) {
                        plantable = stack;
                        continue;
                    }
                    if (ItemUtils.canMerge((ItemStack)plantable, (ItemStack)stack)) continue;
                    return;
                }
                if (!plantable.func_190926_b()) {
                    Vec3d hVec = event.getHitVec().func_178786_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    world.func_175698_g(pos);
                    if (plantable.func_179546_a(event.getEntityPlayer(), world, pos.func_177977_b(), event.getHand(), EnumFacing.UP, (float)hVec.field_72450_a, (float)hVec.field_72448_b, (float)hVec.field_72449_c) == EnumActionResult.SUCCESS) {
                        plantable.func_190918_g(1);
                    }
                    for (ItemStack stack : drops) {
                        if (stack.func_190926_b()) continue;
                        float distance = 0.125f;
                        if (stack.func_77973_b() instanceof IPlantable) {
                            distance /= 2.0f;
                        }
                        ItemUtils.spawnItemEntity((World)world, (Vec3d)new Vec3d((Vec3i)pos).func_72441_c(0.5, 0.5, 0.5), (ItemStack)stack, (float)distance, (float)distance, (float)distance, (float)1.0f);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }
}

