/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.render.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.render.model.BaseBakedModel;

public class SimpleBakedModel
extends BaseBakedModel {
    private final List<BakedQuad>[] quads = new List[7];
    private final IBakedModel parent;
    private TextureAtlasSprite particle;
    private boolean overridesTFs = false;

    public SimpleBakedModel() {
        this(null);
    }

    public SimpleBakedModel(IBakedModel parent) {
        this.parent = parent;
        for (int i = 0; i < this.quads.length; ++i) {
            this.quads[i] = new ArrayList<BakedQuad>();
        }
    }

    public void setParticle(TextureAtlasSprite particle) {
        this.particle = particle;
    }

    public void addQuad(EnumFacing side, BakedQuad quad) {
        this.addQuads(side, quad);
    }

    public void addQuads(EnumFacing side, BakedQuad ... quads) {
        for (BakedQuad quad : quads) {
            this.quads[side == null ? 6 : side.ordinal()].add(quad);
        }
    }

    public void addQuads(EnumFacing side, Stream<BakedQuad> quads) {
        quads.forEach(quad -> this.addQuads(side, (BakedQuad)quad));
    }

    public void addQuads(EnumFacing side, Collection<BakedQuad> quads) {
        if (quads != null) {
            this.quads[side == null ? 6 : side.ordinal()].addAll(quads);
        }
    }

    public void addModel(IBakedModel model) {
        this.addModels(model);
    }

    public void addModels(IBakedModel ... models) {
        for (IBakedModel model : models) {
            for (int i = 0; i < 7; ++i) {
                this.quads[i].addAll(model.func_188616_a(null, i == 6 ? null : EnumFacing.func_82600_a((int)i), 0L));
            }
        }
    }

    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing side, long rand) {
        return this.quads[side == null ? 6 : side.ordinal()];
    }

    @Override
    public boolean func_177555_b() {
        return this.parent == null || this.parent.func_177555_b();
    }

    @Override
    public boolean func_177556_c() {
        return this.parent == null || this.parent.func_177556_c();
    }

    public TextureAtlasSprite func_177554_e() {
        if (this.particle != null) {
            return this.particle;
        }
        return this.parent != null ? this.parent.func_177554_e() : null;
    }

    @Override
    public void addTransformation(ItemCameraTransforms.TransformType type, TRSRTransformation transformation) {
        this.overridesTFs = true;
        super.addTransformation(type, transformation);
    }

    @Override
    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (this.overridesTFs) {
            return super.handlePerspective(cameraTransformType);
        }
        Pair pair = this.parent.handlePerspective(cameraTransformType);
        if (pair.getLeft() != this.parent) {
            return pair;
        }
        return ImmutablePair.of((Object)this, (Object)pair.getRight());
    }
}

