/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.modcompat.redstonepaste;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.EnumMap;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import pl.asie.charset.lib.loader.CharsetModule;
import pl.asie.charset.lib.loader.ModuleProfile;
import pl.asie.charset.lib.utils.redstone.IRedstoneGetter;
import pl.asie.charset.lib.utils.redstone.RedstoneUtils;

@CharsetModule(name="redstonepaste:lib", profile=ModuleProfile.COMPAT, dependencies={"mod:redstonepaste"})
public class CharsetCompatRedstonePaste {
    private static final Table<EnumFacing, EnumFacing, Integer> faceEdgeBit = Tables.newCustomTable(new EnumMap(EnumFacing.class), () -> new EnumMap(EnumFacing.class));
    private static final Table<EnumFacing, EnumFacing, Integer> faceEdgeBitTwo = Tables.newCustomTable(new EnumMap(EnumFacing.class), () -> new EnumMap(EnumFacing.class));

    private static void initFEB(EnumFacing face, EnumFacing edge, int v, int v2) {
        faceEdgeBit.put((Object)face, (Object)edge, (Object)v);
        faceEdgeBit.put((Object)face.func_176734_d(), (Object)edge, (Object)v);
        faceEdgeBitTwo.put((Object)face, (Object)edge, (Object)v2);
        faceEdgeBitTwo.put((Object)face.func_176734_d(), (Object)edge, (Object)v2);
    }

    @Mod.EventHandler
    public void onPostInit(FMLPostInitializationEvent event) {
        RedstoneUtils.addRedstoneGetter(new RedstoneGetterPaste());
    }

    static {
        CharsetCompatRedstonePaste.initFEB(EnumFacing.DOWN, EnumFacing.NORTH, 1, 2);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.DOWN, EnumFacing.SOUTH, 2, 0);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.DOWN, EnumFacing.WEST, 4, 1);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.DOWN, EnumFacing.EAST, 8, 3);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.WEST, EnumFacing.DOWN, 1, 2);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.WEST, EnumFacing.UP, 2, 0);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.WEST, EnumFacing.NORTH, 4, 1);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.WEST, EnumFacing.SOUTH, 8, 3);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.NORTH, EnumFacing.DOWN, 1, 2);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.NORTH, EnumFacing.UP, 2, 0);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.NORTH, EnumFacing.WEST, 4, 1);
        CharsetCompatRedstonePaste.initFEB(EnumFacing.NORTH, EnumFacing.EAST, 8, 3);
    }

    public static class RedstoneGetterPaste
    implements IRedstoneGetter {
        @Override
        public int get(IBlockAccess world, BlockPos pos, EnumFacing face, EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
            if (edge == null) {
                return -1;
            }
            TileEntity tile = world.func_175625_s(pos);
            if (tile != null && TileEntity.func_190559_a(tile.getClass()).func_110623_a().equals("redstonepastete")) {
                if (!tileEntityPredicate.test(tile)) {
                    return 0;
                }
                NBTTagCompound tag = tile.func_189515_b(new NBTTagCompound());
                if (tag.func_150297_b("facetype", 11) && tag.func_150297_b("faces", 11) && tag.func_150297_b("facedata", 11)) {
                    int idx = edge.ordinal();
                    int[] facetype = tag.func_74759_k("facetype");
                    int[] faces = tag.func_74759_k("faces");
                    int[] facedata = tag.func_74759_k("facedata");
                    if (facetype.length == 6 && faces.length == 6 && facedata.length == 6) {
                        if (facetype[idx] == 0) {
                            if ((faces[idx] & (Integer)faceEdgeBit.get((Object)edge, (Object)face.func_176734_d())) == 0) {
                                return 0;
                            }
                            return facedata[idx];
                        }
                        if (facetype[idx] == 2 || facetype[idx] == 3) {
                            return world.func_180495_p(pos).func_185911_a(world, pos, face);
                        }
                    }
                }
            }
            return -1;
        }

        @Override
        public byte[] getBundled(IBlockAccess world, BlockPos pos, EnumFacing face, @Nullable EnumFacing edge, Predicate<TileEntity> tileEntityPredicate) {
            return null;
        }
    }
}

