/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.item;

import com.mojang.authlib.GameProfile;
import mods.railcraft.api.core.items.IMinecartItem;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import pl.asie.charset.lib.item.ISubItemProvider;
import pl.asie.charset.lib.item.SubItemProviderSimple;

@Optional.Interface(iface="mods.railcraft.api.core.items.IMinecartItem", modid="Railcraft")
public abstract class ItemMinecartCharset
extends ItemMinecart
implements IMinecartItem,
ISubItemProvider.Container {
    private static final IBehaviorDispenseItem MINECART_DISPENSER_BEHAVIOR = new BehaviorDefaultDispenseItem(){
        private final BehaviorDefaultDispenseItem behaviourDefaultDispenseItem = new BehaviorDefaultDispenseItem();

        public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            World world = source.func_82618_k();
            if (!BlockRailBase.func_176563_d((IBlockState)world.func_180495_p(blockpos = source.func_180699_d().func_177972_a(facing)))) {
                return this.behaviourDefaultDispenseItem.func_82482_a(source, stack);
            }
            ((ItemMinecartCharset)stack.func_77973_b()).placeCart(null, stack, world, blockpos);
            return stack;
        }

        protected void func_82485_a(IBlockSource source) {
            source.func_82618_k().func_175718_b(1000, source.func_180699_d(), 0);
        }
    };
    private static final ItemStack MINECART = new ItemStack(Items.field_151143_au);
    private final ISubItemProvider subItemProvider;

    public ItemMinecartCharset() {
        super(EntityMinecart.Type.RIDEABLE);
        this.func_77627_a(true);
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)MINECART_DISPENSER_BEHAVIOR);
        this.subItemProvider = this.createSubItemProvider();
    }

    @Override
    public final ISubItemProvider getSubItemProvider() {
        return this.subItemProvider;
    }

    protected ISubItemProvider createSubItemProvider() {
        return new SubItemProviderSimple((Item)this);
    }

    public int func_77639_j() {
        return MINECART.func_77976_d();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            items.addAll(this.subItemProvider.getItems());
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World w, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!BlockRailBase.func_176563_d((IBlockState)w.func_180495_p(pos))) {
            return EnumActionResult.FAIL;
        }
        if (!w.field_72995_K) {
            this.placeCart(null, playerIn.func_184586_b(hand), w, pos);
        }
        return EnumActionResult.SUCCESS;
    }

    public boolean canBePlacedByNonPlayer(ItemStack cart) {
        return true;
    }

    protected abstract EntityMinecart createCart(GameProfile var1, ItemStack var2, World var3, double var4, double var6, double var8);

    public EntityMinecart placeCart(GameProfile owner, ItemStack cart, World world, BlockPos pos) {
        BlockRailBase.EnumRailDirection railDirection;
        float yOffset = 0.0625f;
        IBlockState railState = world.func_180495_p(pos);
        BlockRailBase.EnumRailDirection enumRailDirection = railDirection = BlockRailBase.func_176563_d((IBlockState)railState) ? (BlockRailBase.EnumRailDirection)railState.func_177229_b(((BlockRailBase)railState.func_177230_c()).func_176560_l()) : null;
        if (railDirection != null && railDirection.func_177018_c()) {
            yOffset += 0.5f;
        }
        EntityMinecart minecart = this.createCart(owner, cart, world, (float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + yOffset, (float)pos.func_177952_p() + 0.5f);
        cart.func_190918_g(1);
        world.func_72838_d((Entity)minecart);
        return minecart;
    }
}

