/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shadows.placebo.util.FastShapelessRecipe;

public class RecipeHelper {
    private int j = 0;
    private final String modid;
    private final String modname;
    private final List<IRecipe> recipes;

    public RecipeHelper(String modid, String modname, List<IRecipe> recipes) {
        this.modid = modid;
        this.modname = modname;
        this.recipes = recipes;
    }

    public void addRecipe(int j, IRecipe rec) {
        if (rec.getRegistryName() == null) {
            this.recipes.add((IRecipe)rec.setRegistryName(new ResourceLocation(this.modid, "recipe" + j)));
        } else {
            this.recipes.add(rec);
        }
    }

    public void addRecipe(String name, IRecipe rec) {
        if (rec.getRegistryName() == null) {
            this.recipes.add((IRecipe)rec.setRegistryName(new ResourceLocation(this.modid, name)));
        } else {
            this.recipes.add(rec);
        }
    }

    public void addShapeless(ItemStack output, Object ... inputs) {
        this.addRecipe(this.j++, (IRecipe)new FastShapelessRecipe(this.modid + ":" + this.j, output, this.createInput(inputs)));
    }

    public <T extends IForgeRegistryEntry<?>> void addShapeless(T output, Object ... inputs) {
        this.addShapeless(RecipeHelper.makeStack(output), inputs);
    }

    public void addShapeless(String group, ItemStack output, Object ... inputs) {
        this.addRecipe(this.j++, (IRecipe)new FastShapelessRecipe(this.modid + ":" + group, output, this.createInput(inputs)));
    }

    public <T extends IForgeRegistryEntry<?>> void addShapeless(String group, T output, Object ... inputs) {
        this.addShapeless(group, RecipeHelper.makeStack(output), inputs);
    }

    public void addShaped(ItemStack output, int width, int height, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)this.genShaped(output, width, height, input));
    }

    public <T extends IForgeRegistryEntry<?>> void addShaped(T output, int width, int height, Object ... input) {
        this.addShaped(RecipeHelper.makeStack(output), width, height, input);
    }

    public void addShaped(String group, ItemStack output, int width, int height, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)this.genShaped(this.modid + ":" + group, output, width, height, input));
    }

    public <T extends IForgeRegistryEntry<?>> void addShaped(String group, T output, int width, int height, Object ... input) {
        this.addShaped(group, RecipeHelper.makeStack(output), width, height, input);
    }

    public void addForgeShaped(ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        this.addRecipe(this.j++, (IRecipe)new ShapedRecipes(new ResourceLocation(this.modid, "recipe" + this.j).toString(), primer.width, primer.height, primer.input, output));
    }

    public <T extends IForgeRegistryEntry<?>> void addForgeShaped(T output, Object ... input) {
        this.addForgeShaped(RecipeHelper.makeStack(output), input);
    }

    public void addForgeShaped(String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        this.addRecipe(this.j++, (IRecipe)new ShapedRecipes(new ResourceLocation(this.modid, group).toString(), primer.width, primer.height, primer.input, output));
    }

    public void addForgeShaped(String name, String group, ItemStack output, Object ... input) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])input);
        this.addRecipe(this.j++, (IRecipe)new ShapedRecipes(new ResourceLocation(this.modid, group).toString(), primer.width, primer.height, primer.input, output).setRegistryName(this.modid, name));
    }

    public void addForgeShapeless(ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new FastShapelessRecipe(new ResourceLocation(this.modid, "recipe" + this.j).toString(), output, this.createInput(input)));
    }

    public <T extends IForgeRegistryEntry<?>> void addForgeShapeless(T output, Object ... input) {
        this.addForgeShapeless(RecipeHelper.makeStack(output), input);
    }

    public void addForgeShapeless(String group, ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new FastShapelessRecipe(new ResourceLocation(this.modid, group).toString(), output, this.createInput(input)));
    }

    public void addForgeShapeless(String name, String group, ItemStack output, Object ... input) {
        this.addRecipe(this.j++, (IRecipe)new FastShapelessRecipe(new ResourceLocation(this.modid, group).toString(), output, this.createInput(input)).setRegistryName(this.modid, name));
    }

    public ShapedRecipes genShaped(String group, ItemStack output, int l, int w, Object ... input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        }
        if (l * w != input.length) {
            throw new UnsupportedOperationException("Attempted to add invalid shaped recipe.  Complain to the author of " + this.modname);
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)CachedOreIngredient.create((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof IForgeRegistryEntry) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeHelper.makeStack((IForgeRegistryEntry)k)}));
                continue;
            }
            if (k instanceof Ingredient) {
                inputL.add(i, (Object)((Ingredient)k));
                continue;
            }
            inputL.add(i, (Object)Ingredient.field_193370_a);
        }
        return new ShapedRecipes(group, l, w, inputL, output);
    }

    public ShapedRecipes genShaped(ItemStack output, int width, int height, Object ... input) {
        return this.genShaped(this.modid + ":" + this.j, output, width, height, input);
    }

    public NonNullList<Ingredient> createInput(Object ... input) {
        if (input[0] instanceof List) {
            input = ((List)input[0]).toArray();
        } else if (input[0] instanceof Object[]) {
            input = (Object[])input[0];
        }
        NonNullList inputL = NonNullList.func_191196_a();
        for (int i = 0; i < input.length; ++i) {
            Object k = input[i];
            if (k instanceof String) {
                inputL.add(i, (Object)CachedOreIngredient.create((String)k));
                continue;
            }
            if (k instanceof ItemStack && !((ItemStack)k).func_190926_b()) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{(ItemStack)k}));
                continue;
            }
            if (k instanceof IForgeRegistryEntry) {
                inputL.add(i, (Object)Ingredient.func_193369_a((ItemStack[])new ItemStack[]{RecipeHelper.makeStack((IForgeRegistryEntry)k)}));
                continue;
            }
            if (k instanceof Ingredient) {
                inputL.add(i, (Object)((Ingredient)k));
                continue;
            }
            throw new UnsupportedOperationException("Attempted to add invalid shapeless recipe.  Complain to the author of " + this.modname);
        }
        return inputL;
    }

    public void addSimpleShapeless(ItemStack output, ItemStack input, int numInputs) {
        this.addShapeless(output, NonNullList.func_191197_a((int)numInputs, (Object)input));
    }

    public <T extends IForgeRegistryEntry<?>> void addSimpleShapeless(T output, T input, int numInputs) {
        this.addSimpleShapeless(RecipeHelper.makeStack(output), RecipeHelper.makeStack(input), numInputs);
    }

    public <T extends IForgeRegistryEntry<?>> void addSimpleShapeless(T output, ItemStack input, int numInputs) {
        this.addSimpleShapeless(RecipeHelper.makeStack(output), input, numInputs);
    }

    public <T extends IForgeRegistryEntry<?>> void addSimpleShapeless(ItemStack output, T input, int numInputs) {
        this.addSimpleShapeless(output, RecipeHelper.makeStack(input), numInputs);
    }

    public static <T extends IForgeRegistryEntry<?>> ItemStack makeStack(T thing, int size, int meta) {
        if (thing instanceof Item) {
            return new ItemStack((Item)thing, size, meta);
        }
        return new ItemStack((Block)thing, size, meta);
    }

    public static <T extends IForgeRegistryEntry<?>> ItemStack makeStack(T thing, int size) {
        return RecipeHelper.makeStack(thing, size, 0);
    }

    public static <T extends IForgeRegistryEntry<?>> ItemStack makeStack(T thing) {
        return RecipeHelper.makeStack(thing, 1, 0);
    }

    public static void replaceInAllRecipes(ItemStack old, Ingredient newThing) {
        for (IRecipe rec : ForgeRegistries.RECIPES) {
            Iterator regname;
            NonNullList list;
            if (rec instanceof IShapedRecipe) {
                list = NonNullList.func_191196_a();
                for (Ingredient ing : rec.func_192400_c()) {
                    if (ing.func_193365_a().length == 1 && OreDictionary.itemMatches((ItemStack)ing.func_193365_a()[0], (ItemStack)old, (boolean)false)) {
                        list.add((Object)newThing);
                        continue;
                    }
                    list.add((Object)ing);
                }
                regname = rec.getRegistryName();
                int width = ((IShapedRecipe)rec).getRecipeWidth();
                int height = ((IShapedRecipe)rec).getRecipeHeight();
                ForgeRegistries.RECIPES.register(new ShapedRecipes(rec.func_193358_e(), width, height, list, rec.func_77571_b()).setRegistryName((ResourceLocation)regname));
                continue;
            }
            list = NonNullList.func_191196_a();
            for (Ingredient ing : rec.func_192400_c()) {
                if (ing.func_193365_a().length == 1 && OreDictionary.itemMatches((ItemStack)ing.func_193365_a()[0], (ItemStack)old, (boolean)false)) {
                    list.add((Object)newThing);
                    continue;
                }
                list.add((Object)ing);
            }
            regname = rec.getRegistryName();
            ForgeRegistries.RECIPES.register(new FastShapelessRecipe(rec.func_193358_e(), rec.func_77571_b(), (NonNullList<Ingredient>)list).setRegistryName((ResourceLocation)regname));
        }
    }

    public static void addPotionRecipe(ItemStack input, PotionType inputPot, ItemStack reagent, ItemStack output, PotionType ontputPot) {
        BrewingRecipeRegistry.addRecipe((ItemStack)PotionUtils.func_185188_a((ItemStack)input, (PotionType)inputPot), (ItemStack)reagent, (ItemStack)PotionUtils.func_185188_a((ItemStack)output, (PotionType)ontputPot));
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(ItemStack input, PotionType inputPot, ItemStack reagent, T output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(input, inputPot, reagent, RecipeHelper.makeStack(output), outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(ItemStack input, PotionType inputPot, T reagent, T output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(input, inputPot, RecipeHelper.makeStack(reagent), RecipeHelper.makeStack(output), outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(T input, PotionType inputPot, ItemStack reagent, ItemStack output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(RecipeHelper.makeStack(input), inputPot, reagent, output, outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(T input, PotionType inputPot, T reagent, ItemStack output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(RecipeHelper.makeStack(input), inputPot, RecipeHelper.makeStack(reagent), output, outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(ItemStack input, PotionType inputPot, T reagent, ItemStack output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(input, inputPot, RecipeHelper.makeStack(reagent), output, outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(T input, PotionType inputPot, ItemStack reagent, T output, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(RecipeHelper.makeStack(input), inputPot, reagent, RecipeHelper.makeStack(output), outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(PotionType inputPot, ItemStack reagent, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(Items.field_151068_bn, inputPot, reagent, Items.field_151068_bn, outputPot);
    }

    public static <T extends IForgeRegistryEntry<?>> void addPotionRecipe(PotionType inputPot, T reagent, PotionType outputPot) {
        RecipeHelper.addPotionRecipe(Items.field_151068_bn, inputPot, RecipeHelper.makeStack(reagent), Items.field_151068_bn, outputPot);
    }

    public static class CachedOreIngredient
    extends OreIngredient {
        public static HashMap<String, CachedOreIngredient> ing = new HashMap();

        protected CachedOreIngredient(String ore) {
            super(ore);
            ing.put(ore, this);
        }

        public static CachedOreIngredient create(String ore) {
            CachedOreIngredient coi = ing.get(ore);
            return coi != null ? coi : new CachedOreIngredient(ore);
        }
    }
}

