/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.block;

import codechicken.lib.block.property.PropertyInteger;
import codechicken.lib.model.DummyBakedModel;
import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakery.CCBakeryModel;
import codechicken.lib.model.bakery.IBakeryProvider;
import codechicken.lib.model.bakery.ModelBakery;
import codechicken.lib.model.bakery.generation.IBakery;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.render.particle.CustomParticleHandler;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.vec.Cuboid6;
import cofh.api.block.IConfigGui;
import cofh.core.block.BlockCore;
import cofh.core.network.PacketHandler;
import cofh.core.render.IBlockAppearance;
import cofh.core.render.IModelRegister;
import cofh.thermaldynamics.ThermalDynamics;
import cofh.thermaldynamics.block.BlockTDBase;
import cofh.thermaldynamics.block.ItemBlockDuct;
import cofh.thermaldynamics.duct.Attachment;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.DuctItem;
import cofh.thermaldynamics.duct.TDDucts;
import cofh.thermaldynamics.duct.attachments.cover.Cover;
import cofh.thermaldynamics.duct.entity.EntityTransport;
import cofh.thermaldynamics.duct.entity.TransportHandler;
import cofh.thermaldynamics.duct.fluid.PacketFluid;
import cofh.thermaldynamics.duct.tiles.DuctUnit;
import cofh.thermaldynamics.duct.tiles.TileDuctEnergy;
import cofh.thermaldynamics.duct.tiles.TileDuctEnergySuper;
import cofh.thermaldynamics.duct.tiles.TileDuctFluid;
import cofh.thermaldynamics.duct.tiles.TileDuctItem;
import cofh.thermaldynamics.duct.tiles.TileGrid;
import cofh.thermaldynamics.duct.tiles.TileStructuralDuct;
import cofh.thermaldynamics.duct.tiles.TileTransportDuct;
import cofh.thermaldynamics.proxy.ProxyClient;
import cofh.thermaldynamics.render.DuctModelBakery;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.chisel.ctm.api.IFacade;

@Optional.Interface(iface="team.chisel.ctm.api.IFacade", modid="ctm-api")
public class BlockDuct
extends BlockTDBase
implements IBlockAppearance,
IConfigGui,
IModelRegister,
IBakeryProvider,
IFacade {
    public static final PropertyInteger META = new PropertyInteger("meta", 15);
    public static final ThreadLocal<BlockPos> IGNORE_RAY_TRACE = new ThreadLocal();
    public int offset;

    public BlockDuct(int offset) {
        super(Material.field_151592_s);
        this.func_149663_c("duct");
        this.func_149711_c(1.0f);
        this.func_149752_b(10.0f);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(0)));
        this.offset = offset * 16;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{META});
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < 16; ++i) {
            if (!TDDucts.isValid(i + this.offset)) continue;
            Duct duct = TDDucts.getDuct(i + this.offset);
            if (duct instanceof DuctItem) {
                items.add((Object)((DuctItem)duct).getVacuumItemStack());
                items.add((Object)((DuctItem)duct).getDenseItemStack());
            }
            items.add((Object)duct.itemStack.func_77946_l());
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)META, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)META);
    }

    public TileEntity func_149915_a(World world, int metadata) {
        Duct duct = TDDucts.getType(metadata + this.offset);
        return duct.factory.createTileEntity(duct, world);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entity, boolean b) {
        if (entity instanceof EntityTransport) {
            return;
        }
        float min = this.getSize(state);
        float max = 1.0f - min;
        AxisAlignedBB bb = new AxisAlignedBB((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
        TileGrid theTile = (TileGrid)world.func_175625_s(pos);
        if (theTile != null) {
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                Cover cover;
                Attachment attachment = theTile.getAttachment(i);
                if (attachment != null) {
                    attachment.addCollisionBoxesToList(entityBox, collidingBoxes, entity);
                }
                if ((cover = theTile.getCover(i)) == null) continue;
                cover.addCollisionBoxesToList(entityBox, collidingBoxes, entity);
            }
            if (theTile.getVisualConnectionType(0).renderDuct) {
                bb = new AxisAlignedBB((double)min, 0.0, (double)min, (double)max, (double)max, (double)max);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
            if (theTile.getVisualConnectionType(1).renderDuct) {
                bb = new AxisAlignedBB((double)min, (double)min, (double)min, (double)max, 1.0, (double)max);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
            if (theTile.getVisualConnectionType(2).renderDuct) {
                bb = new AxisAlignedBB((double)min, (double)min, 0.0, (double)max, (double)max, (double)max);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
            if (theTile.getVisualConnectionType(3).renderDuct) {
                bb = new AxisAlignedBB((double)min, (double)min, (double)min, (double)max, (double)max, 1.0);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
            if (theTile.getVisualConnectionType(4).renderDuct) {
                bb = new AxisAlignedBB(0.0, (double)min, (double)min, (double)max, (double)max, (double)max);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
            if (theTile.getVisualConnectionType(5).renderDuct) {
                bb = new AxisAlignedBB((double)min, (double)min, (double)min, 1.0, (double)max, (double)max);
                BlockDuct.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)bb);
            }
        }
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase living, ItemStack stack) {
        super.func_180633_a(world, pos, state, living, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGrid) {
            ((TileGrid)tile).onPlacedBy(living, stack);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        if (side == null) {
            return false;
        }
        int s = side == EnumFacing.DOWN ? 2 : (side == EnumFacing.UP ? 5 : (side == EnumFacing.NORTH ? 3 : 4));
        TileGrid theTile = (TileGrid)world.func_175625_s(pos);
        return theTile != null && theTile.getAttachment(s ^ 1) != null && theTile.getAttachment(s ^ 1).shouldRSConnect();
    }

    public boolean hasTileEntity(IBlockState state) {
        return TDDucts.isValid(this.func_176201_c(state) + this.offset);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileGrid theTile = (TileGrid)world.func_175625_s(pos);
        return theTile != null && (theTile.getCover(side.ordinal()) != null || theTile.getAttachment(side.ordinal()) != null && theTile.getAttachment(side.ordinal()).makesSideSolid()) || super.isSideSolid(base_state, world, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileGrid theTile = (TileGrid)world.func_175625_s(pos);
        if (theTile != null && theTile.getAttachment(side.ordinal() ^ 1) != null) {
            return theTile.getAttachment(side.ordinal() ^ 1).getRSOutput();
        }
        return 0;
    }

    public boolean getWeakChanges(IBlockAccess world, BlockPos pos) {
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        float min = this.getSize(state);
        float max = 1.0f - min;
        return new AxisAlignedBB((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        Cover cover;
        ItemStack pickBlock;
        TileGrid tileEntity;
        Attachment attachment;
        if (target.subHit >= 14 && target.subHit < 20 && (attachment = (tileEntity = (TileGrid)world.func_175625_s(pos)).getAttachment(target.subHit - 14)) != null && (pickBlock = attachment.getPickBlock()) != null) {
            return pickBlock;
        }
        if (target.subHit >= 20 && target.subHit < 26 && (cover = (tileEntity = (TileGrid)world.func_175625_s(pos)).getCover(target.subHit - 20)) != null && (pickBlock = cover.getPickBlock()) != null) {
            return pickBlock;
        }
        return super.getPickBlock(state, target, world, pos, player);
    }

    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        BlockPos ignore_pos = IGNORE_RAY_TRACE.get();
        if (ignore_pos != null && ignore_pos.equals((Object)pos)) {
            return null;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileGrid) {
            LinkedList<IndexedCuboid6> cuboids = new LinkedList<IndexedCuboid6>();
            ((TileGrid)tile).addTraceableCuboids(cuboids);
            return RayTracer.rayTraceCuboidsClosest((Vec3d)start, (Vec3d)end, (BlockPos)pos, cuboids);
        }
        return null;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.UNDEFINED;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGrid) {
            ((TileGrid)tileEntity).randomDisplayTick();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return ProxyClient.renderType;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGrid) {
            IBlockState state = world.func_180495_p(pos);
            TileGrid gridTile = (TileGrid)tileEntity;
            Duct duct = gridTile.getDuctType();
            float min = this.getSize(state);
            float max = 1.0f - min;
            Cuboid6 bb = new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max).add(pos);
            CustomParticleHandler.addBlockDestroyEffects((World)world, (Cuboid6)bb, (TextureAtlasSprite[])BlockDuct.getAllParticleIcons(duct), (ParticleManager)manager);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState state, World world, RayTraceResult target, ParticleManager manager) {
        TileEntity tileEntity;
        if (target != null && target.field_72313_a == RayTraceResult.Type.BLOCK && (tileEntity = world.func_175625_s(target.func_178782_a())) instanceof TileGrid) {
            TileGrid gridTile = (TileGrid)tileEntity;
            Duct duct = gridTile.getDuctType();
            float min = this.getSize(state);
            float max = 1.0f - min;
            Cuboid6 bb = new Cuboid6((double)min, (double)min, (double)min, (double)max, (double)max, (double)max).add(target.func_178782_a());
            TextureAtlasSprite[] possiblities = BlockDuct.getAllParticleIcons(duct);
            CustomParticleHandler.addBlockHitEffects((World)world, (Cuboid6)bb, (EnumFacing)target.field_178784_b, (TextureAtlasSprite)possiblities[world.field_73012_v.nextInt(possiblities.length)], (ParticleManager)manager);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite[] getAllParticleIcons(Duct duct) {
        HashSet<TextureAtlasSprite> sprites = new HashSet<TextureAtlasSprite>();
        if (duct.iconBaseTexture != null) {
            sprites.add(duct.iconBaseTexture);
        }
        if (duct.iconConnectionTexture != null) {
            sprites.add(duct.iconConnectionTexture);
        }
        if (duct.iconFluidTexture != null) {
            sprites.add(duct.iconFluidTexture);
        }
        if (duct.iconFrameTexture != null) {
            sprites.add(duct.iconFrameTexture);
        }
        if (duct.iconFrameBandTexture != null) {
            sprites.add(duct.iconFrameBandTexture);
        }
        if (duct.iconFrameFluidTexture != null) {
            sprites.add(duct.iconFrameFluidTexture);
        }
        if (sprites.isEmpty()) {
            sprites.add(TextureUtils.getMissingSprite());
        }
        return sprites.toArray(new TextureAtlasSprite[0]);
    }

    public IBlockState getVisualState(IBlockAccess world, BlockPos pos, EnumFacing side) {
        Cover cover;
        if (side == null) {
            return world.func_180495_p(pos);
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileGrid && (cover = ((TileGrid)tileEntity).getCover(side.ordinal())) != null) {
            return cover.state;
        }
        return world.func_180495_p(pos);
    }

    public boolean supportsVisualConnections() {
        return true;
    }

    @Nonnull
    @Optional.Method(modid="ctm-api")
    public IBlockState getFacade(@Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nullable EnumFacing side) {
        return this.getVisualState(world, pos, side);
    }

    public boolean openConfigGui(World world, BlockPos pos, EnumFacing side, EntityPlayer player) {
        TileGrid tile = (TileGrid)world.func_175625_s(pos);
        if (tile instanceof IConfigGui) {
            return ((IConfigGui)tile).openConfigGui(world, pos, side, player);
        }
        if (tile != null) {
            Attachment attachment;
            int subHit = side.ordinal();
            if (world instanceof World) {
                RayTraceResult rayTrace = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (BlockPos)pos);
                if (rayTrace == null) {
                    return false;
                }
                if (subHit > 13 && subHit < 20) {
                    subHit = rayTrace.subHit - 14;
                }
            }
            if (subHit > 13 && subHit < 20 && (attachment = tile.getAttachment(subHit - 14)) instanceof IConfigGui) {
                return ((IConfigGui)attachment).openConfigGui(world, pos, side, player);
            }
            for (DuctUnit ductUnit : tile.getDuctUnits()) {
                if (!(ductUnit instanceof IConfigGui)) continue;
                return ((IConfigGui)ductUnit).openConfigGui(world, pos, side, player);
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModels() {
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMap.Builder().func_178442_a(new IProperty[]{META}).func_178441_a());
        ModelResourceLocation normalLocation = new ModelResourceLocation(this.getRegistryName(), "normal");
        ModelRegistryHelper.register((ModelResourceLocation)normalLocation, (IBakedModel)new DummyBakedModel());
        ModelResourceLocation invLocation = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> invLocation);
        ModelBakery.registerItemKeyGenerator((Item)ItemBlock.func_150898_a((Block)this), item -> {
            StringBuilder builder = new StringBuilder(item.func_77973_b().getRegistryName() + "|" + item.func_77952_i());
            builder.append(",weight=").append(BlockDuct.getWeight(item));
            return builder.toString();
        });
        ModelRegistryHelper.register((ModelResourceLocation)invLocation, (IBakedModel)new CCBakeryModel());
    }

    @SideOnly(value=Side.CLIENT)
    public IBakery getBakery() {
        return DuctModelBakery.INSTANCE;
    }

    public boolean preInit() {
        ForgeRegistries.BLOCKS.register(this.setRegistryName("duct_" + this.offset));
        ForgeRegistries.ITEMS.register(new ItemBlockDuct((BlockCore)this).setRegistryName("duct_" + this.offset));
        for (int i = 0; i < 16; ++i) {
            if (!TDDucts.isValid(this.offset + i)) continue;
            TDDucts.getType((int)(this.offset + i)).itemStack = new ItemStack((Block)this, 1, i);
        }
        GameRegistry.registerTileEntity(TileDuctEnergy.Basic.class, (String)"thermaldynamics:duct_energy_basic");
        GameRegistry.registerTileEntity(TileDuctEnergy.Hardened.class, (String)"thermaldynamics:duct_energy_hardened");
        GameRegistry.registerTileEntity(TileDuctEnergy.Reinforced.class, (String)"thermaldynamics:duct_energy_reinforced");
        GameRegistry.registerTileEntity(TileDuctEnergy.Signalum.class, (String)"thermaldynamics:duct_energy_signalum");
        GameRegistry.registerTileEntity(TileDuctEnergy.Resonant.class, (String)"thermaldynamics:duct_energy_resonant");
        GameRegistry.registerTileEntity(TileDuctEnergySuper.class, (String)"thermaldynamics:duct_energy_super");
        GameRegistry.registerTileEntity(TileDuctFluid.Basic.Transparent.class, (String)"thermaldynamics:duct_fluid_fragile_transparent");
        GameRegistry.registerTileEntity(TileDuctFluid.Basic.Opaque.class, (String)"thermaldynamics:duct_fluid_fragile_opaque");
        GameRegistry.registerTileEntity(TileDuctFluid.Hardened.Transparent.class, (String)"thermaldynamics:duct_fluid_hardened_transparent");
        GameRegistry.registerTileEntity(TileDuctFluid.Hardened.Opaque.class, (String)"thermaldynamics:duct_fluid_hardened_opaque");
        GameRegistry.registerTileEntity(TileDuctFluid.Energy.Transparent.class, (String)"thermaldynamics:duct_fluid_energy_transparent");
        GameRegistry.registerTileEntity(TileDuctFluid.Energy.Opaque.class, (String)"thermaldynamics:duct_fluid_energy_opaque");
        GameRegistry.registerTileEntity(TileDuctFluid.Super.Transparent.class, (String)"thermaldynamics:duct_fluid_super_transparent");
        GameRegistry.registerTileEntity(TileDuctFluid.Super.Opaque.class, (String)"thermaldynamics:duct_fluid_super_opaque");
        GameRegistry.registerTileEntity(TileDuctItem.Basic.Transparent.class, (String)"thermaldynamics:duct_item_transparent");
        GameRegistry.registerTileEntity(TileDuctItem.Basic.Opaque.class, (String)"thermaldynamics:duct_item_opaque");
        GameRegistry.registerTileEntity(TileDuctItem.Fast.Transparent.class, (String)"thermaldynamics:duct_item_fast_transparent");
        GameRegistry.registerTileEntity(TileDuctItem.Fast.Opaque.class, (String)"thermaldynamics:duct_item_fast_opaque");
        GameRegistry.registerTileEntity(TileDuctItem.Energy.Transparent.class, (String)"thermaldynamics:duct_item_energy_transparent");
        GameRegistry.registerTileEntity(TileDuctItem.Energy.Opaque.class, (String)"thermaldynamics:duct_item_energy_opaque");
        GameRegistry.registerTileEntity(TileDuctItem.EnergyFast.Transparent.class, (String)"thermaldynamics:duct_item_energy_fast_transparent");
        GameRegistry.registerTileEntity(TileDuctItem.EnergyFast.Opaque.class, (String)"thermaldynamics:duct_item_energy_fast_opaque");
        GameRegistry.registerTileEntity(TileStructuralDuct.class, (String)"thermaldynamics:duct_structure");
        GameRegistry.registerTileEntity(TileTransportDuct.class, (String)"thermaldynamics:duct_transport_basic");
        GameRegistry.registerTileEntity(TileTransportDuct.LongRange.class, (String)"thermaldynamics:duct_transport_long_range");
        GameRegistry.registerTileEntity(TileTransportDuct.Linking.class, (String)"thermaldynamics:duct_transport_linking");
        ThermalDynamics.proxy.addIModelRegister(this);
        return true;
    }

    public boolean initialize() {
        if (this.offset != 0) {
            return false;
        }
        PacketHandler.INSTANCE.registerPacket(PacketFluid.class);
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("thermaldynamics:transport"), EntityTransport.class, (String)"transport", (int)0, (Object)ThermalDynamics.instance, (int)64, (int)1, (boolean)true);
        MinecraftForge.EVENT_BUS.register((Object)TransportHandler.INSTANCE);
        FMLCommonHandler.instance().bus().register((Object)TransportHandler.INSTANCE);
        this.addRecipes();
        return true;
    }

    private void addRecipes() {
    }

    public static byte getWeight(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return 0;
        }
        return stack.func_77978_p().func_74771_c("DenseType");
    }

    public float getSize(IBlockState state) {
        return TDDucts.getDuct(this.offset + this.func_176201_c(state)).isLargeTube() ? 0.05f : 0.3f;
    }

    public static enum ConnectionType {
        NONE(false),
        STRUCTURE_CLEAN,
        DUCT,
        CLEAN_DUCT,
        STRUCTURE_CONNECTION,
        TILE_CONNECTION;

        private final boolean renderDuct;

        private ConnectionType() {
            this(true);
        }

        private ConnectionType(boolean renderDuct) {
            this.renderDuct = renderDuct;
        }

        public static ConnectionType getPriority(ConnectionType a, ConnectionType b) {
            if (a.ordinal() < b.ordinal()) {
                return b;
            }
            return a;
        }

        public boolean renderDuct() {
            return this.renderDuct;
        }
    }
}

