/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.Random;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class MathUtils {
    public static int parseInteger(String string) {
        int value;
        try {
            value = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        return value;
    }

    public static int randomIntInRange(int min, int max) {
        Random rand = new Random();
        return rand.nextInt(max - min + 1) + min;
    }

    public static int scaleToRedstone(double currentAmount, double max) {
        double proportion = currentAmount / max;
        if (currentAmount <= 0.0) {
            return 0;
        }
        if (currentAmount >= max) {
            return 15;
        }
        return (int)Math.round(proportion * 13.0 + 1.0);
    }

    public static double tickToSec(int ticks) {
        return (double)ticks / 20.0;
    }

    @SideOnly(value=Side.CLIENT)
    public static String tickToSecFormatted(int ticks) {
        double result = MathUtils.tickToSec(ticks);
        if (result == 0.0) {
            return result + " " + I18n.func_135052_a((String)"pe.misc.seconds", (Object[])new Object[0]) + " (" + I18n.func_135052_a((String)"pe.misc.every_tick", (Object[])new Object[0]) + ")";
        }
        return result + " " + I18n.func_135052_a((String)"pe.misc.seconds", (Object[])new Object[0]);
    }

    public static int secToTicks(double secs) {
        return (int)Math.round(secs * 20.0);
    }
}

