/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.network;

import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import ftblag.thaumicgrid.grid.container.ContainerThaumicGrid;
import ftblag.thaumicgrid.grid.network.NetworkNodeThaumicGrid;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mezz.jei.api.gui.IGuiIngredient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageThaumicGridTransfer
extends MessageHandlerPlayerToServer<MessageThaumicGridTransfer>
implements IMessage {
    private Map<Integer, ? extends IGuiIngredient<ItemStack>> inputs;
    private List<Slot> slots;
    private ItemStack[][] recipe = new ItemStack[9][];

    public MessageThaumicGridTransfer() {
    }

    public MessageThaumicGridTransfer(boolean b, Map<Integer, ? extends IGuiIngredient<ItemStack>> inputs1, List<Slot> slots1) {
        this.inputs = inputs1;
        if (b) {
            this.slots = slots1;
        } else {
            ArrayList<Slot> slot = new ArrayList<Slot>();
            for (int i = 0; i < 9; ++i) {
                slot.add(slots1.get(i));
            }
            this.slots = slot;
        }
    }

    public void fromBytes(ByteBuf buf) {
        int slots = buf.readInt();
        this.recipe = new ItemStack[slots][];
        for (int i = 0; i < slots; ++i) {
            int ingredients = buf.readInt();
            this.recipe[i] = new ItemStack[ingredients];
            for (int j = 0; j < ingredients; ++j) {
                this.recipe[i][j] = StackUtils.readItemStack((ByteBuf)buf);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slots.size());
        int inputSize = 0;
        for (IGuiIngredient<ItemStack> iGuiIngredient : this.inputs.values()) {
            if (!iGuiIngredient.isInput()) continue;
            ++inputSize;
        }
        for (Slot slot : this.slots) {
            IGuiIngredient<ItemStack> ingredient = null;
            if (inputSize == 2) {
                int slotInd = slot.getSlotIndex();
                switch (slotInd) {
                    case 0: 
                    case 1: {
                        ingredient = this.inputs.get(slotInd + 1);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        ingredient = this.inputs.get(slotInd + 1 - 7);
                    }
                }
            } else if (inputSize == 4) {
                int slotInd = slot.getSlotIndex();
                switch (slotInd) {
                    case 0: 
                    case 1: {
                        ingredient = this.inputs.get(slotInd + 1);
                        break;
                    }
                    case 3: 
                    case 4: {
                        ingredient = this.inputs.get(slotInd + 1 - 1);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        ingredient = this.inputs.get(slotInd + 1 - 5);
                    }
                }
            } else {
                ingredient = this.inputs.get(slot.getSlotIndex() + 1);
            }
            ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>();
            if (ingredient != null) {
                for (ItemStack possibleStack : ingredient.getAllIngredients()) {
                    if (possibleStack == null) continue;
                    ingredients.add(possibleStack);
                }
            }
            buf.writeInt(ingredients.size());
            for (ItemStack possibleStack : ingredients) {
                StackUtils.writeItemStack((ByteBuf)buf, (ItemStack)possibleStack);
            }
        }
    }

    public void handle(MessageThaumicGridTransfer message, EntityPlayerMP player) {
        if (player.field_71070_bA instanceof ContainerThaumicGrid) {
            NetworkNodeThaumicGrid grid = ((ContainerThaumicGrid)player.field_71070_bA).getGrid();
            grid.onRecipeTransfer((EntityPlayer)player, message.recipe);
        }
    }
}

