/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.storage;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.network.security.Permission;
import com.raoulvdberge.refinedstorage.api.storage.IStorageCacheListener;
import com.raoulvdberge.refinedstorage.api.storage.IStorageTracker;
import ftblag.thaumicgrid.network.MessageThaumicGridItemDelta;
import ftblag.thaumicgrid.network.MessageThaumicGridItemUpdate;
import ftblag.thaumicgrid.network.NetworkHandler;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.lang3.tuple.Pair;

public class StorageCacheListenerThaumicGridItem
implements IStorageCacheListener<ItemStack> {
    private EntityPlayerMP player;
    private INetwork network;

    public StorageCacheListenerThaumicGridItem(EntityPlayerMP player, INetwork network) {
        this.player = player;
        this.network = network;
    }

    public void onAttached() {
        NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridItemUpdate(this.network, this.network.getSecurityManager().hasPermission(Permission.AUTOCRAFTING, (EntityPlayer)this.player)), this.player);
    }

    public void onInvalidated() {
    }

    public void onChanged(@Nonnull ItemStack stack, int size) {
        NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridItemDelta(this.network, (IStorageTracker<ItemStack>)this.network.getItemStorageTracker(), stack, size), this.player);
    }

    public void onChangedBulk(@Nonnull List<Pair<ItemStack, Integer>> stacks) {
        NetworkHandler.network.sendTo((IMessage)new MessageThaumicGridItemDelta(this.network, (IStorageTracker<ItemStack>)this.network.getItemStorageTracker(), stacks), this.player);
    }
}

