/*
 * Decompiled with CFR 0.152.
 */
package ftblag.thaumicgrid.grid.gui;

import com.google.common.collect.Lists;
import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSKeyBindings;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.IResizableDisplay;
import com.raoulvdberge.refinedstorage.gui.control.Scrollbar;
import com.raoulvdberge.refinedstorage.gui.control.SideButton;
import com.raoulvdberge.refinedstorage.gui.control.SideButtonRedstoneMode;
import com.raoulvdberge.refinedstorage.gui.control.TabList;
import com.raoulvdberge.refinedstorage.gui.control.TextFieldSearch;
import com.raoulvdberge.refinedstorage.gui.grid.stack.GridStackItem;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.gui.grid.view.IGridView;
import com.raoulvdberge.refinedstorage.util.RenderUtils;
import com.raoulvdberge.refinedstorage.util.TimeUtils;
import ftblag.thaumicgrid.grid.container.ContainerThaumicGrid;
import ftblag.thaumicgrid.grid.container.inventory.InventoryThaumicCrafting;
import ftblag.thaumicgrid.grid.gui.GuiThaumicGridCraftingSettings;
import ftblag.thaumicgrid.grid.gui.button.SideButtonThaumicGridSearchBoxMode;
import ftblag.thaumicgrid.grid.gui.button.SideButtonThaumicGridSize;
import ftblag.thaumicgrid.grid.gui.button.SideButtonThaumicGridSortingDirection;
import ftblag.thaumicgrid.grid.gui.button.SideButtonThaumicGridSortingType;
import ftblag.thaumicgrid.grid.gui.button.SideButtonThaumicGridViewType;
import ftblag.thaumicgrid.grid.gui.sorting.IThaumicGridSorter;
import ftblag.thaumicgrid.grid.gui.sorting.ThaumicGridSorterID;
import ftblag.thaumicgrid.grid.gui.sorting.ThaumicGridSorterInventoryTweaks;
import ftblag.thaumicgrid.grid.gui.sorting.ThaumicGridSorterLastModified;
import ftblag.thaumicgrid.grid.gui.sorting.ThaumicGridSorterName;
import ftblag.thaumicgrid.grid.gui.sorting.ThaumicGridSorterQuantity;
import ftblag.thaumicgrid.grid.gui.view.ThaumicGridViewItem;
import ftblag.thaumicgrid.grid.network.IThaumicGrid;
import ftblag.thaumicgrid.grid.network.NetworkNodeThaumicGrid;
import ftblag.thaumicgrid.grid.tile.TileThaumicGrid;
import ftblag.thaumicgrid.network.MessageThaumicGridClear;
import ftblag.thaumicgrid.network.MessageThaumicGridItemInsertHeld;
import ftblag.thaumicgrid.network.MessageThaumicGridItemPull;
import ftblag.thaumicgrid.network.NetworkHandler;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.ContainerDummy;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.common.blocks.world.ore.ShardType;
import thaumcraft.common.items.casters.CasterManager;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class GuiThaumicGrid
extends GuiBase
implements IResizableDisplay {
    private IGridView view;
    private TextFieldSearch searchField;
    private NetworkNodeThaumicGrid grid;
    private TabList tabs;
    private boolean wasConnected;
    private int slotNumber;

    public GuiThaumicGrid(ContainerThaumicGrid container, final NetworkNodeThaumicGrid grid) {
        super((Container)container, 227, 0);
        LinkedList<IThaumicGridSorter> sorters = new LinkedList<IThaumicGridSorter>();
        ThaumicGridSorterName defaultSorter = new ThaumicGridSorterName();
        sorters.add(defaultSorter);
        sorters.add(new ThaumicGridSorterQuantity());
        sorters.add(new ThaumicGridSorterID());
        sorters.add(new ThaumicGridSorterInventoryTweaks());
        sorters.add(new ThaumicGridSorterLastModified());
        this.grid = grid;
        this.view = new ThaumicGridViewItem(this, defaultSorter, sorters);
        this.wasConnected = this.grid.isActive();
        this.tabs = new TabList((GuiBase)this, new GuiBase.ElementDrawers((GuiBase)this), grid::getTabs, grid::getTotalTabPages, grid::getTabPage, grid::getTabSelected, 6);
        this.tabs.addListener(new TabList.ITabListListener(){

            public void onSelectionChanged(int tab) {
                grid.onTabSelectionChanged(tab);
            }

            public void onPageChanged(int page) {
                grid.onTabPageChanged(page);
            }
        });
    }

    protected void calcHeight() {
        this.screenHeight = this.field_147000_g = this.getTopHeight() + this.getBottomHeight() + this.getVisibleRows() * 18 + this.tabs.getHeight();
    }

    public void init(int x, int y) {
        ((ContainerThaumicGrid)this.field_147002_h).initSlots();
        this.tabs.init(this.field_146999_f - 32);
        this.scrollbar = new Scrollbar(174, this.tabs.getHeight() + this.getTopHeight(), 12, this.getVisibleRows() * 18 - 2);
        if (this.grid instanceof NetworkNodeThaumicGrid) {
            this.addSideButton((SideButton)new SideButtonRedstoneMode((GuiBase)this, TileThaumicGrid.REDSTONE_MODE));
        }
        int sx = x + 80 + 1;
        int sy = y + 6 + 1 + this.tabs.getHeight();
        if (this.searchField == null) {
            this.searchField = new TextFieldSearch(0, this.field_146289_q, sx, sy, 82);
            this.searchField.addListener(() -> ((IGridView)this.view).sort());
            this.searchField.setMode(this.grid.getSearchBoxMode());
        } else {
            this.searchField.field_146209_f = sx;
            this.searchField.field_146210_g = sy;
        }
        if (this.grid.getViewType() != -1) {
            this.addSideButton(new SideButtonThaumicGridViewType(this, this.grid));
        }
        this.addSideButton(new SideButtonThaumicGridSortingDirection(this, this.grid));
        this.addSideButton(new SideButtonThaumicGridSortingType(this, this.grid));
        this.addSideButton(new SideButtonThaumicGridSearchBoxMode(this));
        this.addSideButton(new SideButtonThaumicGridSize(this, () -> this.grid.getSize(), size -> this.grid.onSizeChanged((int)size)));
        this.updateScrollbar();
    }

    protected int getSideButtonYStart() {
        return super.getSideButtonYStart() + this.tabs.getHeight();
    }

    public IThaumicGrid getGrid() {
        return this.grid;
    }

    public IGridView getView() {
        return this.view;
    }

    public void update(int x, int y) {
        if (this.wasConnected != this.grid.isActive()) {
            this.wasConnected = this.grid.isActive();
            this.view.sort();
        }
        this.tabs.update();
    }

    public int getTopHeight() {
        return 19;
    }

    public int getBottomHeight() {
        return 156;
    }

    public int getYPlayerInventory() {
        int yp = this.tabs.getHeight() + this.getTopHeight() + this.getVisibleRows() * 18;
        return yp += 73;
    }

    public int getRows() {
        return Math.max(0, (int)Math.ceil((float)this.view.getStacks().size() / 9.0f));
    }

    public int getCurrentOffset() {
        return this.scrollbar.getOffset();
    }

    public String getSearchFieldText() {
        return this.searchField == null ? "" : this.searchField.func_146179_b();
    }

    public int getVisibleRows() {
        switch (this.grid.getSize()) {
            case 0: {
                int screenSpaceAvailable = this.field_146295_m - this.getTopHeight() - this.getBottomHeight() - this.tabs.getHeight();
                return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, RS.INSTANCE.config.maxRowsStretch));
            }
            case 1: {
                return 3;
            }
            case 2: {
                return 5;
            }
            case 3: {
                return 8;
            }
        }
        return 3;
    }

    private boolean isOverSlotWithStack() {
        return this.grid.isActive() && this.isOverSlot() && this.slotNumber < this.view.getStacks().size();
    }

    private boolean isOverSlot() {
        return this.slotNumber >= 0;
    }

    public boolean isOverSlotArea(int mouseX, int mouseY) {
        return this.inBounds(7, 19 + this.tabs.getHeight(), 162, 18 * this.getVisibleRows(), mouseX, mouseY);
    }

    public int getSlotNumber() {
        return this.slotNumber;
    }

    private boolean isOverClear(int mouseX, int mouseY) {
        int y = this.tabs.getHeight() + this.getTopHeight() + this.getVisibleRows() * 18 + 4;
        return this.inBounds(104, y, 7, 7, mouseX, mouseY);
    }

    public void drawBackground(int x, int yz, int mouseX, int mouseY) {
        this.tabs.drawBackground(x, yz);
        this.bindTexture("thaumicgrid", "gui/thaumic_grid.png");
        int yy = yz + this.tabs.getHeight();
        this.drawTexture(x, yy, 0, 0, this.screenWidth - 34, this.getTopHeight());
        this.drawTexture(x + this.screenWidth - 34 + 4, yz + this.tabs.getHeight(), 197, 0, 30, 82);
        int rows = this.getVisibleRows();
        for (int i = 0; i < rows; ++i) {
            this.drawTexture(x, yy += 18, 0, this.getTopHeight() + (i > 0 ? (i == rows - 1 ? 36 : 18) : 0), this.screenWidth - 34, 18);
        }
        this.drawTexture(x, yy += 18, 0, this.getTopHeight() + 54, this.screenWidth - 34, this.getBottomHeight());
        this.drawTC(x, yz, mouseX, mouseY);
        this.tabs.drawForeground(x, yz, mouseX, mouseY, true);
        if (this.searchField != null) {
            this.searchField.func_146194_f();
        }
        int cost = 0;
        int discount = 0;
        InventoryThaumicCrafting ic = new InventoryThaumicCrafting(((ContainerThaumicGrid)this.field_147002_h).getGrid(), (Container)new ContainerDummy());
        for (int z = 0; z < 15; ++z) {
            ic.func_70299_a(z, ((ContainerThaumicGrid)this.field_147002_h).getGrid().getCraftingMatrix().func_70301_a(z));
        }
        IArcaneRecipe result = ThaumcraftCraftingManager.findMatchingArcaneRecipe((InventoryCrafting)ic, (EntityPlayer)((ContainerThaumicGrid)this.field_147002_h).getPlayer());
        AspectList crystals = null;
        float df = CasterManager.getTotalVisDiscount((EntityPlayer)((ContainerThaumicGrid)this.field_147002_h).getPlayer());
        if (result != null) {
            cost = result.getVis();
            cost = (int)((float)cost * (1.0f - df));
            discount = (int)(df * 100.0f);
            crystals = result.getCrystals();
        }
        int y = yy;
        GL11.glEnable((int)3042);
        if (crystals != null) {
            this.bindTexture("thaumicgrid", "gui/crystals.png");
            GlStateManager.func_179112_b((int)770, (int)1);
            for (Aspect a : crystals.getAspects()) {
                int id = ShardType.getMetaByAspect((Aspect)a);
                Color col = new Color(a.getColor());
                GL11.glColor4f((float)((float)col.getRed() / 255.0f), (float)((float)col.getGreen() / 255.0f), (float)((float)col.getBlue() / 255.0f), (float)0.33f);
                GL11.glPushMatrix();
                GL11.glTranslatef((float)((float)(x + ContainerThaumicGrid.xx[id]) + 7.5f), (float)((float)(y + 6 + ContainerThaumicGrid.yy[id]) + 8.0f), (float)0.0f);
                GL11.glRotatef((float)((float)(id * 60 + this.field_146297_k.func_175606_aa().field_70173_aa % 360) + this.field_146297_k.func_193989_ak()), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glScalef((float)0.5f, (float)0.5f, (float)0.0f);
                this.func_73729_b(-32, -32, 192, 0, 64, 64);
                GL11.glScalef((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        GL11.glDisable((int)3042);
        String text = ((ContainerThaumicGrid)this.field_147002_h).getGrid().auraVisClient + " available";
        int ll = this.field_146289_q.func_78256_a(text) / 2;
        this.field_146289_q.func_78276_b(text, x + 139 - ll, y += 64, ((ContainerThaumicGrid)this.field_147002_h).getGrid().auraVisClient < cost ? 0xEE6E6E : 0x6E6EEE);
        if (cost > 0) {
            if (((ContainerThaumicGrid)this.field_147002_h).getGrid().auraVisClient < cost) {
                this.field_146296_j.func_180450_b(result.func_77572_b((InventoryCrafting)ic), x + 148, y + 23 - 64);
            }
            if (discount > 0) {
                text = "" + discount + "% discount";
                ll = this.field_146289_q.func_78256_a(text) / 2;
                this.field_146289_q.func_78276_b(text, x + 139 - ll, y -= 9, 0);
            }
            text = cost + " vis";
            ll = this.field_146289_q.func_78256_a(text) / 2;
            this.field_146289_q.func_78276_b(text, x + 139 - ll, y -= 9, 0);
        }
    }

    private void drawTC(int x, int y, int mouseX, int mouseY) {
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.isOverSlotWithStack()) {
            this.drawGridTooltip((IGridStack)this.view.getStacks().get(this.slotNumber), mouseX, mouseY);
        }
    }

    public void drawForeground(int mouseX, int mouseY) {
        this.drawString(7, 7 + this.tabs.getHeight(), GuiThaumicGrid.t((String)this.grid.getGuiTitle(), (Object[])new Object[0]));
        this.drawString(7, this.getYPlayerInventory() - 12, GuiThaumicGrid.t((String)"container.inventory", (Object[])new Object[0]));
        int x = 8;
        int y = 19 + this.tabs.getHeight();
        this.slotNumber = -1;
        int slot = this.scrollbar != null ? this.scrollbar.getOffset() * 9 : 0;
        RenderHelper.func_74520_c();
        for (int i = 0; i < 9 * this.getVisibleRows(); ++i) {
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                this.slotNumber = slot;
            }
            if (slot < this.view.getStacks().size()) {
                ((IGridStack)this.view.getStacks().get(slot)).draw((GuiBase)this, x, y);
            }
            if (this.inBounds(x, y, 16, 16, mouseX, mouseY) || !this.grid.isActive()) {
                int color = this.grid.isActive() ? -2130706433 : -10790053;
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                this.field_73735_i = 190.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
                this.func_73733_a(x, y, x + 16, y + 16, color, color);
                this.field_73735_i = 0.0f;
                GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            ++slot;
            x += 18;
            if ((i + 1) % 9 != 0) continue;
            x = 8;
            y += 18;
        }
        if (this.isOverClear(mouseX, mouseY)) {
            this.drawTooltip(mouseX, mouseY, GuiThaumicGrid.t((String)"misc.refinedstorage:clear", (Object[])new Object[0]));
        }
        this.tabs.drawTooltip(this.field_146289_q, mouseX, mouseY);
    }

    private void drawGridTooltip(IGridStack gridStack, int mouseX, int mouseY) {
        ArrayList textLines = Lists.newArrayList((Object[])gridStack.getTooltip().split("\n"));
        ArrayList smallTextLines = Lists.newArrayList();
        if (!gridStack.doesDisplayCraftText()) {
            smallTextLines.add(I18n.func_135052_a((String)"misc.refinedstorage:total", (Object[])new Object[]{gridStack.getFormattedFullQuantity()}));
        }
        if (gridStack.getTrackerEntry() != null) {
            smallTextLines.add(TimeUtils.getAgo((long)gridStack.getTrackerEntry().getTime(), (String)gridStack.getTrackerEntry().getName()));
        }
        ItemStack stack = gridStack instanceof GridStackItem ? ((GridStackItem)gridStack).getStack() : ItemStack.field_190927_a;
        RenderUtils.drawTooltipWithSmallText((List)textLines, (List)smallTextLines, (boolean)RS.INSTANCE.config.detailedTooltip, (ItemStack)stack, (int)mouseX, (int)mouseY, (int)this.screenWidth, (int)this.screenHeight, (FontRenderer)this.field_146289_q);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        this.tabs.actionPerformed(button);
    }

    public void func_73864_a(int mouseX, int mouseY, int clickedButton) throws IOException {
        boolean clickedClear;
        super.func_73864_a(mouseX, mouseY, clickedButton);
        this.tabs.mouseClicked();
        if (this.searchField != null) {
            this.searchField.func_146192_a(mouseX, mouseY, clickedButton);
        }
        boolean bl = clickedClear = clickedButton == 0 && this.isOverClear(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
        if (this.grid.isActive()) {
            if (clickedClear && this.grid instanceof IThaumicGrid) {
                NetworkHandler.network.sendToServer((IMessage)new MessageThaumicGridClear());
                MessageThaumicGridClear.clear(this.grid, null);
            }
            ItemStack held = ((ContainerThaumicGrid)this.field_147002_h).getPlayer().field_71071_by.func_70445_o();
            if (this.isOverSlotArea(mouseX - this.field_147003_i, mouseY - this.field_147009_r) && !held.func_190926_b() && (clickedButton == 0 || clickedButton == 1)) {
                NetworkHandler.network.sendToServer((IMessage)new MessageThaumicGridItemInsertHeld(clickedButton == 1));
            }
            if (this.isOverSlotWithStack()) {
                boolean isMiddleClickPulling = !held.func_190926_b() && clickedButton == 2;
                boolean isPulling = held.func_190926_b() || isMiddleClickPulling;
                IGridStack stack = (IGridStack)this.view.getStacks().get(this.slotNumber);
                if (isPulling) {
                    if (stack.isCraftable() && this.view.canCraft() && (stack.doesDisplayCraftText() || GuiScreen.func_146272_n() && GuiScreen.func_146271_m())) {
                        FMLCommonHandler.instance().showGuiScreen((Object)new GuiThaumicGridCraftingSettings(this, ((ContainerThaumicGrid)this.field_147002_h).getPlayer(), stack));
                    } else {
                        int flags = 0;
                        if (clickedButton == 1) {
                            flags |= 1;
                        }
                        if (GuiScreen.func_146272_n()) {
                            flags |= 4;
                        }
                        if (clickedButton == 2) {
                            flags |= 2;
                        }
                        NetworkHandler.network.sendToServer((IMessage)new MessageThaumicGridItemPull(stack.getHash(), flags));
                    }
                }
            }
        }
        if (clickedClear) {
            this.field_146297_k.func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
        }
    }

    protected void func_73869_a(char character, int keyCode) throws IOException {
        if (this.searchField == null) {
            return;
        }
        if (!this.func_146983_a(keyCode)) {
            if (this.searchField.func_146201_a(character, keyCode)) {
                this.keyHandled = true;
            } else if (keyCode == RSKeyBindings.CLEAR_GRID_CRAFTING_MATRIX.func_151463_i()) {
                NetworkHandler.network.sendToServer((IMessage)new MessageThaumicGridClear());
            } else {
                super.func_73869_a(character, keyCode);
            }
        }
    }

    public TextFieldSearch getSearchField() {
        return this.searchField;
    }

    public void updateScrollbar() {
        if (this.scrollbar != null) {
            this.scrollbar.setEnabled(this.getRows() > this.getVisibleRows());
            this.scrollbar.setMaxOffset(this.getRows() - this.getVisibleRows());
        }
    }
}

