/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.paul;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.reflect.TypeToken;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.Util;
import net.creeperhost.minetogether.api.AvailableResult;
import net.creeperhost.minetogether.api.IServerHost;
import net.creeperhost.minetogether.api.Minigame;
import net.creeperhost.minetogether.api.Order;
import net.creeperhost.minetogether.api.OrderSummary;
import net.creeperhost.minetogether.common.Config;
import net.creeperhost.minetogether.common.WebUtils;
import net.creeperhost.minetogether.gui.serverlist.data.Invite;
import net.creeperhost.minetogether.gui.serverlist.data.Server;
import net.creeperhost.minetogether.serverlist.data.EnumFlag;
import net.creeperhost.minetogether.serverlist.data.Friend;

public final class Callbacks {
    public static Map<IServerHost, Map<String, String>> locationCache = new HashMap<IServerHost, Map<String, String>>();
    private static Util.CachedValue<List<Server>> serverListCache;
    private static Map<UUID, String> hashCache;
    private static String friendCode;
    private static Util.CachedValue<ArrayList<Friend>> friendsList;
    private static String userCountry;
    private static Map<String, String> countries;
    static boolean friendsGetting;

    public static Invite getInvite() {
        JsonArray invites;
        Iterator iterator;
        JsonObject obj;
        String hash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/friendinvites", sendStr, true, false);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject() && (obj = element.getAsJsonObject()).get("status").getAsString().equals("success") && (iterator = (invites = obj.getAsJsonArray("invites")).iterator()).hasNext()) {
            JsonElement inviteEl = (JsonElement)iterator.next();
            JsonObject invite = inviteEl.getAsJsonObject();
            JsonObject server = invite.getAsJsonObject("server");
            String host = server.get("ip").getAsString();
            int project = server.get("project").getAsInt();
            String by = invite.get("by").getAsString();
            String name = server.get("name").getAsString();
            String port = server.get("port").getAsString();
            String country = "UNK";
            String subdivision = "Unknown";
            if (server.has("location")) {
                JsonObject el = server.getAsJsonObject("location");
                country = el.get("country_code").getAsString();
                subdivision = el.get("subdivision").getAsString();
            }
            country = country.toUpperCase();
            EnumFlag flag = null;
            if (!country.isEmpty()) {
                try {
                    flag = EnumFlag.valueOf(country);
                }
                catch (IllegalArgumentException ignored) {
                    flag = EnumFlag.UNKNOWN;
                }
            }
            int uptime = server.get("uptime").getAsInt();
            int players = server.get("expected_players").getAsInt();
            Server serverEl = new Server(name, host + ":" + port, uptime, players, flag, subdivision);
            return new Invite(serverEl, project, by);
        }
        return null;
    }

    public static boolean inviteFriend(Friend friend) {
        JsonObject obj;
        String hash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", friend.getCode());
        sendMap.put("server", String.valueOf(CreeperHost.instance.curServerId));
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invitefriend", sendStr, true, false);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject() && (obj = element.getAsJsonObject()).get("status").getAsString().equals("success")) {
            return true;
        }
        CreeperHost.logger.error("Unable to invite friend.");
        CreeperHost.logger.error(resp);
        return false;
    }

    public static String getPlayerHash(UUID uuid) {
        String playerHash;
        if (hashCache.containsKey(uuid)) {
            return hashCache.get(uuid);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(uuid.toString().getBytes(Charset.forName("UTF-8")));
            playerHash = new HexBinaryAdapter().marshal(hash);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
        hashCache.put(uuid, playerHash);
        return playerHash;
    }

    public static String getFriendCode() {
        if (friendCode != null) {
            return friendCode;
        }
        String hash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/friendCode", sendStr, true, false);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            JsonElement status = obj.get("status");
            if (status.getAsString().equals("success")) {
                friendCode = obj.get("code").getAsString();
            } else {
                CreeperHost.logger.error("Unable to get friendcode.");
                CreeperHost.logger.error(resp);
            }
        }
        return friendCode;
    }

    public static String addFriend(String code, String display) {
        JsonObject obj;
        JsonElement status;
        String hash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", code);
        sendMap.put("display", display);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/requestfriend", sendStr, true, false);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject() && !(status = (obj = element.getAsJsonObject()).get("status")).getAsString().equals("success")) {
            CreeperHost.logger.error("Unable to add friend.");
            CreeperHost.logger.error(resp);
            return obj.get("message").getAsString();
        }
        return null;
    }

    public static boolean removeFriend(String friendHash) {
        JsonObject obj;
        JsonElement status;
        String hash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("hash", hash);
        sendMap.put("target", friendHash);
        Gson gson = new Gson();
        String sendStr = gson.toJson(sendMap);
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/removefriend", sendStr, true, false);
        JsonParser parser = new JsonParser();
        JsonElement element = parser.parse(resp);
        if (element.isJsonObject() && !(status = (obj = element.getAsJsonObject()).get("status")).getAsString().equals("success")) {
            CreeperHost.logger.error("Unable to remove friend.");
            CreeperHost.logger.error(resp);
            return false;
        }
        return true;
    }

    public static ArrayList<Minigame> getMinigames(boolean isModded) {
        JsonObject obj;
        HashMap<String, String> sendMap = new HashMap<String, String>();
        sendMap.put("mc", Util.getMinecraftVersion());
        sendMap.put("project", isModded ? Config.getInstance().curseProjectID : String.valueOf(0));
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/mgtemplates", new Gson().toJson(sendMap), true, false);
        JsonParser parser = new JsonParser();
        Gson gson = new Gson();
        JsonElement parse = parser.parse(resp);
        if (parse.isJsonObject() && (obj = parse.getAsJsonObject()).get("status").getAsString().equals("success")) {
            return (ArrayList)gson.fromJson(obj.get("templates"), new TypeToken<List<Minigame>>(){}.getType());
        }
        return null;
    }

    public static ArrayList<Friend> getFriendsList(boolean force) {
        if (friendsList == null) {
            friendsList = new Util.CachedValue<ArrayList<Friend>>(60000, new Util.CachedValue.ICacheCallback<ArrayList<Friend>>(){

                @Override
                public ArrayList<Friend> get(Object ... args) {
                    JsonObject obj;
                    if (friendsGetting) {
                        return (ArrayList)friendsList.getCachedValue(args);
                    }
                    friendsGetting = true;
                    HashMap<String, String> sendMap = new HashMap<String, String>();
                    sendMap.put("hash", Callbacks.getPlayerHash(CreeperHost.proxy.getUUID()));
                    String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/listfriend", new Gson().toJson(sendMap), true, true);
                    ArrayList<Friend> tempArr = new ArrayList<Friend>();
                    JsonElement el = new JsonParser().parse(resp);
                    if (el.isJsonObject() && (obj = el.getAsJsonObject()).get("status").getAsString().equals("success")) {
                        JsonArray array = obj.getAsJsonArray("friends");
                        for (JsonElement friendEl : array) {
                            JsonObject friend = (JsonObject)friendEl;
                            String name = "null";
                            if (!friend.get("name").isJsonNull()) {
                                name = friend.get("name").getAsString();
                            }
                            String code = friend.get("hash").getAsString();
                            boolean accepted = friend.get("accepted").getAsBoolean();
                            tempArr.add(new Friend(name, code, accepted));
                        }
                    }
                    friendsGetting = false;
                    return tempArr;
                }

                @Override
                public boolean needsRefresh(Object ... args) {
                    return args.length > 0 && args[0].equals(true);
                }
            });
        }
        return friendsList.get(force);
    }

    public static List<Server> getServerList(boolean isPublic) {
        if (serverListCache == null) {
            serverListCache = new Util.CachedValue<List<Server>>(30000, new Util.CachedValue.ICacheCallback<List<Server>>(){
                private boolean lastRequest;
                private String playerHash;

                @Override
                public List<Server> get(Object ... args) {
                    JsonObject object;
                    JsonArray array;
                    Gson gson;
                    String jsonString;
                    String resp;
                    JsonElement jElement;
                    boolean isPublic;
                    this.lastRequest = isPublic = ((Boolean)args[0]).booleanValue();
                    CreeperHost.logger.info("Loading " + (isPublic ? "public" : "private") + " server list.");
                    ArrayList<Server> list = new ArrayList<Server>();
                    Config defaultConfig = new Config();
                    if (defaultConfig.curseProjectID.equals(Config.getInstance().curseProjectID)) {
                        list.add(new Server("No project ID! Please fix the MineTogether config.", "127.0.0.1:25565", 0, 0, null, "Unknown"));
                        return list;
                    }
                    HashMap<String, String> jsonPass = new HashMap<String, String>();
                    jsonPass.put("projectid", Config.getInstance().curseProjectID);
                    if (!isPublic) {
                        if (this.playerHash == null) {
                            this.playerHash = Callbacks.getPlayerHash(CreeperHost.proxy.getUUID());
                        }
                        jsonPass.put("hash", this.playerHash);
                    }
                    if ((jElement = new JsonParser().parse(resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/list", jsonString = (gson = new Gson()).toJson(jsonPass), true, false))).isJsonObject() && (array = (object = jElement.getAsJsonObject()).getAsJsonArray("servers")) != null) {
                        for (JsonElement serverEl : array) {
                            JsonObject server = (JsonObject)serverEl;
                            String name = server.get("name").getAsString();
                            String host = server.get("ip").getAsString();
                            String port = server.get("port").getAsString();
                            String country = "UNK";
                            String subdivision = "Unknown";
                            if (server.has("location")) {
                                JsonObject el = server.getAsJsonObject("location");
                                country = el.get("country_code").getAsString();
                                subdivision = el.get("subdivision").getAsString();
                            }
                            country = country.toUpperCase();
                            EnumFlag flag = null;
                            if (!country.isEmpty()) {
                                try {
                                    flag = EnumFlag.valueOf(country);
                                }
                                catch (IllegalArgumentException ignored) {
                                    flag = EnumFlag.UNKNOWN;
                                }
                            }
                            int uptime = server.get("uptime").getAsInt();
                            int players = server.get("expected_players").getAsInt();
                            list.add(new Server(name, host + ":" + port, uptime, players, flag, subdivision));
                        }
                    }
                    return list;
                }

                @Override
                public boolean needsRefresh(Object ... args) {
                    boolean isPublic = (Boolean)args[0];
                    return isPublic != this.lastRequest;
                }
            });
        }
        return serverListCache.get(isPublic);
    }

    public static Map<String, String> getAllServerLocations() {
        IServerHost implementation = CreeperHost.instance.getImplementation();
        if (locationCache.get(implementation) == null) {
            locationCache.put(implementation, implementation.getAllServerLocations());
        }
        return locationCache.get(implementation);
    }

    public static Map<String, String> getCountries() {
        return countries;
    }

    public static AvailableResult getNameAvailable(String name) {
        return CreeperHost.instance.getImplementation().getNameAvailable(name);
    }

    public static String getUserCountry() {
        if (userCountry == null) {
            try {
                String freeGeoIP = WebUtils.getWebResponse("https://www.creeperhost.net/json/datacentre/closest");
                JsonObject jObject = new JsonParser().parse(freeGeoIP).getAsJsonObject();
                jObject = jObject.getAsJsonObject("customer");
                userCountry = jObject.getAsJsonPrimitive("country").getAsString();
            }
            catch (Throwable t) {
                CreeperHost.logger.error("Unable to get user's country automatically, assuming USA", t);
                userCountry = "US";
            }
        }
        return userCountry;
    }

    public static String getRecommendedLocation() {
        return CreeperHost.instance.getImplementation().getRecommendedLocation();
    }

    public static OrderSummary getSummary(Order order) {
        return CreeperHost.instance.getImplementation().getSummary(order);
    }

    public static boolean doesEmailExist(String email) {
        return CreeperHost.instance.getImplementation().doesEmailExist(email);
    }

    public static String doLogin(String email, String password) {
        return CreeperHost.instance.getImplementation().doLogin(email, password);
    }

    public static String createAccount(Order order) {
        return CreeperHost.instance.getImplementation().createAccount(order);
    }

    public static String createOrder(Order order) {
        return CreeperHost.instance.getImplementation().createOrder(order);
    }

    public static String getVersionFromCurse(String curse) {
        String resp = WebUtils.getWebResponse("https://www.creeperhost.net/json/modpacks/curseforge/" + curse);
        try {
            JsonElement jElement = new JsonParser().parse(resp);
            JsonObject jObject = jElement.getAsJsonObject();
            if (jObject.getAsJsonPrimitive("status").getAsString().equals("success")) {
                return jObject.getAsJsonPrimitive("id").getAsString();
            }
            return "0";
        }
        catch (Throwable t) {
            t.printStackTrace();
            return "0";
        }
    }

    static {
        hashCache = new HashMap<UUID, String>();
        friendsList = null;
        countries = new LinkedHashMap<String, String>(){
            {
                this.put("GB", "United Kingdom");
                this.put("US", "United States");
                this.put("NZ", "New Zealand");
                this.put("AU", "Australia");
                this.put("DK", "Denmark");
                this.put("CA", "Canada");
                this.put("SE", "Sweden");
                this.put("NO", "Norway");
                this.put("BR", "Brazil");
                this.put("ES", "Spain");
                this.put("AF", "Afghanistan");
                this.put("AX", "Aland Islands");
                this.put("AL", "Albania");
                this.put("DZ", "Algeria");
                this.put("AS", "American Samoa");
                this.put("AD", "Andorra");
                this.put("AO", "Angola");
                this.put("AI", "Anguilla");
                this.put("AQ", "Antarctica");
                this.put("AG", "Antigua and Barbuda");
                this.put("AR", "Argentina");
                this.put("AM", "Armenia");
                this.put("AW", "Aruba");
                this.put("AT", "Austria");
                this.put("AZ", "Azerbaijan");
                this.put("BS", "Bahamas");
                this.put("BH", "Bahrain");
                this.put("BD", "Bangladesh");
                this.put("BB", "Barbados");
                this.put("BY", "Belarus");
                this.put("BE", "Belgium");
                this.put("BZ", "Belize");
                this.put("BJ", "Benin");
                this.put("BM", "Bermuda");
                this.put("BT", "Bhutan");
                this.put("BO", "Bolivia, Plurinational State of");
                this.put("BQ", "Bonaire, Sint Eustatius and Saba");
                this.put("BA", "Bosnia and Herzegovina");
                this.put("BW", "Botswana");
                this.put("BV", "Bouvet Island");
                this.put("IO", "British Indian Ocean Territory");
                this.put("BN", "Brunei Darussalam");
                this.put("BG", "Bulgaria");
                this.put("BF", "Burkina Faso");
                this.put("BI", "Burundi");
                this.put("KH", "Cambodia");
                this.put("CM", "Cameroon");
                this.put("CV", "Cape Verde");
                this.put("KY", "Cayman Islands");
                this.put("CF", "Central African Republic");
                this.put("TD", "Chad");
                this.put("CL", "Chile");
                this.put("CN", "China");
                this.put("CX", "Christmas Island");
                this.put("CC", "Cocos (Keeling) Islands");
                this.put("CO", "Colombia");
                this.put("KM", "Comoros");
                this.put("CG", "Congo");
                this.put("CD", "Congo, the Democratic Republic of the");
                this.put("CK", "Cook Islands");
                this.put("CR", "Costa Rica");
                this.put("CI", "C\ufffdte d'Ivoire");
                this.put("HR", "Croatia");
                this.put("CU", "Cuba");
                this.put("CW", "Cura\ufffdao");
                this.put("CY", "Cyprus");
                this.put("CZ", "Czech Republic");
                this.put("DJ", "Djibouti");
                this.put("DM", "Dominica");
                this.put("DO", "Dominican Republic");
                this.put("EC", "Ecuador");
                this.put("EG", "Egypt");
                this.put("SV", "El Salvador");
                this.put("GQ", "Equatorial Guinea");
                this.put("ER", "Eritrea");
                this.put("EE", "Estonia");
                this.put("ET", "Ethiopia");
                this.put("FK", "Falkland Islands (Malvinas)");
                this.put("FO", "Faroe Islands");
                this.put("FJ", "Fiji");
                this.put("FI", "Finland");
                this.put("FR", "France");
                this.put("GF", "French Guiana");
                this.put("PF", "French Polynesia");
                this.put("TF", "French Southern Territories");
                this.put("GA", "Gabon");
                this.put("GM", "Gambia");
                this.put("GE", "Georgia");
                this.put("DE", "Germany");
                this.put("GH", "Ghana");
                this.put("GI", "Gibraltar");
                this.put("GR", "Greece");
                this.put("GL", "Greenland");
                this.put("GD", "Grenada");
                this.put("GP", "Guadeloupe");
                this.put("GU", "Guam");
                this.put("GT", "Guatemala");
                this.put("GG", "Guernsey");
                this.put("GN", "Guinea");
                this.put("GW", "Guinea-Bissau");
                this.put("GY", "Guyana");
                this.put("HT", "Haiti");
                this.put("HM", "Heard Island and McDonald Islands");
                this.put("VA", "Holy Sea (Vatican City State)");
                this.put("HN", "Honduras");
                this.put("HK", "Hong Kong");
                this.put("HU", "Hungary");
                this.put("IS", "Iceland");
                this.put("IN", "India");
                this.put("ID", "Indonesia");
                this.put("IR", "Iran, Islamic Republic of");
                this.put("IQ", "Iraq");
                this.put("IE", "Ireland");
                this.put("IM", "Isle of Man");
                this.put("IL", "Israel");
                this.put("IT", "Italy");
                this.put("JM", "Jamaica");
                this.put("JP", "Japan");
                this.put("JE", "Jersey");
                this.put("JO", "Jordan");
                this.put("KZ", "Kazakhstan");
                this.put("KE", "Kenya");
                this.put("KI", "Kiribati");
                this.put("KP", "Korea, Democratic People's Republic of");
                this.put("KR", "Korea, Republic of");
                this.put("KW", "Kuwait");
                this.put("KG", "Kyrgyzstan");
                this.put("LA", "Lao People's Democratic Republic");
                this.put("LV", "Latvia");
                this.put("LB", "Lebanon");
                this.put("LS", "Lesotho");
                this.put("LR", "Liberia");
                this.put("LY", "Libya");
                this.put("LI", "Liechtenstein");
                this.put("LT", "Lithuania");
                this.put("LU", "Luxembourg");
                this.put("MO", "Macao");
                this.put("MK", "Macedonia, the former Yugoslav Republic of");
                this.put("MG", "Madagascar");
                this.put("MW", "Malawi");
                this.put("MY", "Malaysia");
                this.put("MV", "Maldives");
                this.put("ML", "Mali");
                this.put("MT", "Malta");
                this.put("MH", "Marshall Islands");
                this.put("MQ", "Martinique");
                this.put("MR", "Mauritania");
                this.put("MU", "Mauritius");
                this.put("YT", "Mayotte");
                this.put("MX", "Mexico");
                this.put("FM", "Micronesia, Federated States of");
                this.put("MD", "Moldova, Republic of");
                this.put("MC", "Monaco");
                this.put("MN", "Mongolia");
                this.put("ME", "Montenegro");
                this.put("MS", "Montserrat");
                this.put("MA", "Morocco");
                this.put("MZ", "Mozambique");
                this.put("MM", "Myanmar");
                this.put("NA", "Namibia");
                this.put("NR", "Nauru");
                this.put("NP", "Nepal");
                this.put("NL", "Netherlands");
                this.put("NC", "New Caledonia");
                this.put("NI", "Nicaragua");
                this.put("NE", "Niger");
                this.put("NG", "Nigeria");
                this.put("NU", "Niue");
                this.put("NF", "Norfolk Island");
                this.put("MP", "Northern Mariana Islands");
                this.put("OM", "Oman");
                this.put("PK", "Pakistan");
                this.put("PW", "Palau");
                this.put("PS", "Palestinian Territory, Occupied");
                this.put("PA", "Panama");
                this.put("PG", "Papua New Guinea");
                this.put("PY", "Paraguay");
                this.put("PE", "Peru");
                this.put("PH", "Philippines");
                this.put("PN", "Pitcairn");
                this.put("PL", "Poland");
                this.put("PT", "Portugal");
                this.put("PR", "Puerto Rico");
                this.put("QA", "Qatar");
                this.put("RE", "R\ufffdunion");
                this.put("RO", "Romania");
                this.put("RU", "Russian Federation");
                this.put("RW", "Rwanda");
                this.put("BL", "Saint Barth\ufffdlemy");
                this.put("SH", "Saint Helena, Ascension and Tristan da Cunha");
                this.put("KN", "Saint Kitts and Nevis");
                this.put("LC", "Saint Lucia");
                this.put("MF", "Saint Martin (French part)");
                this.put("PM", "Saint Pierre and Miquelon");
                this.put("VC", "Saint Vincent and the Grenadines");
                this.put("WS", "Samoa");
                this.put("SM", "San Marino");
                this.put("ST", "Sao Tome and Principe");
                this.put("SA", "Saudi Arabia");
                this.put("SN", "Senegal");
                this.put("RS", "Serbia");
                this.put("SC", "Seychelles");
                this.put("SL", "Sierra Leone");
                this.put("SG", "Singapore");
                this.put("SX", "Sint Maarten (Dutch part)");
                this.put("SK", "Slovakia");
                this.put("SI", "Slovenia");
                this.put("SB", "Solomon Islands");
                this.put("SO", "Somalia");
                this.put("ZA", "South Africa");
                this.put("GS", "South Georgia and the South Sandwich Islands");
                this.put("SS", "South Sudan");
                this.put("LK", "Sri Lanka");
                this.put("SD", "Sudan");
                this.put("SR", "Suriname");
                this.put("SJ", "Svalbard and Jan Mayen");
                this.put("SZ", "Swaziland");
                this.put("CH", "Switzerland");
                this.put("SY", "Syrian Arab Republic");
                this.put("TW", "Taiwan, Province of China");
                this.put("TJ", "Tajikistan");
                this.put("TZ", "Tanzania, United Republic of");
                this.put("TH", "Thailand");
                this.put("TL", "Timor-Leste");
                this.put("TG", "Togo");
                this.put("TK", "Tokelau");
                this.put("TO", "Tonga");
                this.put("TT", "Trinidad and Tobago");
                this.put("TN", "Tunisia");
                this.put("TR", "Turkey");
                this.put("TM", "Turkmenistan");
                this.put("TC", "Turks and Caicos Islands");
                this.put("TV", "Tuvalu");
                this.put("UG", "Uganda");
                this.put("UA", "Ukraine");
                this.put("AE", "United Arab Emirates");
                this.put("UM", "United States Minor Outlying Islands");
                this.put("UY", "Uruguay");
                this.put("UZ", "Uzbekistan");
                this.put("VU", "Vanuatu");
                this.put("VE", "Venezuela, Bolivarian Republic of");
                this.put("VN", "Viet Nam");
                this.put("VG", "Virgin Islands, British");
                this.put("VI", "Virgin Islands, U.S.");
                this.put("WF", "Wallis and Futuna");
                this.put("EH", "Western Sahara");
                this.put("YE", "Yemen");
                this.put("ZM", "Zambia");
                this.put("ZW", "Zimbabwe");
                this.put("UNKNOWN", "Unknown");
            }
        };
    }
}

