/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.Mode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class ModeStatusList<ModeType extends Mode> {
    private final List<ModeStatus<ModeType>> statuses;

    @Nonnull
    public static ModeStatusList<ChannelMode> fromChannel(@Nonnull Client client, @Nonnull String string) {
        HashMap modes = new HashMap();
        client.getServerInfo().getChannelModes().forEach(mode -> modes.put(Character.valueOf(mode.getChar()), mode));
        client.getServerInfo().getChannelUserModes().forEach(mode -> {
            ChannelMode cfr_ignored_0 = modes.put(Character.valueOf(mode.getChar()), mode);
        });
        return ModeStatusList.from(string, modes);
    }

    @Nonnull
    public static ModeStatusList<UserMode> fromUser(@Nonnull Client client, @Nonnull String string) {
        return ModeStatusList.from(string, client.getServerInfo().getUserModes().stream().collect(Collectors.toMap(Mode::getChar, Function.identity())));
    }

    @Nonnull
    private static <ModeType extends Mode> ModeStatusList<ModeType> from(@Nonnull String string, @Nonnull Map<Character, ModeType> modes) {
        Sanity.safeMessageCheck(string, "String");
        ArrayList<ModeStatus<ModeType>> list = new ArrayList<ModeStatus<ModeType>>();
        String[] args = string.split(" ");
        int currentArg = -1;
        while (++currentArg < args.length) {
            String changes = args[currentArg];
            if (changes.charAt(0) != '+' && changes.charAt(0) != '-') {
                throw new IllegalArgumentException("Mode change does not start with + or -");
            }
            boolean add = true;
            block5: for (char modeChar : changes.toCharArray()) {
                switch (modeChar) {
                    case '+': {
                        add = true;
                        continue block5;
                    }
                    case '-': {
                        add = false;
                        continue block5;
                    }
                    default: {
                        Mode mode = (Mode)modes.get(Character.valueOf(modeChar));
                        if (mode == null) {
                            throw new IllegalArgumentException("Contains non-registered mode: " + modeChar);
                        }
                        String target = null;
                        if (mode instanceof ChannelMode && (mode instanceof ChannelUserMode || (add ? ((ChannelMode)mode).getType().isParameterRequiredOnSetting() : ((ChannelMode)mode).getType().isParameterRequiredOnRemoval()))) {
                            target = args[++currentArg];
                        }
                        list.add(target == null ? new ModeStatus<Mode>(add, mode) : new ModeStatus<Mode>(add, mode, target));
                    }
                }
            }
        }
        return ModeStatusList.of(list);
    }

    @Nonnull
    public static <ModeType extends Mode> ModeStatusList<ModeType> of(ModeStatus<ModeType> ... statuses) {
        Sanity.nullCheck(statuses, "Statuses cannot be null");
        Sanity.truthiness(statuses.length <= 1 || Arrays.stream(statuses).map(ModeStatus::getClient).distinct().count() == 1L, "Statuses must all be from one client");
        return new ModeStatusList<ModeType>(Arrays.asList(statuses));
    }

    @Nonnull
    public static <ModeType extends Mode> ModeStatusList<ModeType> of(@Nonnull Collection<ModeStatus<ModeType>> statuses) {
        Sanity.nullCheck(statuses, "Statuses cannot be null");
        ArrayList<ModeStatus<ModeType>> list = new ArrayList<ModeStatus<ModeType>>(statuses);
        Sanity.truthiness(list.size() <= 1 || list.stream().map(ModeStatus::getClient).distinct().count() == 1L, "Statuses must all be from one client");
        return new ModeStatusList<ModeType>(list);
    }

    private ModeStatusList(List<ModeStatus<ModeType>> statuses) {
        this.statuses = statuses;
    }

    public boolean containsMode(@Nonnull ModeType mode) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        return this.statuses.stream().anyMatch(status -> status.getMode().equals(mode));
    }

    @Nonnull
    public List<ModeStatus<ModeType>> getStatusByMode(@Nonnull ModeType mode) {
        Sanity.nullCheck(mode, "Mode cannot be null");
        return Collections.unmodifiableList(this.statuses.stream().filter(status -> status.getMode().equals(mode)).collect(Collectors.toList()));
    }

    @Nonnull
    public List<ModeStatus<ModeType>> getStatuses() {
        return Collections.unmodifiableList(this.statuses);
    }

    @Nonnull
    public String getStatusString() {
        StringBuilder modes = new StringBuilder(this.statuses.size() * 2);
        StringBuilder parameters = new StringBuilder(100);
        Boolean add = null;
        for (ModeStatus<ModeType> change : this.statuses) {
            if (add == null || add.booleanValue() != change.isSetting()) {
                add = change.isSetting();
                modes.append(add != false ? (char)'+' : '-');
            }
            modes.append(change.getMode().getChar());
            Optional<String> parameter = change.getParameter();
            parameter.ifPresent(s -> parameters.append(' ').append((String)s));
        }
        return modes.toString() + parameters;
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("list", this.statuses).toString();
    }
}

