/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.messagetag.DefaultMessageTagTime;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageTagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.AbstractNameValueProcessor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.TriFunction;

public class DefaultMessageTagManager
extends AbstractNameValueProcessor<MessageTag>
implements MessageTagManager {
    private static final Pattern TAG_ESCAPE = Pattern.compile("\\\\([\\\\s:])");

    public DefaultMessageTagManager(Client.WithManagement client) {
        super(client);
        this.registerTagCreator("server-time", "time", DefaultMessageTagTime.FUNCTION);
    }

    @Override
    @Nonnull
    public Map<String, TriFunction<Client, String, String, ? extends MessageTag>> getCapabilityTagCreators(@Nonnull String capability) {
        return Collections.unmodifiableMap(this.getRegistrations().entrySet().stream().filter(e -> ((TagCreator)e.getValue()).getCapability().equals(capability)).collect(Collectors.toMap(Map.Entry::getKey, e -> ((AbstractNameValueProcessor.Creator)e.getValue()).getFunction())));
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends MessageTag>> getTagCreator(@Nonnull String tagName) {
        return this.getCreatorByName(tagName);
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends MessageTag>> registerTagCreator(@Nonnull String capability, @Nonnull String tagName, @Nonnull TriFunction<Client, String, String, ? extends MessageTag> function) {
        return this.registerCreator(tagName, new TagCreator(capability, function));
    }

    @Override
    @Nonnull
    public Optional<TriFunction<Client, String, String, ? extends MessageTag>> unregisterTag(@Nonnull String tagName) {
        return this.unregisterCreator(tagName);
    }

    @Override
    @Nonnull
    public List<MessageTag> getCapabilityTags(@Nonnull String tagList) {
        String[] tags = tagList.split(";");
        ArrayList<MessageTagManager.DefaultMessageTag> list = new ArrayList<MessageTagManager.DefaultMessageTag>();
        for (String tag : tags) {
            String value;
            String tagName;
            int index = tag.indexOf(61);
            if (index > -1 && index < tag.length() - 1) {
                tagName = tag.substring(0, index);
                value = this.getTagValue(tag.substring(index + 1));
            } else {
                tagName = index < 0 ? tag : tag.substring(0, index);
                value = null;
            }
            MessageTag messageTag = null;
            TagCreator tagCreator = (TagCreator)this.getRegistrations().get(tagName);
            if (tagCreator != null) {
                try {
                    messageTag = (MessageTag)tagCreator.getFunction().apply(this.getClient(), tagName, value);
                }
                catch (Throwable thrown) {
                    this.getClient().getExceptionListener().queue(new KittehServerMessageTagException(tag, "Tag creator failed", thrown));
                }
            }
            if (messageTag == null) {
                messageTag = new MessageTagManager.DefaultMessageTag(tagName, value);
            }
            list.add((MessageTagManager.DefaultMessageTag)messageTag);
        }
        return Collections.unmodifiableList(list);
    }

    @Nonnull
    private String getTagValue(@Nonnull String tag) {
        StringBuilder builder = new StringBuilder(tag.length());
        int currentIndex = 0;
        Matcher matcher = TAG_ESCAPE.matcher(tag);
        while (matcher.find()) {
            if (matcher.start() > currentIndex) {
                builder.append(tag.substring(currentIndex, matcher.start()));
            }
            switch (matcher.group(1)) {
                case ":": {
                    builder.append(';');
                    break;
                }
                case "s": {
                    builder.append(' ');
                    break;
                }
                case "\\": {
                    builder.append('\\');
                    break;
                }
                case "r": {
                    builder.append('\r');
                    break;
                }
                case "n": {
                    builder.append('\n');
                    break;
                }
            }
            currentIndex = matcher.end();
        }
        if (currentIndex < tag.length()) {
            builder.append(tag.substring(currentIndex));
        }
        return builder.toString();
    }

    protected static class TagCreator
    extends AbstractNameValueProcessor.Creator<MessageTag> {
        private final String capability;

        private TagCreator(@Nonnull String capability, @Nonnull TriFunction<Client, String, String, ? extends MessageTag> function) {
            super(function);
            this.capability = capability;
        }

        @Nonnull
        protected String getCapability() {
            return this.capability;
        }

        @Nonnull
        public String toString() {
            return new ToStringer(this).add("capability", this.capability).add("function", this.getFunction()).toString();
        }
    }
}

