/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.AwayCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.KickCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.MonitorCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.OperCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.TopicCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WallopsCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WhoisCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.DefaultEventListener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.NettyManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.DefaultServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Actor;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageTag;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatus;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveCommandEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehNagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.exception.KittehServerMessageTagException;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.AuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.SimpleDefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.MessageSendingQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.QueueProcessingThreadSender;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.MemoryStsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsHandler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.CISet;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.CtcpUtil;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Cutter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Listener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.QueueProcessingThread;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class DefaultClient
implements Client.WithManagement {
    private final String[] pingPurr = new String[]{"MEOW", "MEOW!", "PURR", "PURRRRRRR", "MEOWMEOW", ":3", "HISS"};
    private int pingPurrCount;
    private final InputProcessor processor;
    private ServerInfo.WithManagement serverInfo;
    private String goalNick;
    private String currentNick;
    private String requestedNick;
    private final Set<String> channelsIntended = new CISet(this);
    private NettyManager.ClientConnection connection;
    private Cutter messageCutter = new Cutter.DefaultWordCutter();
    private AuthManager authManager;
    private CapabilityManager.WithManagement capabilityManager;
    private EventManager eventManager;
    private ISupportManager iSupportManager;
    private MessageTagManager messageTagManager;
    private ActorTracker actorTracker;
    private Listener<Exception> exceptionListener;
    private Listener<String> inputListener;
    private Listener<String> outputListener;
    private DefaultMessageMap defaultMessageMap;
    private Map<Character, ModeStatus<UserMode>> userModes;
    private StsMachine stsMachine;
    private final ClientCommands commands = new ClientCommands();
    private final MessageSendingQueue messageSendingImmediate;
    private MessageSendingQueue messageSendingScheduled;
    private final Object messageSendingLock = new Object();
    private String name;
    private InetSocketAddress bindAddress;
    private InetSocketAddress serverAddress;
    private String serverPassword;
    private String userString;
    private String realName;
    private boolean secure;
    private Path secureKeyCertChain;
    private Path secureKey;
    private String secureKeyPassword;
    private TrustManagerFactory secureTrustManagerFactory;
    private StsStorageManager stsStorageManager;
    private String webircHost;
    private InetAddress webircIP;
    private String webircPassword;
    private String webircUser;
    private Function<Client.WithManagement, ? extends MessageSendingQueue> messageSendingQueueSupplier;
    private Function<Client.WithManagement, ? extends ServerInfo.WithManagement> serverInfoSupplier;

    public DefaultClient() {
        this.processor = new InputProcessor();
        this.messageSendingImmediate = new QueueProcessingThreadSender(this, "Immediate");
    }

    @Override
    public void initialize(@Nonnull String name, @Nonnull InetSocketAddress serverAddress, @Nullable String serverPassword, @Nullable InetSocketAddress bindAddress, @Nonnull String nick, @Nonnull String userString, @Nonnull String realName, @Nonnull ActorTracker actorTracker, @Nonnull AuthManager authManager, @Nonnull CapabilityManager.WithManagement capabilityManager, @Nonnull EventManager eventManager, @Nonnull MessageTagManager messageTagManager, @Nonnull ISupportManager iSupportManager, @Nullable DefaultMessageMap defaultMessageMap, @Nonnull Function<Client.WithManagement, ? extends MessageSendingQueue> messageSendingQueue, @Nonnull Function<Client.WithManagement, ? extends ServerInfo.WithManagement> serverInfo, @Nullable Consumer<Exception> exceptionListener, @Nullable Consumer<String> inputListener, @Nullable Consumer<String> outputListener, boolean secure, @Nullable Path secureKeyCertChain, @Nullable Path secureKey, @Nullable String secureKeyPassword, @Nullable TrustManagerFactory trustManagerFactory, @Nullable StsStorageManager stsStorageManager, @Nullable String webircHost, @Nullable InetAddress webircIP, @Nullable String webircPassword, @Nullable String webircUser) {
        this.name = name;
        this.serverAddress = serverAddress;
        this.serverPassword = serverPassword;
        this.bindAddress = bindAddress;
        this.requestedNick = this.goalNick = nick;
        this.currentNick = this.goalNick;
        this.userString = userString;
        this.realName = realName;
        this.actorTracker = actorTracker;
        this.authManager = authManager;
        this.capabilityManager = capabilityManager;
        this.eventManager = eventManager;
        this.messageTagManager = messageTagManager;
        this.iSupportManager = iSupportManager;
        this.defaultMessageMap = defaultMessageMap == null ? new SimpleDefaultMessageMap() : defaultMessageMap;
        this.messageSendingQueueSupplier = messageSendingQueue;
        this.serverInfoSupplier = serverInfo;
        this.exceptionListener = new Listener<Exception>(this, exceptionListener);
        this.inputListener = new Listener<String>(this, inputListener);
        this.outputListener = new Listener<String>(this, outputListener);
        this.secure = secure;
        this.secureKeyCertChain = secureKeyCertChain;
        this.secureKey = secureKey;
        this.secureKeyPassword = secureKeyPassword;
        this.secureTrustManagerFactory = trustManagerFactory;
        this.stsStorageManager = stsStorageManager;
        this.webircHost = webircHost;
        this.webircIP = webircIP;
        this.webircPassword = webircPassword;
        this.webircUser = webircUser;
        this.eventManager.registerEventListener(new DefaultEventListener(this));
        this.serverInfo = this.serverInfoSupplier.apply(this);
        if (this.stsStorageManager != null) {
            this.configureSts();
        } else if (!this.isSecureConnection()) {
            this.exceptionListener.queue(new KittehNagException("Connection is insecure. If the server does not support SSL, consider enabling STS support to facilitate automatic SSL upgrades when it does."));
        }
        this.messageSendingScheduled = this.getMessageSendingQueueSupplier().apply(this);
    }

    private void configureSts() {
        this.stsMachine = new MemoryStsMachine(this.stsStorageManager, this);
        this.eventManager.registerEventListener(new StsHandler(this.stsMachine, this));
    }

    @Override
    public void addChannel(String ... channels) {
        Sanity.nullCheck(channels, "Channels cannot be null");
        Sanity.truthiness(channels.length > 0, "Channels cannot be empty array");
        for (String channelName : channels) {
            Sanity.truthiness(this.serverInfo.isValidChannel(channelName), "Invalid channel name " + channelName);
        }
        for (String channelName : channels) {
            this.channelsIntended.add(channelName);
            this.sendRawLine("JOIN " + channelName);
        }
    }

    @Override
    public void addKeyProtectedChannel(@Nonnull String channel, @Nonnull String key) {
        Sanity.nullCheck(channel, "Channel cannot be null");
        Sanity.nullCheck(key, "Key cannot be null");
        Sanity.truthiness(this.serverInfo.isValidChannel(channel), "Invalid channel name " + channel);
        this.channelsIntended.add(channel);
        this.sendRawLine("JOIN " + channel + ' ' + key);
    }

    @Override
    public void addKeyProtectedChannel(Pair<String, String> ... channelsAndKeys) {
        Sanity.nullCheck(channelsAndKeys, "Channel/key pairs cannot be null");
        Sanity.truthiness(channelsAndKeys.length > 0, "Channel/key pairs cannot be empty array");
        for (Pair<String, String> channelAndKey : channelsAndKeys) {
            String channelName = channelAndKey.getLeft();
            Sanity.nullCheck(channelName, "Channel/key pairs cannot contain null channel name");
            Sanity.truthiness(this.serverInfo.isValidChannel(channelName), "Channel/key pairs cannot contain invalid channel name " + channelName);
        }
        for (Pair<String, String> channelAndKey : channelsAndKeys) {
            this.channelsIntended.add(channelAndKey.getLeft());
            this.sendRawLine("JOIN " + channelAndKey.getLeft() + (channelAndKey.getRight() == null ? "" : ' ' + channelAndKey.getRight()));
        }
    }

    @Override
    @Nonnull
    public AuthManager getAuthManager() {
        return this.authManager;
    }

    @Override
    @Nonnull
    public InetSocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    @Nonnull
    public CapabilityManager.WithManagement getCapabilityManager() {
        return this.capabilityManager;
    }

    @Override
    @Nonnull
    public Optional<Channel> getChannel(@Nonnull String name) {
        return this.actorTracker.getTrackedChannel(Sanity.nullCheck(name, "Channel name cannot be null"));
    }

    @Override
    @Nonnull
    public Set<Channel> getChannels() {
        return this.actorTracker.getTrackedChannels();
    }

    @Override
    @Nonnull
    public Set<Channel> getChannels(@Nonnull Collection<String> channels) {
        return Sanity.nullCheck(channels, "Channels collection cannot be null").stream().filter(Objects::nonNull).map(this.actorTracker::getTrackedChannel).flatMap(optional -> optional.map(Stream::of).orElseGet(Stream::empty)).collect(Collectors.toSet());
    }

    @Override
    @Nonnull
    public DefaultMessageMap getDefaultMessageMap() {
        return this.defaultMessageMap;
    }

    @Override
    @Nonnull
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    @Nonnull
    public Listener<Exception> getExceptionListener() {
        return this.exceptionListener;
    }

    @Override
    @Nonnull
    public String getIntendedNick() {
        return this.goalNick;
    }

    @Override
    @Nonnull
    public ISupportManager getISupportManager() {
        return this.iSupportManager;
    }

    @Override
    @Nonnull
    public Optional<StsMachine> getStsMachine() {
        return Optional.ofNullable(this.stsMachine);
    }

    @Override
    @Nonnull
    public Cutter getMessageCutter() {
        return this.messageCutter;
    }

    @Override
    @Nonnull
    public Function<Client.WithManagement, ? extends MessageSendingQueue> getMessageSendingQueueSupplier() {
        return this.messageSendingQueueSupplier;
    }

    @Override
    @Nonnull
    public MessageTagManager getMessageTagManager() {
        return this.messageTagManager;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public String getNick() {
        return this.currentNick;
    }

    @Override
    @Nonnull
    public ServerInfo.WithManagement getServerInfo() {
        return this.serverInfo;
    }

    @Override
    @Nonnull
    public Optional<User> getUser() {
        return this.actorTracker.getTrackedUser(this.getNick());
    }

    @Override
    @Nonnull
    public Optional<ModeStatusList<UserMode>> getUserModes() {
        return this.userModes == null ? Optional.empty() : Optional.of(ModeStatusList.of(this.userModes.values()));
    }

    @Override
    public void knockChannel(@Nonnull String channelName) {
        this.sendRawLine("KNOCK " + Sanity.nullCheck(channelName, "Channel cannot be null"));
    }

    @Override
    public void removeChannel(@Nonnull String channelName) {
        this.removeChannelPlease(channelName, this.defaultMessageMap.getDefault(DefaultMessageType.PART).orElse(null));
    }

    @Override
    public void removeChannel(@Nonnull String channelName, @Nullable String reason) {
        this.removeChannelPlease(channelName, reason);
    }

    private void removeChannelPlease(@Nonnull String channelName, @Nullable String reason) {
        Sanity.truthiness(this.serverInfo.isValidChannel(channelName), "Invalid channel name " + channelName);
        if (reason != null) {
            Sanity.safeMessageCheck(reason, "Part reason");
        }
        this.channelsIntended.remove(channelName);
        this.sendRawLine("PART " + channelName + (reason != null ? " :" + reason : ""));
    }

    @Override
    public void sendCtcpMessage(@Nonnull String target, @Nonnull String message) {
        Sanity.safeMessageCheck(target, "Target");
        Sanity.safeMessageCheck(message);
        Sanity.truthiness(target.indexOf(32) == -1, "Target cannot have spaces");
        this.sendRawLine("PRIVMSG " + target + " :" + CtcpUtil.toCtcp(message));
    }

    @Override
    public void sendCtcpReply(@Nonnull String target, @Nonnull String message) {
        Sanity.safeMessageCheck(target, "Target");
        Sanity.safeMessageCheck(message);
        Sanity.truthiness(target.indexOf(32) == -1, "Target cannot have spaces");
        this.sendRawLine("NOTICE " + target + " :" + CtcpUtil.toCtcp(message));
    }

    @Override
    public void sendMessage(@Nonnull String target, @Nonnull String message) {
        Sanity.safeMessageCheck(target, "Target");
        Sanity.safeMessageCheck(message);
        Sanity.truthiness(target.indexOf(32) == -1, "Target cannot have spaces");
        this.sendRawLine("PRIVMSG " + target + " :" + message);
    }

    @Override
    public void sendMultiLineMessage(@Nonnull String target, @Nonnull String message, @Nonnull Cutter cutter) {
        Sanity.nullCheck(target, "Target cannot be null");
        Sanity.nullCheck(message, "Message cannot be null");
        Sanity.nullCheck(cutter, "Cutter cannot be null");
        cutter.split(message, this.getRemainingLength("PRIVMSG", target)).forEach(line -> this.sendMessage(target, (String)line));
    }

    @Override
    public void sendMultiLineNotice(@Nonnull String target, @Nonnull String message, @Nonnull Cutter cutter) {
        Sanity.nullCheck(target, "Target cannot be null");
        Sanity.nullCheck(message, "Message cannot be null");
        Sanity.nullCheck(cutter, "Cutter cannot be null");
        cutter.split(message, this.getRemainingLength("NOTICE", target)).forEach(line -> this.sendNotice(target, (String)line));
    }

    private int getRemainingLength(@Nonnull String type, @Nonnull String target) {
        return 505 - this.getUser().map(user -> user.getName().length()).orElse(100) - target.length() - type.length();
    }

    @Override
    @Nullable
    public Path getSecureKey() {
        return this.secureKey;
    }

    @Override
    @Nullable
    public Path getSecureKeyCertChain() {
        return this.secureKeyCertChain;
    }

    @Override
    @Nullable
    public String getSecureKeyPassword() {
        return this.secureKeyPassword;
    }

    @Override
    @Nullable
    public TrustManagerFactory getSecureTrustManagerFactory() {
        return this.secureTrustManagerFactory;
    }

    @Override
    @Nonnull
    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public void sendNotice(@Nonnull String target, @Nonnull String message) {
        Sanity.safeMessageCheck(target, "Target");
        Sanity.safeMessageCheck(message);
        Sanity.truthiness(target.indexOf(32) == -1, "Target cannot have spaces");
        this.sendRawLine("NOTICE " + target + " :" + message);
    }

    @Override
    public void sendRawLine(@Nonnull String message) {
        this.sendRawLine(message, false, false);
    }

    @Override
    public void sendRawLineAvoidingDuplication(@Nonnull String message) {
        this.sendRawLine(message, false, true);
    }

    @Override
    public void sendRawLineImmediately(@Nonnull String message) {
        this.sendRawLine(message, true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRawLine(@Nonnull String message, boolean priority, boolean avoidDuplicates) {
        Sanity.safeMessageCheck(message);
        if (!message.isEmpty() && message.length() > (message.charAt(0) == '@' ? 1022 : 510)) {
            throw new IllegalArgumentException("Message too long: " + message.length());
        }
        Object object = this.messageSendingLock;
        synchronized (object) {
            if (priority) {
                this.messageSendingImmediate.queue(message);
            } else if (!avoidDuplicates || !this.messageSendingScheduled.contains(message)) {
                this.messageSendingScheduled.queue(message);
            }
        }
    }

    @Override
    public void setExceptionListener(@Nullable Consumer<Exception> listener) {
        if (listener == null) {
            this.exceptionListener.removeConsumer();
        } else {
            this.exceptionListener.setConsumer(listener);
        }
    }

    @Override
    public void setDefaultMessageMap(@Nonnull DefaultMessageMap defaults) {
        Sanity.nullCheck(defaults, "Defaults cannot be null");
        this.defaultMessageMap = defaults;
    }

    @Override
    public void setInputListener(@Nullable Consumer<String> listener) {
        if (listener == null) {
            this.inputListener.removeConsumer();
        } else {
            this.inputListener.setConsumer(listener);
        }
    }

    @Override
    public void setMessageCutter(@Nonnull Cutter cutter) {
        this.messageCutter = Sanity.nullCheck(cutter, "Cutter cannot be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMessageSendingQueueSupplier(@Nonnull Function<Client.WithManagement, ? extends MessageSendingQueue> supplier) {
        this.messageSendingQueueSupplier = Sanity.nullCheck(supplier, "Supplier cannot be null");
        Object object = this.messageSendingLock;
        synchronized (object) {
            MessageSendingQueue newQueue = this.getMessageSendingQueueSupplier().apply(this);
            this.messageSendingScheduled.shutdown().forEach(newQueue::queue);
            Optional<Consumer<String>> consumer = this.messageSendingScheduled.getConsumer();
            this.messageSendingScheduled = newQueue;
            consumer.ifPresent(con -> this.messageSendingScheduled.beginSending((Consumer<String>)con));
        }
    }

    @Override
    public void setNick(@Nonnull String nick) {
        Sanity.safeMessageCheck(nick, "Nick");
        this.goalNick = nick.trim();
        this.sendNickChange(this.goalNick);
    }

    @Override
    public void setOutputListener(@Nullable Consumer<String> listener) {
        if (listener == null) {
            this.outputListener.removeConsumer();
        } else {
            this.outputListener.setConsumer(listener);
        }
    }

    @Override
    public void shutdown() {
        this.shutdownInternal(this.defaultMessageMap.getDefault(DefaultMessageType.QUIT).orElse(null));
    }

    @Override
    public void shutdown(@Nullable String reason) {
        if (reason != null) {
            Sanity.safeMessageCheck(reason, "Quit reason");
        }
        this.shutdownInternal(reason);
    }

    private void shutdownInternal(@Nullable String reason) {
        this.processor.interrupt();
        this.messageSendingImmediate.shutdown();
        this.messageSendingScheduled.shutdown();
        if (this.connection != null) {
            this.connection.shutdown(reason, false);
        }
        this.exceptionListener.shutdown();
        this.inputListener.shutdown();
        this.outputListener.shutdown();
    }

    @Nonnull
    public String toString() {
        return new ToStringer(this).add("name", this.getName()).add("server", this.serverAddress).toString();
    }

    @Override
    public void processLine(@Nonnull String line) {
        if (line.startsWith("PING ")) {
            this.sendRawLineImmediately("PONG " + line.substring(5));
        } else if (!line.isEmpty()) {
            this.processor.queue(line);
        }
    }

    @Override
    @Nonnull
    public ActorTracker getActorTracker() {
        return this.actorTracker;
    }

    @Override
    @Nonnull
    public Listener<String> getInputListener() {
        return this.inputListener;
    }

    @Override
    @Nonnull
    public Set<String> getIntendedChannels() {
        return this.channelsIntended;
    }

    @Override
    @Nonnull
    public Listener<String> getOutputListener() {
        return this.outputListener;
    }

    @Override
    @Nonnull
    public String getRequestedNick() {
        return this.requestedNick;
    }

    @Override
    public void connect() {
        String password;
        if (this.connection != null && this.connection.isAlive()) {
            throw new IllegalStateException("Client is already connecting");
        }
        this.connection = NettyManager.connect(this);
        this.processor.queue("");
        this.sendRawLineImmediately("CAP LS 302");
        if (this.webircPassword != null) {
            this.sendRawLineImmediately("WEBIRC " + this.webircPassword + ' ' + this.webircUser + ' ' + this.webircHost + ' ' + this.webircIP.getHostAddress());
        }
        if ((password = this.serverPassword) != null) {
            this.sendRawLineImmediately("PASS " + (password.contains(" ") ? ":" : "") + password);
        }
        this.sendRawLineImmediately("USER " + this.userString + " 8 * :" + this.realName);
        this.sendNickChange(this.goalNick);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beginMessageSendingImmediate(@Nonnull Consumer<String> consumer) {
        Object object = this.messageSendingLock;
        synchronized (object) {
            this.messageSendingImmediate.beginSending(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseMessageSending() {
        Object object = this.messageSendingLock;
        synchronized (object) {
            this.messageSendingImmediate.pause();
            this.messageSendingScheduled.pause();
        }
    }

    @Override
    public void ping() {
        this.sendRawLine("PING " + this.pingPurr[this.pingPurrCount++ % this.pingPurr.length]);
    }

    @Override
    public void sendNickChange(@Nonnull String newNick) {
        this.requestedNick = newNick;
        this.sendRawLineImmediately("NICK " + newNick);
    }

    @Override
    public void setCurrentNick(@Nonnull String nick) {
        this.currentNick = nick;
    }

    @Override
    public void setServerAddress(@Nonnull InetSocketAddress address) {
        this.serverAddress = address;
    }

    @Override
    public void setUserModes(@Nonnull ModeStatusList<UserMode> userModes) {
        this.userModes = new HashMap(userModes.getStatuses().stream().collect(Collectors.toMap(modeStatus -> Character.valueOf(((UserMode)modeStatus.getMode()).getChar()), Function.identity())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startSending() {
        this.connection.startPing();
        Object object = this.messageSendingLock;
        synchronized (object) {
            this.messageSendingScheduled.beginSending(this.messageSendingImmediate::queue);
        }
    }

    @Override
    public void updateUserModes(@Nonnull ModeStatusList<UserMode> userModes) {
        if (this.userModes == null) {
            this.userModes = new HashMap<Character, ModeStatus<UserMode>>();
        }
        for (ModeStatus<UserMode> status : userModes.getStatuses()) {
            if (status.isSetting()) {
                this.userModes.put(Character.valueOf(status.getMode().getChar()), status);
                continue;
            }
            this.userModes.remove(Character.valueOf(status.getMode().getChar()));
        }
    }

    @Override
    public void reconnect() {
        this.connection.shutdown(DefaultMessageType.RECONNECT, true);
    }

    @Override
    public void reconnect(@Nullable String reason) {
        this.connection.shutdown(reason, true);
    }

    @Override
    public boolean isSecureConnection() {
        return this.secure;
    }

    private void handleLine(@Nonnull String line) {
        String bit;
        String actorName;
        List<MessageTag> tags;
        int next;
        if (line.isEmpty()) {
            this.actorTracker.reset();
            this.capabilityManager.reset();
            this.serverInfo = this.serverInfoSupplier.apply(this);
            return;
        }
        int position = 0;
        while ((next = line.indexOf(32, position)) == position) {
            position = next + 1;
        }
        if (line.charAt(position) == '@') {
            String tagSection = line.substring(position, next);
            position = next + 1;
            if (tagSection.length() < 2) {
                throw new KittehServerMessageTagException(line, "Server sent an empty tag section");
            }
            tags = this.messageTagManager.getCapabilityTags(tagSection.substring(1));
            while ((next = line.indexOf(32, position)) == position) {
                position = next + 1;
            }
        } else {
            tags = Collections.unmodifiableList(new ArrayList());
        }
        if (line.charAt(position) == ':') {
            actorName = line.substring(position + 1, next);
            position = next + 1;
        } else {
            actorName = "";
        }
        Actor actor = this.actorTracker.getActor(actorName);
        String commandString = null;
        ArrayList<String> args = new ArrayList<String>();
        while ((next = line.indexOf(32, position)) != -1) {
            if (line.charAt(position) == ':') {
                ++position;
                break;
            }
            if (position != next) {
                bit = line.substring(position, next);
                if (commandString == null) {
                    commandString = bit;
                } else {
                    args.add(bit);
                }
            }
            position = next + 1;
        }
        if (position != line.length()) {
            bit = line.substring(line.charAt(position) == ':' ? position + 1 : position, line.length());
            if (commandString == null) {
                commandString = bit;
            } else {
                args.add(bit);
            }
        }
        if (commandString == null) {
            throw new KittehServerMessageException(new DefaultServerMessage(line, tags), "Server sent a message without a command");
        }
        try {
            int numeric = Integer.parseInt(commandString);
            this.eventManager.callEvent(new ClientReceiveNumericEvent(this, new DefaultServerMessage.NumericCommand(numeric, line, tags), actor, commandString, numeric, args));
        }
        catch (NumberFormatException exception) {
            this.eventManager.callEvent(new ClientReceiveCommandEvent(this, new DefaultServerMessage.StringCommand(commandString, line, tags), actor, commandString, args));
        }
    }

    @Override
    @Nonnull
    public Client.Commands commands() {
        return this.commands;
    }

    private final class InputProcessor
    extends QueueProcessingThread<String> {
        private InputProcessor() {
            super("KICL Input Processor (" + DefaultClient.this.getName() + ')');
        }

        @Override
        protected void processElement(@Nonnull String element) {
            try {
                DefaultClient.this.handleLine(element);
            }
            catch (Exception thrown) {
                DefaultClient.this.exceptionListener.queue(thrown);
            }
        }
    }

    private final class ClientCommands
    implements Client.Commands {
        private ClientCommands() {
        }

        @Override
        @Nonnull
        public AwayCommand away() {
            return new AwayCommand(DefaultClient.this);
        }

        @Override
        @Nonnull
        public CapabilityRequestCommand capabilityRequest() {
            return new CapabilityRequestCommand(DefaultClient.this);
        }

        @Override
        @Nonnull
        public ChannelModeCommand mode(@Nonnull Channel channel) {
            Sanity.nullCheck(channel, "Channel cannot be null");
            Sanity.truthiness(DefaultClient.this == channel.getClient(), "Client mismatch");
            return new ChannelModeCommand(DefaultClient.this, channel.getMessagingName());
        }

        @Override
        @Nonnull
        public KickCommand kick(@Nonnull Channel channel) {
            Sanity.nullCheck(channel, "Channel cannot be null");
            Sanity.truthiness(DefaultClient.this == channel.getClient(), "Client mismatch");
            return new KickCommand(DefaultClient.this, channel.getMessagingName());
        }

        @Override
        @Nonnull
        public MonitorCommand monitor() {
            return new MonitorCommand(DefaultClient.this);
        }

        @Override
        @Nonnull
        public OperCommand oper() {
            return new OperCommand(DefaultClient.this);
        }

        @Override
        @Nonnull
        public TopicCommand topic(@Nonnull Channel channel) {
            Sanity.nullCheck(channel, "Channel cannot be null");
            Sanity.truthiness(DefaultClient.this == channel.getClient(), "Client mismatch");
            return new TopicCommand(DefaultClient.this, channel.getMessagingName());
        }

        @Override
        @Nonnull
        public WallopsCommand wallops() {
            return new WallopsCommand(DefaultClient.this);
        }

        @Override
        @Nonnull
        public WhoisCommand whois() {
            return new WhoisCommand(DefaultClient.this);
        }
    }
}

