/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;

public class CapabilityRequestCommand
extends Command {
    private final List<String> requests = new ArrayList<String>();

    public CapabilityRequestCommand(@Nonnull Client client) {
        super(client);
    }

    @Nonnull
    public synchronized CapabilityRequestCommand enable(@Nonnull String capability) {
        this.requests.add(Sanity.safeMessageCheck(capability, "Capability"));
        return this;
    }

    @Nonnull
    public synchronized CapabilityRequestCommand disable(@Nonnull String capability) {
        this.requests.add('-' + Sanity.safeMessageCheck(capability, "Capability"));
        return this;
    }

    @Override
    public synchronized void execute() {
        StringBuilder builder = new StringBuilder(200);
        for (String request : this.requests) {
            if (builder.length() > 0 && request.length() + builder.length() > 200) {
                this.send(builder.toString());
                builder.setLength(0);
            }
            builder.append(request).append(' ');
        }
        this.send(builder.toString());
    }

    private void send(@Nonnull String requests) {
        this.getClient().sendRawLineImmediately("CAP REQ :" + requests);
    }

    @Override
    @Nonnull
    protected ToStringer toStringer() {
        return super.toStringer().add("requests", this.requests);
    }
}

