/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.configuration.loaders;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import ipsis.woot.loot.repository.ILootRepositoryLoad;
import ipsis.woot.oss.LogHelper;
import ipsis.woot.reference.Files;
import ipsis.woot.util.EnumEnchantKey;
import ipsis.woot.util.JsonHelper;
import ipsis.woot.util.WootMobName;
import java.io.FileReader;
import java.io.Reader;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;

public class FactoryLootLoader {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private ILootRepositoryLoad lootRepositoryLoad;

    public void loadConfig(ILootRepositoryLoad lootRepositoryLoad) {
        this.lootRepositoryLoad = lootRepositoryLoad;
        try {
            JsonObject jsonObject = (JsonObject)JsonUtils.func_193839_a((Gson)GSON, (Reader)new FileReader(Files.lootFile), JsonObject.class);
            this.parseConfig(jsonObject);
        }
        catch (Exception e) {
            LogHelper.error("Could not load factory loot from " + Files.lootFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    private void parseConfig(JsonObject json) {
        JsonObject json2;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        int version = JsonUtils.func_151208_a((JsonObject)json, (String)"version", (int)-1);
        if (version == -1 || version != 1) {
            throw new JsonSyntaxException("Invalid version");
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"mobs")) {
            if (ele == null || !ele.isJsonObject()) {
                throw new JsonSyntaxException("Mob must be an object");
            }
            json2 = (JsonObject)ele;
            WootMobName wootMobName = JsonHelper.getWootMobName(json2);
            if (!wootMobName.isValid()) continue;
            JsonArray jsonArray = JsonUtils.func_151214_t((JsonObject)json2, (String)"samples");
            if (jsonArray.size() != 4) {
                throw new JsonSyntaxException("Samples must contain 4 entries");
            }
            this.lootRepositoryLoad.loadMobSample(wootMobName, jsonArray.get(0).getAsInt(), jsonArray.get(1).getAsInt(), jsonArray.get(2).getAsInt(), jsonArray.get(3).getAsInt());
        }
        for (JsonElement ele : JsonUtils.func_151214_t((JsonObject)json, (String)"drops")) {
            if (ele == null || !ele.isJsonObject()) {
                throw new JsonSyntaxException("Drop must be an object");
            }
            json2 = (JsonObject)ele;
            ItemStack itemStack = JsonHelper.getItemStack(json2.getAsJsonObject("drop"));
            if (itemStack.func_190926_b()) {
                LogHelper.info("Ignoring invalid itemstack");
                continue;
            }
            this.lootRepositoryLoad.loadItem(itemStack);
            for (JsonElement ele2 : JsonUtils.func_151214_t((JsonObject)json2, (String)"mobs")) {
                if (ele2 == null || !ele2.isJsonObject()) {
                    throw new JsonSyntaxException("Drop must be an object");
                }
                JsonObject json3 = (JsonObject)ele2;
                WootMobName wootMobName = JsonHelper.getWootMobName(json3);
                if (!wootMobName.isValid()) continue;
                for (JsonElement ele3 : JsonUtils.func_151214_t((JsonObject)json3, (String)"sizes")) {
                    if (ele3 == null || !ele3.isJsonObject()) {
                        throw new JsonSyntaxException("Size must be an object");
                    }
                    JsonObject json4 = (JsonObject)ele3;
                    int count = JsonUtils.func_151203_m((JsonObject)json4, (String)"count");
                    int looting = JsonUtils.func_151203_m((JsonObject)json4, (String)"looting");
                    int samples = JsonUtils.func_151203_m((JsonObject)json4, (String)"samples");
                    EnumEnchantKey key = EnumEnchantKey.getEnchantKey(looting);
                    this.lootRepositoryLoad.loadMobDrop(wootMobName, key, itemStack, count, samples);
                }
            }
        }
    }
}

