/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei.category;

import com.buuz135.thaumicjei.ThaumcraftJEIPlugin;
import com.buuz135.thaumicjei.category.IHasResearch;
import com.buuz135.thaumicjei.drawable.AlphaDrawable;
import com.buuz135.thaumicjei.drawable.ItemStackDrawable;
import com.buuz135.thaumicjei.ingredient.AspectIngredientRender;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;

public class CrucibleCategory
implements IRecipeCategory<CrucibleWrapper> {
    public static final String UUID = "THAUMCRAFT_CRUCIBLE";
    public static final int ASPECT_Y = 66;
    public static final int ASPECT_X = 66;
    public static final int SPACE = 22;
    private final IGuiHelper helper;

    public CrucibleCategory(IGuiHelper helper) {
        this.helper = helper;
    }

    public String getUid() {
        return UUID;
    }

    public String getTitle() {
        return new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "crucible").toString())).func_82833_r();
    }

    public String getModName() {
        return "ThaumicJEI";
    }

    public IDrawable getBackground() {
        return new AlphaDrawable(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"), 2, 5, 109, 129, 0, 0, 10, 10);
    }

    @Nullable
    public IDrawable getIcon() {
        return new ItemStackDrawable(new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "crucible").toString())));
    }

    public void setRecipe(IRecipeLayout recipeLayout, CrucibleWrapper recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, false, 55, 8);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getOutputs(VanillaTypes.ITEM).get(0));
        recipeLayout.getItemStacks().init(1, true, 2, 2);
        recipeLayout.getItemStacks().set(1, (List)ingredients.getInputs(VanillaTypes.ITEM).get(0));
        int center = ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST).size() * 22 / 2;
        int x = 0;
        for (List aspectList : ingredients.getInputs(ThaumcraftJEIPlugin.ASPECT_LIST)) {
            recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).init(x + 1, true, (IIngredientRenderer)new AspectIngredientRender(), 66 - center + x * 22, 66, 16, 16, 0, 0);
            recipeLayout.getIngredientsGroup(ThaumcraftJEIPlugin.ASPECT_LIST).set(x + 1, aspectList);
            ++x;
        }
    }

    public void drawExtras(Minecraft minecraft) {
        minecraft.field_71446_o.func_110577_a(new ResourceLocation("thaumcraft", "textures/gui/gui_researchbook_overlay.png"));
        GL11.glEnable((int)3042);
        Gui.func_146110_a((int)16, (int)6, (float)199.0f, (float)168.0f, (int)26, (int)26, (float)512.0f, (float)512.0f);
        GL11.glDisable((int)3042);
    }

    public static class CrucibleWrapper
    implements IHasResearch,
    IRecipeWrapper {
        private final CrucibleRecipe recipe;

        public CrucibleWrapper(CrucibleRecipe recipe) {
            this.recipe = recipe;
        }

        public void getIngredients(IIngredients ingredients) {
            ingredients.setInputs(VanillaTypes.ITEM, Arrays.asList(this.recipe.getCatalyst().func_193365_a()));
            ingredients.setInputs(ThaumcraftJEIPlugin.ASPECT_LIST, Arrays.stream(this.recipe.getAspects().getAspectsSortedByAmount()).map(aspect -> new AspectList().add(aspect, this.recipe.getAspects().getAmount(aspect))).collect(Collectors.toList()));
            ingredients.setOutput(VanillaTypes.ITEM, (Object)this.recipe.getRecipeOutput());
        }

        public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        }

        @Override
        public String[] getResearch() {
            return new String[]{this.recipe.getResearch()};
        }
    }
}

