/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.thaumicjei;

import com.buuz135.thaumicjei.ThaumicJEI;
import com.buuz135.thaumicjei.category.ArcaneWorkbenchCategory;
import com.buuz135.thaumicjei.category.AspectCompoundCategory;
import com.buuz135.thaumicjei.category.AspectFromItemStackCategory;
import com.buuz135.thaumicjei.category.CrucibleCategory;
import com.buuz135.thaumicjei.category.InfusionCategory;
import com.buuz135.thaumicjei.config.ThaumicConfig;
import com.buuz135.thaumicjei.gui.FocalManipulatorAdvancedGuiHandler;
import com.buuz135.thaumicjei.gui.ResearchTableAdvancedGuiHandler;
import com.buuz135.thaumicjei.ingredient.AspectIngredientFactory;
import com.buuz135.thaumicjei.ingredient.AspectIngredientRender;
import com.buuz135.thaumicjei.ingredient.AspectListIngredientHelper;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IModIngredientRegistration;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IIngredientType;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.RegistryNamespaced;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.IThaumcraftRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.client.gui.GuiArcaneWorkbench;
import thaumcraft.common.container.ContainerArcaneWorkbench;

@JEIPlugin
public class ThaumcraftJEIPlugin
implements IModPlugin {
    private static final String ASPECT_PATH = "." + File.separator + "config" + File.separator + "thaumicjei_itemstack_aspects.json";
    public static final IIngredientType<AspectList> ASPECT_LIST = () -> AspectList.class;
    public static ArcaneWorkbenchCategory arcaneWorkbenchCategory;
    public static CrucibleCategory crucibleCategory;
    public static InfusionCategory infusionCategory;
    public static AspectFromItemStackCategory aspectFromItemStackCategory;
    public static AspectCompoundCategory aspectCompoundCategory;
    public static IJeiRuntime runtime;
    public static HashMap<IRecipeWrapper, String> recipes;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        subtypeRegistry.useNbtForSubtypes(new Item[]{Item.func_111206_d((String)"thaumcraft:crystal_essence")});
        subtypeRegistry.useNbtForSubtypes(new Item[]{Item.func_111206_d((String)"thaumcraft:phial")});
    }

    public void registerIngredients(IModIngredientRegistration registry) {
        registry.register(ASPECT_LIST, AspectIngredientFactory.create(), (IIngredientHelper)new AspectListIngredientHelper(), (IIngredientRenderer)new AspectIngredientRender());
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        arcaneWorkbenchCategory = new ArcaneWorkbenchCategory(registry.getJeiHelpers().getGuiHelper());
        crucibleCategory = new CrucibleCategory(registry.getJeiHelpers().getGuiHelper());
        infusionCategory = new InfusionCategory();
        aspectFromItemStackCategory = new AspectFromItemStackCategory();
        aspectCompoundCategory = new AspectCompoundCategory(registry.getJeiHelpers().getGuiHelper());
        registry.addRecipeCategories(new IRecipeCategory[]{arcaneWorkbenchCategory, crucibleCategory, infusionCategory, aspectCompoundCategory, aspectFromItemStackCategory});
    }

    public void register(IModRegistry registry) {
        registry.addRecipeCatalyst((Object)new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "arcane_workbench").toString())), new String[]{arcaneWorkbenchCategory.getUid()});
        registry.addRecipeClickArea(GuiArcaneWorkbench.class, 108, 56, 32, 32, new String[]{arcaneWorkbenchCategory.getUid()});
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(ContainerArcaneWorkbench.class, arcaneWorkbenchCategory.getUid(), 1, 9, 16, 36);
        registry.addRecipeCatalyst((Object)new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "crucible").toString())), new String[]{crucibleCategory.getUid()});
        registry.addRecipeCatalyst((Object)new ItemStack(Block.func_149684_b((String)new ResourceLocation("thaumcraft", "infusion_matrix").toString())), new String[]{infusionCategory.getUid()});
        ArrayList<CrucibleCategory.CrucibleWrapper> crucibleWrappers = new ArrayList<CrucibleCategory.CrucibleWrapper>();
        ArrayList<InfusionCategory.InfusionWrapper> infusionWrappers = new ArrayList<InfusionCategory.InfusionWrapper>();
        for (ResourceLocation string : ThaumcraftApi.getCraftingRecipes().keySet()) {
            IThaumcraftRecipe recipe = (IThaumcraftRecipe)ThaumcraftApi.getCraftingRecipes().get(string);
            if (recipe instanceof CrucibleRecipe) {
                crucibleWrappers.add(new CrucibleCategory.CrucibleWrapper((CrucibleRecipe)recipe));
            }
            if (!(recipe instanceof InfusionRecipe) || ((InfusionRecipe)recipe).getRecipeInput() == null || ((InfusionRecipe)recipe).recipeOutput == null) continue;
            infusionWrappers.add(new InfusionCategory.InfusionWrapper((InfusionRecipe)recipe));
        }
        registry.addRecipes((Collection)CraftingManager.field_193380_a.func_148742_b().stream().map(arg_0 -> ((RegistryNamespaced)CraftingManager.field_193380_a).func_82594_a(arg_0)).filter(iRecipe -> iRecipe instanceof IArcaneRecipe).map(iRecipe -> new ArcaneWorkbenchCategory.ArcaneWorkbenchWrapper((IArcaneRecipe)iRecipe)).collect(Collectors.toList()), arcaneWorkbenchCategory.getUid());
        registry.addRecipes(crucibleWrappers, crucibleCategory.getUid());
        registry.addRecipes(infusionWrappers, infusionCategory.getUid());
        registry.addRecipeCatalyst((Object)new ItemStack(Item.func_111206_d((String)new ResourceLocation("thaumcraft", "thaumonomicon").toString())), new String[]{aspectFromItemStackCategory.getUid()});
        if (ThaumicConfig.enableAspectFromItemStacks) {
            File aspectFile = new File(ASPECT_PATH);
            if (!aspectFile.exists() || ThaumicConfig.alwaysRecreateAspectFromItemStackFile) {
                new Thread(() -> {
                    ThaumicJEI.LOGGER.info("Starting Aspect ItemStack Thread.");
                    ThaumicJEI.LOGGER.info("Trying to cache " + registry.getIngredientRegistry().getAllIngredients(ItemStack.class).size() + " aspects.");
                    this.createAspectsFile(new ArrayList<ItemStack>(registry.getIngredientRegistry().getAllIngredients(ItemStack.class)));
                    ThaumicJEI.LOGGER.info("Finished Aspect ItemStack Thread.");
                }, "ThaumicJEI Aspect Cache").start();
            }
            if (aspectFile.exists()) {
                try {
                    long time = System.currentTimeMillis();
                    AspectCache[] aspectCaches = (AspectCache[])new Gson().fromJson((Reader)new FileReader(aspectFile), AspectCache[].class);
                    ArrayList<AspectFromItemStackCategory.AspectFromItemStackWrapper> wrappers = new ArrayList<AspectFromItemStackCategory.AspectFromItemStackWrapper>();
                    for (AspectCache aspectCache : aspectCaches) {
                        Aspect aspect = Aspect.getAspect((String)aspectCache.aspect);
                        if (aspect == null) continue;
                        List items = aspectCache.items.stream().map(s -> {
                            try {
                                return JsonToNBT.func_180713_a((String)s);
                            }
                            catch (NBTException e) {
                                e.printStackTrace();
                                return null;
                            }
                        }).filter(Objects::nonNull).map(compound -> {
                            short trueCount = compound.func_74765_d("Count");
                            if (trueCount > 127) {
                                compound.func_74774_a("Count", (byte)127);
                            }
                            ItemStack itemStack = new ItemStack(compound);
                            itemStack.func_190920_e((int)trueCount);
                            return itemStack;
                        }).filter(stack -> !stack.func_190926_b()).sorted(Comparator.comparing(ItemStack::func_190916_E).reversed()).collect(Collectors.toList());
                        for (int start = 0; start < items.size(); start += 36) {
                            wrappers.add(new AspectFromItemStackCategory.AspectFromItemStackWrapper(new AspectList().add(aspect, 1), items.subList(start, Math.min(start + 36, items.size()))));
                        }
                    }
                    registry.addRecipes(wrappers, aspectFromItemStackCategory.getUid());
                    ThaumicJEI.LOGGER.info("Parsed aspect file in " + (System.currentTimeMillis() - time) + "ms");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (JsonSyntaxException e) {
                    e.printStackTrace();
                }
            }
        }
        registry.addRecipeCatalyst((Object)new ItemStack(Item.func_111206_d((String)new ResourceLocation("thaumcraft", "thaumonomicon").toString())), new String[]{aspectCompoundCategory.getUid()});
        ArrayList<AspectCompoundCategory.AspectCompoundWrapper> compoundWrappers = new ArrayList<AspectCompoundCategory.AspectCompoundWrapper>();
        for (Aspect aspect : Aspect.getCompoundAspects()) {
            compoundWrappers.add(new AspectCompoundCategory.AspectCompoundWrapper(aspect));
        }
        registry.addRecipes(compoundWrappers, aspectCompoundCategory.getUid());
        registry.addIngredientInfo(Arrays.asList(new ItemStack(Item.func_111206_d((String)new ResourceLocation("thaumcraft", "salis_mundus").toString())), new ItemStack(Item.func_111206_d((String)new ResourceLocation("thaumcraft", "crystal_essence").toString()))), VanillaTypes.ITEM, new String[]{"To create Salis Mundis, take 3 Vis Crystals of different types and combine them with Redstone Dust by crafting them with a flint and a bowl."});
        registry.addIngredientInfo((Object)new ItemStack(Item.func_111206_d((String)new ResourceLocation("thaumcraft", "triple_meat_treat").toString())), ItemStack.class, new String[]{"To create the Triple Meat Treat, take 3 different kinds of meat nuggets (produced by cooking meat in the Infernal Furnace) and mix them with sugar."});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new ResearchTableAdvancedGuiHandler()});
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{new FocalManipulatorAdvancedGuiHandler()});
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        runtime = jeiRuntime;
        CraftingManager.field_193380_a.func_148742_b().stream().map(arg_0 -> ((RegistryNamespaced)CraftingManager.field_193380_a).func_82594_a(arg_0)).filter(iRecipe -> iRecipe instanceof IArcaneRecipe && jeiRuntime.getRecipeRegistry().getRecipeWrapper(iRecipe, "minecraft.crafting") != null).forEach(iRecipe -> jeiRuntime.getRecipeRegistry().hideRecipe(jeiRuntime.getRecipeRegistry().getRecipeWrapper(iRecipe, "minecraft.crafting")));
        recipes.clear();
        for (String uuid : new String[]{arcaneWorkbenchCategory.getUid(), crucibleCategory.getUid(), infusionCategory.getUid()}) {
            jeiRuntime.getRecipeRegistry().getRecipeWrappers(jeiRuntime.getRecipeRegistry().getRecipeCategory(uuid)).forEach(o -> {
                recipes.put((IRecipeWrapper)o, uuid);
                if (ThaumicConfig.hideRecipesIfMissingResearch) {
                    jeiRuntime.getRecipeRegistry().hideRecipe((IRecipeWrapper)o, uuid);
                }
            });
        }
    }

    public void createAspectsFile(Collection<ItemStack> items) {
        List<String> blacklist = Arrays.asList(ThaumicConfig.blacklistedFromAspectChecking);
        int prevAmount = items.size();
        items.removeIf(stack -> blacklist.contains(stack.func_77973_b().getRegistryName().toString()));
        ThaumicJEI.LOGGER.info("Removed " + (prevAmount - items.size()) + " items that are blacklisted");
        int cachedAmount = 0;
        long lastTimeChecked = System.currentTimeMillis();
        HashMap aspectCacheHashMap = Maps.newHashMap();
        for (ItemStack stack2 : items) {
            AspectList list = new AspectList(stack2);
            if (list.size() > 0) {
                for (Aspect aspect : list.getAspects()) {
                    ItemStack clone = stack2.func_77946_l();
                    clone.func_190920_e(list.getAmount(aspect));
                    AspectCache cache = aspectCacheHashMap.getOrDefault(aspect, new AspectCache(aspect.getTag()));
                    NBTTagCompound nbtTagCompound = clone.serializeNBT();
                    nbtTagCompound.func_74777_a("Count", (short)clone.func_190916_E());
                    cache.items.add(nbtTagCompound.toString());
                    aspectCacheHashMap.put(aspect, cache);
                }
            }
            ++cachedAmount;
            if (lastTimeChecked + 5000L >= System.currentTimeMillis()) continue;
            lastTimeChecked = System.currentTimeMillis();
            ThaumicJEI.LOGGER.info("ItemStack Aspect checking at " + 100 * cachedAmount / items.size() + "%");
        }
        try {
            File output = new File(ASPECT_PATH);
            output.createNewFile();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            FileWriter writer = new FileWriter(output);
            gson.toJson(aspectCacheHashMap.values(), (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        recipes = new HashMap();
    }

    private class AspectCache {
        private String aspect;
        private List<String> items = new ArrayList<String>();

        public AspectCache() {
        }

        public AspectCache(String aspect) {
            this();
            this.aspect = aspect;
        }
    }
}

