/*
 * Decompiled with CFR 0.152.
 */
package elec332.core.inventory.widget.slot;

import elec332.core.client.RenderHelper;
import elec332.core.client.util.GuiDraw;
import elec332.core.inventory.tooltip.ToolTip;
import elec332.core.inventory.widget.Widget;
import elec332.core.inventory.window.Window;
import elec332.core.util.ItemStackHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class WidgetSlot
extends Widget {
    private final IItemHandler inventory;
    private final int slotIndex;
    private String backgroundName = null;
    private ResourceLocation backgroundLocation = null;
    private Object backgroundMap;

    public WidgetSlot(IItemHandler inventory, int index, int x, int y) {
        super(x, y, 0, 0, 16, 16);
        this.inventory = inventory;
        this.slotIndex = index;
    }

    @Override
    public void draw(Window window, int guiX, int guiY, int mouseX, int mouseY) {
        RenderHelper.bindTexture(Window.DEFAULT_BACKGROUND);
        GuiDraw.drawTexturedModalRect(guiX + this.x - 1, guiY + this.y - 1, 180, 0, 18, 18);
    }

    @Override
    public void onWindowClosed(EntityPlayer player) {
    }

    public void onSlotChange(ItemStack newStack, ItemStack oldStack) {
        int i = oldStack.func_190916_E() - newStack.func_190916_E();
        if (i > 0) {
            this.onCrafting(oldStack, i);
        }
    }

    public void onCrafting(ItemStack stack, int amount) {
    }

    public void onSwapCraft(int slot) {
    }

    public void onCrafting(ItemStack stack) {
    }

    public boolean canMergeSlot(ItemStack stack) {
        return true;
    }

    @Nonnull
    public ItemStack onTake(EntityPlayer player, @Nonnull ItemStack stack) {
        this.onSlotChanged();
        return stack;
    }

    public boolean isItemValid(ItemStack stack) {
        ItemStack remainder;
        if (this.isHidden() || !ItemStackHelper.isStackValid(stack)) {
            return false;
        }
        IItemHandler handler = this.getInventory();
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            ItemStack currentStack = handlerModifiable.getStackInSlot(this.getSlotIndex());
            handlerModifiable.setStackInSlot(this.getSlotIndex(), ItemStackHelper.NULL_STACK);
            remainder = handlerModifiable.insertItem(this.getSlotIndex(), stack, true);
            handlerModifiable.setStackInSlot(this.getSlotIndex(), currentStack);
        } else {
            remainder = handler.insertItem(this.getSlotIndex(), stack, true);
        }
        return !ItemStackHelper.isStackValid(remainder) || remainder.func_190916_E() < stack.func_190916_E();
    }

    @Nonnull
    public ItemStack getStack() {
        return this.isHidden() ? ItemStackHelper.NULL_STACK : this.getInventory().getStackInSlot(this.getSlotIndex());
    }

    public boolean getHasStack() {
        return !this.isHidden() && ItemStackHelper.isStackValid(this.getStack());
    }

    public void putStack(@Nonnull ItemStack stack) {
        ((IItemHandlerModifiable)this.getInventory()).setStackInSlot(this.getSlotIndex(), stack);
        this.onSlotChanged();
    }

    public void onSlotChanged() {
    }

    public int getSlotStackLimit() {
        return 64;
    }

    public int getItemStackLimit(ItemStack stack) {
        ItemStack maxAdd = stack.func_77946_l();
        int maxInput = stack.func_77976_d();
        maxAdd.func_190920_e(maxInput);
        IItemHandler handler = this.getInventory();
        ItemStack currentStack = handler.getStackInSlot(this.getSlotIndex());
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable handlerModifiable = (IItemHandlerModifiable)handler;
            handlerModifiable.setStackInSlot(this.getSlotIndex(), ItemStackHelper.NULL_STACK);
            ItemStack remainder = handlerModifiable.insertItem(this.getSlotIndex(), maxAdd, true);
            handlerModifiable.setStackInSlot(this.getSlotIndex(), currentStack);
            return maxInput - (ItemStackHelper.isStackValid(remainder) ? remainder.func_190916_E() : 0);
        }
        ItemStack remainder = handler.insertItem(this.getSlotIndex(), maxAdd, true);
        int current = !ItemStackHelper.isStackValid(currentStack) ? 0 : currentStack.func_190916_E();
        int added = maxInput - (ItemStackHelper.isStackValid(remainder) ? remainder.func_190916_E() : 0);
        return current + added;
    }

    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String getSlotTexture() {
        return this.backgroundName;
    }

    @Nonnull
    public ItemStack decrStackSize(int amount) {
        return this.getInventory().extractItem(this.getSlotIndex(), amount, false);
    }

    public boolean isHere(IInventory inv, int slotIn) {
        return !this.isHidden() && inv == this.inventory && slotIn == this.getSlotIndex();
    }

    public boolean canTakeStack(EntityPlayer playerIn) {
        return !this.isHidden() && ItemStackHelper.isStackValid(this.inventory.extractItem(this.getSlotIndex(), 1, true));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canBeHovered() {
        return !this.isHidden();
    }

    @SideOnly(value=Side.CLIENT)
    @Nonnull
    public ResourceLocation getBackgroundLocation() {
        return this.backgroundLocation == null ? TextureMap.field_110575_b : this.backgroundLocation;
    }

    @SideOnly(value=Side.CLIENT)
    public void setBackgroundLocation(@Nonnull ResourceLocation texture) {
        this.backgroundLocation = texture;
    }

    public void setBackgroundName(@Nonnull String name) {
        this.backgroundName = name;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getBackgroundSprite() {
        String name = this.getSlotTexture();
        return name == null ? null : this.getBackgroundMap().func_110572_b(name);
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public TextureMap getBackgroundMap() {
        if (this.backgroundMap == null) {
            this.backgroundMap = Minecraft.func_71410_x().func_147117_R();
        }
        return (TextureMap)this.backgroundMap;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    public boolean isSameInventory(WidgetSlot other) {
        return other.getInventory() == this.getInventory();
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public ToolTip getToolTip(int mouseX, int mouseY) {
        ItemStack stack = this.getStack();
        if (ItemStackHelper.isStackValid(stack)) {
            return new ToolTip(GuiDraw.getItemToolTip(stack), new Object[0]);
        }
        return null;
    }
}

