/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.coin_miner.tile;

import com.feed_the_beast.coin_miner.MoneyUtils;
import com.feed_the_beast.coin_miner.tile.ExtendedEnergyStorage;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import org.apache.commons.lang3.Validate;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.tile.TileLegacyMachineBase;

@RebornRegistry(modID="ftb_beast_coin_miner")
public class TileBeastCoinMiner
extends TileLegacyMachineBase
implements IContainerProvider {
    public String owner = "unknown";
    public long money = 0L;
    public long total_money = 0L;
    public long cost = 0L;
    private BigInteger client_energy = BigInteger.ZERO;
    ExtendedEnergyStorage energyStorage = new ExtendedEnergyStorage(() -> !this.field_145850_b.func_175640_z(this.func_174877_v()));

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            if (!this.field_145850_b.func_175640_z(this.field_174879_c)) {
                MinecraftServer server = this.field_145850_b.func_73046_m();
                EntityPlayerMP player = null;
                if (!this.owner.equals("unknown")) {
                    player = server.func_184103_al().func_177451_a(UUID.fromString(this.owner));
                }
                if (player != null) {
                    this.update((EntityPlayer)player);
                } else {
                    this.money = 0L;
                }
            }
            this.client_energy = this.energyStorage.getEnergy();
        }
        super.func_73660_a();
    }

    public void update(EntityPlayer player) {
        long coinCost = this.getCoinCost(MoneyUtils.getTotalMoney(player));
        Validate.notNull((Object)coinCost);
        if (this.energyStorage.getEnergy().compareTo(BigInteger.valueOf(coinCost)) > 0) {
            this.energyStorage.takeEnergy(BigInteger.valueOf(coinCost));
            MoneyUtils.addMoney(player, 1L);
            MoneyUtils.addTotalMoney(player);
        }
        this.money = MoneyUtils.getMoney(player);
        this.total_money = MoneyUtils.getTotalMoney(player);
        this.cost = this.getCoinCost(this.total_money);
    }

    public long getCoinCost(long coins) {
        double exponent = Math.pow(60.0, 1.2500156117312144E-5);
        long cost = (long)(4095.0 + Math.pow(exponent, coins - 1L));
        return cost;
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.owner = tagCompound.func_74779_i("tile_owner");
        this.energyStorage.deserializeNBT(tagCompound.func_74775_l("fe_power"));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        tagCompound.func_74778_a("tile_owner", this.owner);
        tagCompound.func_74782_a("fe_power", (NBTBase)this.energyStorage.serializeNBT());
        return super.func_189515_b(tagCompound);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("beast_coin_miner").player(player.field_71071_by).inventory().hotbar().addInventory().tile((IInventory)this).sync(this::getClient_energy, this::setClient_energy).syncLongValue(this::getMoney, this::setMoney).syncLongValue(this::getTotal_money, this::setTotal_money).sync(this::getCost, this::setCost).sync(this::getOwner, this::setOwner).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public boolean hasSlotConfig() {
        return false;
    }

    public long getMoney() {
        return this.money;
    }

    public void setMoney(long money) {
        this.money = money;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public long getCost() {
        return this.cost;
    }

    public void setCost(long cost) {
        this.cost = cost;
    }

    public BigInteger getClient_energy() {
        return this.client_energy;
    }

    public void setClient_energy(BigInteger client_energy) {
        this.client_energy = client_energy;
    }

    public long getTotal_money() {
        return this.total_money;
    }

    public void setTotal_money(long total_money) {
        this.total_money = total_money;
    }
}

