/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.coin_miner.tile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.function.BooleanSupplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.energy.IEnergyStorage;
import org.apache.commons.lang3.Validate;

public class ExtendedEnergyStorage
implements INBTSerializable<NBTTagCompound>,
IEnergyStorage {
    protected BigInteger energy = BigInteger.ZERO;
    BooleanSupplier shouldAccept;

    public ExtendedEnergyStorage(BooleanSupplier shouldAccept) {
        this.shouldAccept = shouldAccept;
    }

    public ExtendedEnergyStorage() {
        this(() -> true);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        try {
            tagCompound.func_74773_a("energy_big", this.toBytes(this.energy));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write BigInteger", e);
        }
        return tagCompound;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (!nbt.func_74764_b("energy_big")) {
            this.energy = BigInteger.ZERO;
            return;
        }
        try {
            this.energy = this.fromBytes(nbt.func_74770_j("energy_big"));
            Validate.notNull((Object)this.energy);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException("Failed to read BigInteger", e);
        }
    }

    public BigInteger getEnergy() {
        Validate.notNull((Object)this.energy);
        return this.energy;
    }

    public void takeEnergy(BigInteger integer) {
        this.energy = this.energy.subtract(integer);
    }

    public void putEnergy(BigInteger integer) {
        this.energy = this.energy.add(integer);
    }

    private byte[] toBytes(BigInteger integer) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream outputStream = new ObjectOutputStream(baos);
        outputStream.writeObject(integer);
        return baos.toByteArray();
    }

    private BigInteger fromBytes(byte[] bytes) throws IOException, ClassNotFoundException {
        ObjectInputStream inputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        return (BigInteger)inputStream.readObject();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (!this.shouldAccept.getAsBoolean()) {
            return 0;
        }
        if (!simulate) {
            this.putEnergy(BigInteger.valueOf(maxReceive));
        }
        return maxReceive;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return this.energy.intValue();
    }

    public int getMaxEnergyStored() {
        return Integer.MAX_VALUE;
    }

    public boolean canExtract() {
        return false;
    }

    public boolean canReceive() {
        return this.shouldAccept.getAsBoolean();
    }
}

