/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.handlers;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class SplashTextHandler {
    private static final ResourceLocation SPLASH_TEXTS = new ResourceLocation("texts/splashes.txt");
    private static final ResourceLocation EXTRA_SPLASH_TEXTS = new ResourceLocation("charset:texts/extra_splashes.txt");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void addTexts(List<String> splashes, ResourceLocation loc) {
        IResource resource = null;
        try {
            String s;
            resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(loc);
            BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(resource.func_110527_b(), Charsets.UTF_8));
            while ((s = bufferedreader.readLine()) != null) {
                if (s.length() == 0 || s.charAt(0) == '#' || (s = s.trim()).isEmpty()) continue;
                splashes.add(s);
            }
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly((Closeable)resource);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(resource);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)resource);
    }

    public String getSplashText(List<String> splashes) {
        Random rand = new Random();
        if (!splashes.isEmpty()) {
            String splashText;
            while ((splashText = splashes.get(rand.nextInt(splashes.size()))).hashCode() == 125780783) {
            }
            return splashText;
        }
        return "?";
    }

    @SubscribeEvent
    public void customSplashes(GuiScreenEvent.InitGuiEvent.Pre event) {
        if (event.getGui() instanceof GuiMainMenu) {
            GuiMainMenu menu = (GuiMainMenu)event.getGui();
            Field splashTextField = ReflectionHelper.findField(GuiMainMenu.class, (String)"splashText", (String)"field_73975_c");
            ArrayList<String> splashes = new ArrayList<String>();
            this.addTexts(splashes, SPLASH_TEXTS);
            this.addTexts(splashes, EXTRA_SPLASH_TEXTS);
            try {
                splashTextField.set(menu, this.getSplashText(splashes));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

