/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.render;

import com.google.common.collect.ImmutableMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelStateComposition;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import pl.asie.charset.lib.render.model.ModelFactory;
import pl.asie.charset.lib.render.model.ModelTransformer;
import pl.asie.charset.lib.render.model.SimpleBakedModel;
import pl.asie.simplelogic.gates.BlockGate;
import pl.asie.simplelogic.gates.ItemGate;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.SimpleLogicGates;
import pl.asie.simplelogic.gates.SimpleLogicGatesClient;
import pl.asie.simplelogic.gates.logic.GateLogic;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;
import pl.asie.simplelogic.gates.render.GateCustomRenderer;
import pl.asie.simplelogic.gates.render.GateRenderDefinitions;

public class RendererGate
extends ModelFactory<PartGate> {
    public static final RendererGate INSTANCE = new RendererGate();
    private static final ModelRotation[] ROTATIONS_SIDE = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private static final ModelRotation[] ROTATIONS_TOP = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y0, ModelRotation.X0_Y180, ModelRotation.X0_Y270, ModelRotation.X0_Y90};
    private static final ModelStateComposition[] COMPOSITIONS;
    private static final Map<String, IModel> layerModels;
    private final TRSRTransformation shiftGuiTransform;

    public RendererGate() {
        super(BlockGate.PROPERTY, new ResourceLocation("minecraft:blocks/stone_slab_top"));
        this.addDefaultBlockTransforms();
        this.addThirdPersonTransformation(RendererGate.getTransformation((float)0.0f, (float)2.5f, (float)2.75f, (float)75.0f, (float)45.0f, (float)0.0f, (float)0.375f));
        this.shiftGuiTransform = RendererGate.getTransformation((float)0.0f, (float)-16.0f, (float)0.0f, (float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public boolean shouldCache(PartGate object, BlockRenderLayer layer) {
        return layer != null || SimpleLogicGatesClient.INSTANCE.getRenderer(object.logic.getClass()) != null;
    }

    public void invalidate() {
        super.invalidate();
        layerModels.clear();
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI && GuiScreen.func_146272_n()) {
            return ImmutablePair.of((Object)((Object)this), (Object)this.shiftGuiTransform.getMatrix());
        }
        return super.handlePerspective(cameraTransformType);
    }

    public ModelStateComposition getTransform(IGateContainer gate) {
        return COMPOSITIONS[gate.getSide().ordinal() * 6 + gate.getTop().ordinal()];
    }

    public boolean addBase(SimpleBakedModel result, ModelStateComposition transform, PartGate gate) {
        GateLogic logic = gate.logic;
        GateRenderDefinitions.Definition definition = GateRenderDefinitions.INSTANCE.getGateDefinition(SimpleLogicGates.getId(logic));
        if (definition == null) {
            result.addModel(ModelLoaderRegistry.getMissingModel().bake((IModelState)transform, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter()));
            return false;
        }
        IModel model = definition.getModel(gate.getBaseModelName());
        if (model != null) {
            result.addModel(model.bake((IModelState)transform, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter()));
        }
        return true;
    }

    public void addLayers(SimpleBakedModel result, ModelStateComposition transform, PartGate gate, boolean isItem) {
        GateLogic logic = gate.logic;
        GateRenderDefinitions.Definition definition = GateRenderDefinitions.INSTANCE.getGateDefinition(SimpleLogicGates.getId(logic));
        GateRenderDefinitions.BaseDefinition base = GateRenderDefinitions.INSTANCE.base;
        IModel layerModel = definition.getModel(gate.getLayerModelName());
        int i = 0;
        for (GateRenderDefinitions.Layer layer : definition.layers) {
            IModel model;
            GateRenderState state;
            if ((state = gate.logic.getLayerState(i++)) == GateRenderState.NO_RENDER) continue;
            ModelStateComposition layerTransform = transform;
            if (layer.height != 0) {
                layerTransform = new ModelStateComposition((IModelState)new TRSRTransformation(new Vector3f(0.0f, (float)layer.height / 16.0f, 0.0f), null, null, null), (IModelState)transform);
            }
            if ("color".equals(layer.type) && layer.texture != null) {
                String key = layer.texture;
                if (gate.mirrored) {
                    key = "m$" + key;
                }
                if ((model = layerModels.get(key)) == null) {
                    model = layerModel.retexture(ImmutableMap.of((Object)"layer", (Object)layer.texture));
                    layerModels.put(key, model);
                }
                IBakedModel bakedModel = model.bake((IModelState)layerTransform, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
                int color = state == GateRenderState.ON ? base.colorMul.get("on") : (state == GateRenderState.OFF ? base.colorMul.get("off").intValue() : base.colorMul.get("disabled").intValue());
                try {
                    result.addModel(ModelTransformer.transform((IBakedModel)bakedModel, (IBlockState)SimpleLogicGates.blockGate.func_176223_P(), (long)0L, (quad, element, data) -> {
                        if (element.func_177375_c() == VertexFormatElement.EnumUsage.COLOR) {
                            return new float[]{(float)(color & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color >> 16 & 0xFF) / 255.0f, 1.0f};
                        }
                        return data;
                    }));
                    continue;
                }
                catch (ModelTransformer.TransformationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
            if (!"map".equals(layer.type) || layer.textures == null) continue;
            String texture = layer.textures.get(state.name().toLowerCase(Locale.ENGLISH));
            if (texture == null && (texture = layer.textures.get("off")) == null) {
                texture = layer.textures.get("disabled");
            }
            if (texture == null) continue;
            String key = texture;
            if (gate.mirrored) {
                key = "m$" + key;
            }
            if ((model = layerModels.get(key)) == null) {
                model = layerModel.retexture(ImmutableMap.of((Object)"layer", (Object)texture));
                layerModels.put(key, model);
            }
            result.addModel(model.bake((IModelState)layerTransform, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter()));
        }
        EnumSet<EnumFacing> invertedSides = EnumSet.noneOf(EnumFacing.class);
        i = 0;
        for (GateRenderDefinitions.Torch torch : definition.torches) {
            String torchColorStr;
            float yOffset;
            String name;
            GateRenderState state;
            if (torch.inverter != null) {
                EnumFacing inverter = EnumFacing.func_176739_a((String)torch.inverter);
                if (!gate.logic.isSideInverted(inverter)) continue;
                invertedSides.add(inverter);
                state = GateRenderState.bool(gate.getInverterState(inverter));
            } else if ((state = gate.logic.getTorchState(i++)) == GateRenderState.NO_RENDER) continue;
            String string = state == GateRenderState.ON ? (torch.model_on == null ? "torch_on" : torch.model_on) : (name = torch.model_off == null ? "torch_off" : torch.model_off);
            if (state == GateRenderState.DISABLED && torch.model_disabled != null) {
                name = torch.model_disabled;
            }
            if (name.length() <= 0) continue;
            float xPos = (torch.pos[0] - 7.5f) / 16.0f;
            float zPos = (torch.pos[1] - 7.5f) / 16.0f;
            float f = yOffset = torch.pos.length >= 3 ? torch.pos[2] / 16.0f : 0.0f;
            if (gate.mirrored) {
                xPos = -xPos;
            }
            IBakedModel torchModel = definition.getModel(name).bake((IModelState)new ModelStateComposition((IModelState)transform, (IModelState)new TRSRTransformation(new Vector3f(xPos, yOffset, zPos), null, null, null)), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            String string2 = torchColorStr = state == GateRenderState.ON ? torch.color_on : torch.color_off;
            if (torchColorStr != null) {
                int torchColor = Integer.parseInt(torchColorStr, 16);
                if ((torchColor & 0xFF000000) == 0) {
                    torchColor |= 0xFF000000;
                }
                try {
                    torchModel = ModelTransformer.transform((IBakedModel)torchModel, (IBlockState)SimpleLogicGates.blockGate.func_176223_P(), (long)0L, (ModelTransformer.IVertexTransformer)ModelTransformer.IVertexTransformer.tint((int)torchColor));
                }
                catch (ModelTransformer.TransformationFailedException e) {
                    throw new RuntimeException(e);
                }
            }
            result.addModel(torchModel);
        }
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!gate.logic.isSideInverted(facing) || invertedSides.contains(facing)) continue;
            result.addModel(definition.getModel(gate.getInverterState(facing) ? "torch_on" : "torch_off").bake((IModelState)new ModelStateComposition((IModelState)transform, (IModelState)new TRSRTransformation(new Vector3f((float)facing.func_82601_c() * 6.9875f / 16.0f, 0.0f, (float)facing.func_82599_e() * 6.9875f / 16.0f), null, null, null)), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter()));
        }
        GateCustomRenderer gateCustomRenderer = SimpleLogicGatesClient.INSTANCE.getRenderer(gate.logic.getClass());
        if (gateCustomRenderer != null) {
            this.appendStaticModels(gateCustomRenderer, gate, result, isItem);
        }
    }

    private void appendStaticModels(GateCustomRenderer renderer, PartGate gate, SimpleBakedModel model, boolean isItem) {
        renderer.renderStatic(gate, gate.logic, isItem, m -> model.addModel((IBakedModel)m), (q, f) -> model.addQuad((EnumFacing)f, (BakedQuad)q));
    }

    public IBakedModel bake(PartGate gate, boolean isItem, BlockRenderLayer blockRenderLayer) {
        SimpleBakedModel result = new SimpleBakedModel((IBakedModel)this);
        ModelStateComposition transform = this.getTransform(gate);
        if (!this.addBase(result, transform, gate)) {
            return result;
        }
        if (!SimpleLogicGates.useTESRs || isItem) {
            this.addLayers(result, transform, gate, isItem);
        }
        return result;
    }

    public PartGate fromItemStack(ItemStack stack) {
        Optional<PartGate> g = ItemGate.getPartGate(stack);
        g.ifPresent(a -> a.logic.updateOutputs((IGateContainer)a));
        return g.orElse(null);
    }

    static {
        layerModels = new HashMap<String, IModel>();
        COMPOSITIONS = new ModelStateComposition[36];
        for (int i = 0; i < 36; ++i) {
            RendererGate.COMPOSITIONS[i] = new ModelStateComposition((IModelState)TRSRTransformation.from((ModelRotation)ROTATIONS_SIDE[i / 6]), (IModelState)TRSRTransformation.from((ModelRotation)ROTATIONS_TOP[i % 6]));
        }
    }
}

