/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates.logic;

import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import pl.asie.simplelogic.gates.logic.GateConnection;
import pl.asie.simplelogic.gates.logic.GateRenderState;
import pl.asie.simplelogic.gates.logic.IGateContainer;

public abstract class GateLogic {
    public byte enabledSides;
    public byte invertedSides;
    protected byte[] outputValues = new byte[4];
    protected final byte[][] outputValuesBundled = new byte[4][];
    private byte[] inputValues = new byte[4];
    private final byte[][] inputValuesBundled = new byte[4][];

    public GateLogic() {
        this.enabledSides = this.getSideMask();
    }

    protected boolean shouldSyncBundledWithClient() {
        return false;
    }

    public boolean shouldTick() {
        return true;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag, boolean isClient) {
        tag.func_74774_a("le", this.enabledSides);
        tag.func_74774_a("li", this.invertedSides);
        tag.func_74773_a("lvi", this.inputValues);
        tag.func_74773_a("lvo", this.outputValues);
        if (!isClient || this.shouldSyncBundledWithClient()) {
            for (int i = 0; i < 4; ++i) {
                if (this.inputValuesBundled[i] != null) {
                    tag.func_74773_a("lbi" + i, this.inputValuesBundled[i]);
                }
                if (this.outputValuesBundled[i] == null) continue;
                tag.func_74773_a("lbo" + i, this.outputValuesBundled[i]);
            }
        }
        return tag;
    }

    public NBTTagCompound writeItemNBT(NBTTagCompound tag, boolean silky) {
        if (silky) {
            tag.func_74774_a("le", this.enabledSides);
        }
        tag.func_74774_a("li", this.invertedSides);
        return tag;
    }

    protected byte[] ensureSizeAndCopy(byte[] data, int len) {
        if (data.length != len) {
            return new byte[len];
        }
        return Arrays.copyOf(data, len);
    }

    protected int[] ensureSizeAndCopy(int[] data, int len) {
        if (data.length != len) {
            return new int[len];
        }
        return Arrays.copyOf(data, len);
    }

    public boolean readFromNBT(NBTTagCompound compound, boolean isClient) {
        byte old;
        boolean update = false;
        if (compound.func_150297_b("le", 99)) {
            old = this.enabledSides;
            this.enabledSides = compound.func_74771_c("le");
            boolean bl = update = this.enabledSides != old;
        }
        if (compound.func_150297_b("li", 99)) {
            old = this.invertedSides;
            this.invertedSides = compound.func_74771_c("li");
            boolean bl = update = this.invertedSides != old;
        }
        if (compound.func_150297_b("lvi", 7)) {
            byte[] old2 = this.inputValues;
            this.inputValues = this.ensureSizeAndCopy(compound.func_74770_j("lvi"), 4);
            update |= !Arrays.equals(old2, this.inputValues);
        }
        if (compound.func_150297_b("lvo", 7)) {
            byte[] old3 = this.outputValues;
            this.outputValues = this.ensureSizeAndCopy(compound.func_74770_j("lvo"), 4);
            update |= !Arrays.equals(old3, this.outputValues);
        }
        for (int i = 0; i < 4; ++i) {
            byte[] old4;
            if (compound.func_150297_b("lbi" + i, 7)) {
                old4 = this.inputValuesBundled[i];
                this.inputValuesBundled[i] = this.ensureSizeAndCopy(compound.func_74770_j("lbi" + i), 16);
                update |= !Arrays.equals(old4, this.inputValuesBundled[i]);
            }
            if (!compound.func_150297_b("lbo" + i, 7)) continue;
            old4 = this.outputValuesBundled[i];
            this.outputValuesBundled[i] = this.ensureSizeAndCopy(compound.func_74770_j("lbo" + i), 16);
            update |= !Arrays.equals(old4, this.outputValuesBundled[i]);
        }
        return update;
    }

    protected boolean updateInput(IGateContainer gate, EnumFacing facing) {
        int i = facing.ordinal() - 2;
        GateConnection conn = this.getType(facing);
        if (conn.isInput()) {
            byte oldOV = this.inputValues[i];
            byte[] oldOVB = this.inputValuesBundled[i];
            if (!this.isSideOpen(facing)) {
                this.inputValues[i] = 0;
                this.inputValuesBundled[i] = null;
            } else if (conn.isBundled()) {
                this.inputValues[i] = 0;
                this.inputValuesBundled[i] = gate.getBundledInput(facing);
            } else {
                this.inputValues[i] = gate.getRedstoneInput(facing);
                this.inputValuesBundled[i] = null;
            }
            return oldOV != this.inputValues[i] || !Arrays.equals(oldOVB, this.inputValuesBundled[i]);
        }
        return false;
    }

    protected boolean updateOutput(EnumFacing facing) {
        int i = facing.ordinal() - 2;
        GateConnection conn = this.getType(facing);
        if (conn.isOutput()) {
            byte oldOV = this.outputValues[i];
            byte[] oldOVB = this.outputValuesBundled[i];
            if (!this.isSideOpen(facing)) {
                this.outputValues[i] = 0;
                this.outputValuesBundled[i] = null;
            } else if (conn.isBundled()) {
                this.outputValues[i] = 0;
                this.outputValuesBundled[i] = new byte[16];
                this.calculateOutputBundled(facing, this.outputValuesBundled[i]);
            } else {
                this.outputValues[i] = this.calculateOutputInside(facing);
                this.outputValuesBundled[i] = null;
            }
            return oldOV != this.outputValues[i] || !Arrays.equals(oldOVB, this.outputValuesBundled[i]);
        }
        return false;
    }

    public boolean updateInputs(IGateContainer gate) {
        boolean changed = false;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            changed |= this.updateInput(gate, facing);
        }
        return changed;
    }

    public void onChanged(IGateContainer gate) {
        gate.scheduleRedstoneTick();
    }

    public boolean tick(IGateContainer gate) {
        return true;
    }

    public boolean updateOutputs(IGateContainer gate) {
        boolean changed = false;
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            changed |= this.updateOutput(facing);
        }
        return changed;
    }

    protected byte calculateOutputInside(EnumFacing side) {
        throw new RuntimeException("Implement me!");
    }

    protected void calculateOutputBundled(EnumFacing side, @Nonnull byte[] data) {
        throw new RuntimeException("Implement me!");
    }

    public GateConnection getType(EnumFacing dir) {
        return dir == EnumFacing.NORTH ? GateConnection.OUTPUT : GateConnection.INPUT;
    }

    public abstract GateRenderState getLayerState(int var1);

    public abstract GateRenderState getTorchState(int var1);

    public boolean hasComparatorInputs() {
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            if (!this.getType(facing).isComparator()) continue;
            return true;
        }
        return false;
    }

    public boolean canMirror() {
        return this.getType(EnumFacing.WEST) != GateConnection.NONE || this.getType(EnumFacing.EAST) != GateConnection.NONE;
    }

    public boolean canBlockSide(EnumFacing side) {
        return this.getType(side).isInput() && !this.getType(side).isBundled();
    }

    public boolean canInvertSide(EnumFacing side) {
        return this.getType(side).isDigital();
    }

    protected final byte getSideMask() {
        byte j = 0;
        for (int i = 0; i <= 3; ++i) {
            if (this.getType(EnumFacing.func_82600_a((int)(i + 2))) == GateConnection.NONE) continue;
            j = (byte)(j | 1 << i);
        }
        return j;
    }

    public boolean onRightClick(IGateContainer gate, EntityPlayer playerIn, Vec3d vec, EnumHand hand) {
        return false;
    }

    public final boolean isSideOpen(EnumFacing side) {
        return (this.enabledSides & 1 << side.ordinal() - 2) != 0;
    }

    public final boolean isSideInverted(EnumFacing side) {
        return (this.invertedSides & 1 << side.ordinal() - 2) != 0;
    }

    @Nullable
    public final byte[] getInputValueBundled(EnumFacing side) {
        return this.inputValuesBundled[side.ordinal() - 2];
    }

    @Nullable
    public final byte[] getOutputValueBundled(EnumFacing side) {
        return this.outputValuesBundled[side.ordinal() - 2];
    }

    public final byte getInputValueOutside(EnumFacing side) {
        if (this.isSideInverted(side) && this.isSideOpen(side)) {
            return this.inputValues[side.ordinal() - 2] != 0 ? (byte)0 : 15;
        }
        return this.inputValues[side.ordinal() - 2];
    }

    public final byte getInputValueInside(EnumFacing side) {
        return this.inputValues[side.ordinal() - 2];
    }

    public final byte getOutputValueInside(EnumFacing side) {
        return this.outputValues[side.ordinal() - 2];
    }

    public final byte getOutputValueOutside(EnumFacing side) {
        if (this.isSideInverted(side) && this.isSideOpen(side)) {
            return this.outputValues[side.ordinal() - 2] != 0 ? (byte)0 : 15;
        }
        return this.outputValues[side.ordinal() - 2];
    }

    public boolean renderEquals(GateLogic other) {
        return true;
    }

    public int renderHashCode(int hash) {
        return hash;
    }
}

