/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.simplelogic.gates;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import pl.asie.simplelogic.gates.PacketGate;
import pl.asie.simplelogic.gates.PartGate;
import pl.asie.simplelogic.gates.logic.GateLogicBundledTransposer;

public class PacketTransposerConnection
extends PacketGate {
    private int from;
    private int to;
    private boolean remove;

    public PacketTransposerConnection() {
    }

    public PacketTransposerConnection(PartGate gate, int from, int to, boolean remove) {
        super(gate);
        this.from = from;
        this.to = to;
        this.remove = remove;
    }

    @Override
    public void readData(INetHandler handler, PacketBuffer buf) {
        super.readData(handler, buf);
        this.from = buf.readUnsignedByte();
        this.to = buf.readUnsignedByte();
        this.remove = (this.to & 0x10) != 0;
        this.to &= 0xF;
    }

    @Override
    public void writeData(PacketBuffer buf) {
        super.writeData(buf);
        buf.writeByte(this.from);
        buf.writeByte(this.to | (this.remove ? 16 : 0));
    }

    @Override
    public void applyGate(PartGate gate, EntityPlayer player) {
        if (!(gate.logic instanceof GateLogicBundledTransposer)) {
            return;
        }
        GateLogicBundledTransposer logic = (GateLogicBundledTransposer)gate.logic;
        int oldLTF = logic.transpositionMap[this.from];
        if (this.remove) {
            int n = this.from;
            logic.transpositionMap[n] = logic.transpositionMap[n] & ~(1 << this.to);
        } else {
            int n = this.from;
            logic.transpositionMap[n] = logic.transpositionMap[n] | 1 << this.to;
        }
        if (oldLTF != logic.transpositionMap[this.from]) {
            logic.onTMapChanged(gate);
        }
    }
}

