/*
 * Decompiled with CFR 0.152.
 */
package com.bloodnbonesgaming.bnbgamingcore.core.module.advancements;

import com.bloodnbonesgaming.bnbgamingcore.core.module.IClassTransformerModule;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMAdditionRegistry;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMDebugHelper;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ASMUtils;
import com.bloodnbonesgaming.bnbgamingcore.core.util.ObfNameHelper;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import squeek.asmhelper.com.bloodnbonesgaming.bnbgamingcore.ASMHelper;

public class ModuleAdvancementAboutToLoadEvent
implements IClassTransformerModule {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (ASMUtils.doesClassEqual(transformedName, ObfNameHelper.Classes.ADVANCEMENTMANAGER)) {
            String methodDesc;
            String methodName;
            boolean changed = false;
            ClassNode classNode = ASMHelper.readClassFromBytes(basicClass);
            MethodNode method = ASMHelper.findMethodNodeOfClass(classNode, methodName = ObfNameHelper.Methods.LOAD_CUSTOM_ADVANCEMENTS.getName(), methodDesc = ObfNameHelper.Methods.LOAD_CUSTOM_ADVANCEMENTS.getDescriptor());
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            methodName = ObfNameHelper.Methods.LOAD_BUILTIN_ADVANCEMENTS.getName();
            methodDesc = ObfNameHelper.Methods.LOAD_BUILTIN_ADVANCEMENTS.getDescriptor();
            method = ASMHelper.findMethodNodeOfClass(classNode, methodName, methodDesc);
            if (method != null) {
                ASMDebugHelper.logAttemptingTransform(methodName, transformedName);
                if (this.addLoadBuiltInAdvancementsHook(method, transformedName)) {
                    ASMDebugHelper.logSuccessfulTransform(methodName, transformedName);
                    changed = true;
                }
            } else {
                ASMDebugHelper.logNotFound(methodName, transformedName);
            }
            if (changed) {
                return ASMHelper.writeClassToBytes(classNode, 3);
            }
        }
        return basicClass;
    }

    @Override
    public boolean canBeDisabled() {
        return true;
    }

    @Override
    public String[] getClassesToTransform() {
        return new String[]{ObfNameHelper.Classes.ADVANCEMENTMANAGER.getName()};
    }

    @Override
    public String getModuleName() {
        return "advancementAboutToLoadEvent";
    }

    @Override
    public void registerAdditions(ASMAdditionRegistry arg0) {
    }

    private boolean addLoadCustomAdvancementsHook(MethodNode method, String transformedName) {
        AbstractInsnNode target = ASMHelper.find(method.instructions, (AbstractInsnNode)new VarInsnNode(58, 6));
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " target", transformedName);
            return false;
        }
        LabelNode label = ASMUtils.findLabelNode(method.instructions, 10);
        if (label == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " label", transformedName);
            return false;
        }
        InsnList toInject = new InsnList();
        toInject.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toInject.add((AbstractInsnNode)ObfNameHelper.Methods.ON_ADVANCEMENT_ABOUT_TO_LOAD.toInsnNode(184));
        LabelNode label2 = new LabelNode();
        toInject.add((AbstractInsnNode)new JumpInsnNode(153, label2));
        toInject.add((AbstractInsnNode)new JumpInsnNode(167, label));
        toInject.add((AbstractInsnNode)label2);
        method.instructions.insert(target, toInject);
        return true;
    }

    private boolean addLoadBuiltInAdvancementsHook(MethodNode method, String transformedName) {
        InsnList toFind = new InsnList();
        InsnList replacement = new InsnList();
        InsnList toFindAfterLoop = new InsnList();
        InsnList toAddAfterLoop = new InsnList();
        toFind.add((AbstractInsnNode)ObfNameHelper.Fields.ADVANCEMENT_MANAGER_GSON.toInsnNode(178));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 11));
        toFind.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)"Lnet/minecraft/advancements/Advancement$Builder;")));
        toFind.add((AbstractInsnNode)ObfNameHelper.Methods.JSON_UTILS_FROM_JSON.toInsnNode(184));
        toFind.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/advancements/Advancement$Builder"));
        toFind.add((AbstractInsnNode)new VarInsnNode(58, 12));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 1));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 10));
        toFind.add((AbstractInsnNode)new VarInsnNode(25, 12));
        toFind.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 11));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 10));
        replacement.add((AbstractInsnNode)ObfNameHelper.Methods.ON_ADVANCEMENT_ABOUT_TO_LOAD.toInsnNode(184));
        replacement.add((AbstractInsnNode)new VarInsnNode(58, 12));
        replacement.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/MinecraftForge", "EVENT_BUS", "Lnet/minecraftforge/fml/common/eventhandler/EventBus;"));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 12));
        replacement.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/fml/common/eventhandler/EventBus", "post", "(Lnet/minecraftforge/fml/common/eventhandler/Event;)Z", false));
        LabelNode label1 = new LabelNode();
        replacement.add((AbstractInsnNode)new JumpInsnNode(153, label1));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 11));
        replacement.add((AbstractInsnNode)new MethodInsnNode(184, "org/apache/commons/io/IOUtils", "closeQuietly", "(Ljava/io/Reader;)V", false));
        LabelNode afterLoop = new LabelNode();
        replacement.add((AbstractInsnNode)new JumpInsnNode(167, afterLoop));
        replacement.add((AbstractInsnNode)label1);
        replacement.add((AbstractInsnNode)ObfNameHelper.Fields.ADVANCEMENT_MANAGER_GSON.toInsnNode(178));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 12));
        replacement.add((AbstractInsnNode)ObfNameHelper.Methods.ADVANCEMENT_ABOUT_TO_LOAD_EVENT_GET_JSON.toInsnNode(182));
        replacement.add((AbstractInsnNode)new LdcInsnNode((Object)Type.getType((String)"Lnet/minecraft/advancements/Advancement$Builder;")));
        replacement.add((AbstractInsnNode)new MethodInsnNode(182, "com/google/gson/Gson", "fromJson", "(Lcom/google/gson/JsonElement;Ljava/lang/Class;)Ljava/lang/Object;", false));
        replacement.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/advancements/Advancement$Builder"));
        replacement.add((AbstractInsnNode)new VarInsnNode(58, 13));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 1));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 10));
        replacement.add((AbstractInsnNode)new VarInsnNode(25, 13));
        replacement.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Map", "put", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", true));
        AbstractInsnNode find = ASMHelper.find(method.instructions, toFind);
        if (find == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " find", transformedName);
            return false;
        }
        AbstractInsnNode replaced = ASMHelper.findAndReplace(method.instructions, toFind, replacement);
        if (replaced == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " replaced", transformedName);
            return false;
        }
        toAddAfterLoop.add((AbstractInsnNode)afterLoop);
        toFindAfterLoop.add((AbstractInsnNode)new VarInsnNode(25, 6));
        toFindAfterLoop.add((AbstractInsnNode)new MethodInsnNode(185, "java/util/Iterator", "hasNext", "()Z", true));
        AbstractInsnNode target = ASMHelper.find(method.instructions, toFindAfterLoop);
        if (target == null) {
            ASMDebugHelper.unexpectedMethodInstructionPattern(method.name + " target", transformedName);
            return false;
        }
        method.instructions.insertBefore(target, toAddAfterLoop);
        return true;
    }
}

