/*
 * Decompiled with CFR 0.152.
 */
package org.dave.bonsaitrees.misc;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.config.IConfigElement;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.bonsaitrees.api.BonsaiDropChances;
import org.dave.bonsaitrees.utility.Logz;

public class ConfigurationHandler {
    public static Configuration configuration;
    public static File configDir;
    public static File treeTypesDir;
    public static File treeShapesDir;
    public static File soilsDir;
    public static final String CATEGORY_DROPS = "drops";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_INTEGRATION = "integration";
    public static final String CATEGORY_GENERAL = "general";

    public static void init(File configFile) {
        if (configuration != null) {
            return;
        }
        configDir = new File(configFile.getParentFile(), "bonsaitrees");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        if (!(treeTypesDir = new File(configDir, "types.d")).exists()) {
            treeTypesDir.mkdirs();
        }
        if (!(treeShapesDir = new File(configDir, "shapes.d")).exists()) {
            treeShapesDir.mkdirs();
        }
        if (!(soilsDir = new File(configDir, "soils.d")).exists()) {
            soilsDir.mkdirs();
        }
        configuration = new Configuration(new File(configDir, "settings.cfg"), null);
        ConfigurationHandler.loadConfiguration();
    }

    private static void loadConfiguration() {
        Logz.info("Loading configuration", new Object[0]);
        BonsaiDropChances.stickChance = configuration.getFloat("stickChance", CATEGORY_DROPS, 0.2f, 0.0f, 1.0f, "Default chance for a stick to drop");
        BonsaiDropChances.logChance = configuration.getFloat("logChance", CATEGORY_DROPS, 0.75f, 0.0f, 1.0f, "Default chance for a wood log to drop");
        BonsaiDropChances.leafChance = configuration.getFloat("leafChance", CATEGORY_DROPS, 0.1f, 0.0f, 1.0f, "Default chance for a leaf to drop");
        BonsaiDropChances.saplingChance = configuration.getFloat("saplingChance", CATEGORY_DROPS, 0.05f, 0.0f, 1.0f, "Default chance for a sapling to drop");
        BonsaiDropChances.fruitChance = configuration.getFloat("fruitChance", CATEGORY_DROPS, 0.2f, 0.0f, 1.0f, "Default chance for a fruit to drop");
        BonsaiDropChances.stickAmount = configuration.getInt("stickAmount", CATEGORY_DROPS, 3, 0, 64, "How many sticks to drop by default");
        BonsaiDropChances.logAmount = configuration.getInt("logAmount", CATEGORY_DROPS, 1, 0, 64, "How many wood logs to drop by default");
        BonsaiDropChances.leafAmount = configuration.getInt("leafAmount", CATEGORY_DROPS, 1, 0, 64, "How many leaves to drop by default");
        BonsaiDropChances.saplingAmount = configuration.getInt("saplingAmount", CATEGORY_DROPS, 1, 0, 64, "How many saplings to drop by default");
        BonsaiDropChances.fruitAmount = configuration.getInt("fruitAmount", CATEGORY_DROPS, 2, 0, 64, "How many fruits to drop by default");
        ClientSettings.maxTreeScale = configuration.getFloat("maxTreeScale", CATEGORY_CLIENT, 0.9f, 0.5f, 1.0f, "Maximum width/depth of a block to grow to");
        ClientSettings.showChanceInJEI = configuration.getBoolean("showChanceInJEI", CATEGORY_CLIENT, true, "Whether to show the drop chances in JEI");
        IntegrationSettings.disabledIntegrations = configuration.getStringList("disabledIntegrations", CATEGORY_INTEGRATION, new String[0], "Integrations to disable (by classname, e.g. org.dave.bonsaitrees.integration.mods.PamsHarvestcraft)");
        IntegrationSettings.disabledTreeTypes = configuration.getStringList("disabledTreeTypes", CATEGORY_INTEGRATION, new String[0], "Tree types to disable (e.g. forestry:hillCherry)");
        IntegrationSettings.disabledSoils = configuration.getStringList("disabledSoils", CATEGORY_INTEGRATION, new String[0], "Bonsai Soils to disable (e.g. minecraft:grass)");
        IntegrationSettings.loadShapesOfUnloadedTrees = configuration.getBoolean("loadShapesOfUnloadedTrees", CATEGORY_INTEGRATION, false, "Can be enabled for development purposes mostly.");
        GeneralSettings.disableHoppingBonsaiPot = configuration.getBoolean("disableHoppingBonsaiPot", CATEGORY_GENERAL, false, "Whether to disable the Hopping Bonsai Pot and make it behave like a normal Bonsai Pot");
        GeneralSettings.baseGrowTicks = configuration.getInt("baseGrowTicks", CATEGORY_GENERAL, 600, 1, Integer.MAX_VALUE, "How many ticks trees need to fully grow. Some tree types modify this value");
        GeneralSettings.noDyeCost = configuration.getBoolean("noDyeCost", CATEGORY_GENERAL, true, "If set to false, then dye is being used up when painting bonsai pots");
        GeneralSettings.waitForEmptyItemBuffers = configuration.getBoolean("waitForEmptyItemBuffers", CATEGORY_GENERAL, false, "Used for Hopping Bonsais only: If this is set to true, trees will only be cut automatically if all previous drops are exported. This breaks compatibility with e.g. storage drawers. If set to false unexported items from the previous cycle are being voided.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public static void onConfigurationChanged(ConfigChangedEvent event) {
        if (!event.getModID().equalsIgnoreCase("bonsaitrees")) {
            return;
        }
        ConfigurationHandler.loadConfiguration();
    }

    public static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> result = new ArrayList<IConfigElement>();
        result.add((IConfigElement)new ConfigElement(configuration.getCategory(CATEGORY_GENERAL)));
        result.add((IConfigElement)new ConfigElement(configuration.getCategory(CATEGORY_CLIENT)));
        result.add((IConfigElement)new ConfigElement(configuration.getCategory(CATEGORY_DROPS)));
        result.add((IConfigElement)new ConfigElement(configuration.getCategory(CATEGORY_INTEGRATION)));
        return result;
    }

    public static class GeneralSettings {
        public static boolean disableHoppingBonsaiPot = false;
        public static int baseGrowTicks = 600;
        public static boolean noDyeCost = true;
        public static boolean waitForEmptyItemBuffers = false;
    }

    public static class IntegrationSettings {
        public static String[] disabledIntegrations = new String[0];
        public static String[] disabledTreeTypes = new String[0];
        public static String[] disabledSoils = new String[0];
        public static boolean loadShapesOfUnloadedTrees = false;
    }

    public static class ClientSettings {
        public static float maxTreeScale = 0.9f;
        public static boolean showChanceInJEI = true;
    }
}

