/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.tileentity;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import openblocks.Config;
import openblocks.client.gui.GuiBlockPlacer;
import openblocks.common.block.BlockBlockManpulatorBase;
import openblocks.common.block.BlockBlockPlacer;
import openblocks.common.container.ContainerBlockPlacer;
import openblocks.common.tileentity.TileEntityBlockManipulator;
import openmods.api.IHasGui;
import openmods.api.IInventoryCallback;
import openmods.fakeplayer.FakePlayerPool;
import openmods.fakeplayer.UseItemAction;
import openmods.fixers.GenericInventoryTeFixerWalker;
import openmods.fixers.RegisterFixer;
import openmods.include.IncludeInterface;
import openmods.inventory.GenericInventory;
import openmods.inventory.IInventoryProvider;
import openmods.inventory.TileEntityInventory;
import openmods.utils.OptionalInt;

@RegisterFixer(value=GenericInventoryTeFixerWalker.class)
public class TileEntityBlockPlacer
extends TileEntityBlockManipulator
implements IHasGui,
IInventoryProvider {
    static final int BUFFER_SIZE = 9;
    private boolean skipActionOnInventoryUpdate = false;
    private final GenericInventory inventory = new TileEntityInventory((TileEntity)this, "blockPlacer", false, 9).addCallback(new IInventoryCallback(){

        public void onInventoryChanged(IInventory inventory, OptionalInt slotNumber) {
            IBlockState blockState;
            TileEntityBlockPlacer.this.markUpdated();
            if (!TileEntityBlockPlacer.this.skipActionOnInventoryUpdate && !((TileEntityBlockPlacer)TileEntityBlockPlacer.this).field_145850_b.field_72995_K && this.isUpdateTriggering(inventory, slotNumber) && (blockState = TileEntityBlockPlacer.this.field_145850_b.func_180495_p(TileEntityBlockPlacer.this.func_174877_v())).func_177230_c() instanceof BlockBlockPlacer && ((Boolean)blockState.func_177229_b(BlockBlockManpulatorBase.POWERED)).booleanValue()) {
                TileEntityBlockPlacer.this.triggerBlockAction(blockState);
            }
        }

        private boolean isUpdateTriggering(IInventory inventory, OptionalInt maybeSlotNumber) {
            if (!maybeSlotNumber.isPresent()) {
                return true;
            }
            int slotNumber = maybeSlotNumber.get();
            return inventory.func_70301_a(slotNumber) != null;
        }
    });

    @Override
    protected boolean canWork(IBlockState targetState, BlockPos target, EnumFacing direction) {
        if (this.inventory.func_191420_l()) {
            return false;
        }
        Block block = targetState.func_177230_c();
        return block.isAir(targetState, (IBlockAccess)this.field_145850_b, target) || block.func_176200_f((IBlockAccess)this.field_145850_b, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doWork(IBlockState targetState, BlockPos target, EnumFacing direction) {
        ItemStack stack = ItemStack.field_190927_a;
        int slotId = 0;
        for (slotId = 0; slotId < this.inventory.func_70302_i_() && (stack = this.inventory.func_70301_a(slotId)).func_190926_b(); ++slotId) {
        }
        if (stack.func_190926_b()) {
            return;
        }
        BlockPos playerPos = target.func_177967_a(direction, 2);
        ItemStack result = (ItemStack)FakePlayerPool.instance.executeOnPlayer((WorldServer)this.field_145850_b, (FakePlayerPool.PlayerUserReturning)new UseItemAction(stack, new Vec3d((Vec3i)playerPos), new Vec3d((Vec3i)target), new Vec3d((Vec3i)target).func_72441_c(0.5, 0.5, 0.5), direction.func_176734_d(), EnumHand.MAIN_HAND));
        if (!ItemStack.func_77989_b((ItemStack)result, (ItemStack)stack)) {
            this.skipActionOnInventoryUpdate = true;
            try {
                this.inventory.func_70299_a(slotId, result);
            }
            finally {
                this.skipActionOnInventoryUpdate = false;
            }
        }
    }

    public Object getServerGui(EntityPlayer player) {
        return new ContainerBlockPlacer((IInventory)player.field_71071_by, this);
    }

    public Object getClientGui(EntityPlayer player) {
        return new GuiBlockPlacer(new ContainerBlockPlacer((IInventory)player.field_71071_by, this));
    }

    public boolean canOpenGui(EntityPlayer player) {
        return true;
    }

    @IncludeInterface
    public IInventory getInventory() {
        return this.inventory;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        tag = super.func_189515_b(tag);
        this.inventory.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory.getHandler();
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    protected int getActionLimit() {
        return Config.blockPlacerActionLimit;
    }
}

