/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.integration.forestry;

import com.enderio.core.common.Lang;
import com.enderio.core.common.transform.EnderCorePlugin;
import com.enderio.core.common.util.NNList;
import crazypants.enderio.api.addon.IEnderIOAddon;
import crazypants.enderio.base.Log;
import crazypants.enderio.base.config.ConfigHandlerEIO;
import crazypants.enderio.base.config.recipes.RecipeFactory;
import crazypants.enderio.base.init.RegisterModObject;
import crazypants.enderio.integration.forestry.ForestryControl;
import crazypants.enderio.integration.forestry.config.Config;
import crazypants.enderio.integration.forestry.init.ForestryIntegrationObject;
import info.loenwind.autoconfig.ConfigHandler;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkCheckHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Triple;

@Mod(modid="enderiointegrationforestry", name="Ender IO Integration with Forestry", version="5.0.43", dependencies="required-after:enderio@[5.0.43,);after:forestry@[5.8.0.242,);required-after:forge@[14.23.4.2705,)", acceptedMinecraftVersions="[1.12.2]")
@Mod.EventBusSubscriber
public class EnderIOIntegrationForestry
implements IEnderIOAddon {
    @Nonnull
    public static final String MODID = "enderiointegrationforestry";
    @Nonnull
    public static final String DOMAIN = "enderio";
    @Nonnull
    public static final String MOD_NAME = "Ender IO Integration with Forestry";
    @Nonnull
    public static final String VERSION = "5.0.43";
    @Nonnull
    private static final String DEFAULT_DEPENDENCIES = "after:enderio";
    @Nonnull
    public static final String DEPENDENCIES = "required-after:enderio@[5.0.43,);after:forestry@[5.8.0.242,);required-after:forge@[14.23.4.2705,)";
    private static ConfigHandler configHandler;
    @Nonnull
    public static final Lang lang;

    @NetworkCheckHandler
    @SideOnly(value=Side.CLIENT)
    public boolean checkModLists(Map<String, String> modList, Side side) {
        return modList.keySet().contains(MODID) && VERSION.equals(modList.get(MODID));
    }

    public EnderIOIntegrationForestry() {
        EnderCorePlugin.instance().loadMixinSources((Object)this);
    }

    @Mod.EventHandler
    public static void init(@Nonnull FMLPreInitializationEvent event) {
        configHandler = new ConfigHandlerEIO(event, Config.F);
        if (EnderIOIntegrationForestry.isLoaded()) {
            ForestryControl.init(event);
            Log.warn("Forestry integration loaded. Let things grow.");
        } else {
            Log.warn("Forestry integration NOT loaded. Forestry is not installed");
        }
    }

    @Mod.EventHandler
    public static void init(FMLInitializationEvent event) {
        if (EnderIOIntegrationForestry.isLoaded()) {
            ForestryControl.init(event);
        }
    }

    @Mod.EventHandler
    public static void init(FMLPostInitializationEvent event) {
        if (EnderIOIntegrationForestry.isLoaded()) {
            ForestryControl.init(event);
        }
    }

    @Override
    @Nullable
    public Configuration getConfiguration() {
        return EnderIOIntegrationForestry.isLoaded() ? Config.F.getConfig() : null;
    }

    @SubscribeEvent
    public static void registerFarmers(@Nonnull RegisterModObject event) {
        if (EnderIOIntegrationForestry.isLoaded()) {
            ForestryIntegrationObject.registerBlocksEarly(event);
            ForestryControl.registerEventBus();
        }
    }

    @Override
    @Nonnull
    public NNList<Triple<Integer, RecipeFactory, String>> getRecipeFiles() {
        if (EnderIOIntegrationForestry.isLoaded()) {
            return new NNList((Object[])new Triple[]{Triple.of((Object)2, null, (Object)"integration-forestry")});
        }
        return NNList.emptyList();
    }

    public static boolean isLoaded() {
        return Loader.isModLoaded((String)"forestry");
    }

    static {
        lang = new Lang(DOMAIN);
    }
}

