/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduits.conduit.liquid;

import com.enderio.core.common.fluid.IFluidWrapper;
import com.enderio.core.common.util.RoundRobinIterator;
import crazypants.enderio.base.conduit.item.FunctionUpgrade;
import crazypants.enderio.base.conduit.item.ItemFunctionUpgrade;
import crazypants.enderio.base.filter.fluid.IFluidFilter;
import crazypants.enderio.conduits.conduit.AbstractConduitNetwork;
import crazypants.enderio.conduits.conduit.liquid.EnderLiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduits.conduit.liquid.NetworkTank;
import crazypants.enderio.conduits.config.ConduitConfig;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class EnderLiquidConduitNetwork
extends AbstractConduitNetwork<ILiquidConduit, EnderLiquidConduit> {
    List<NetworkTank> tanks = new ArrayList<NetworkTank>();
    Map<NetworkTankKey, NetworkTank> tankMap = new HashMap<NetworkTankKey, NetworkTank>();
    Map<NetworkTank, RoundRobinIterator<NetworkTank>> iterators;
    boolean filling;

    public EnderLiquidConduitNetwork() {
        super(EnderLiquidConduit.class, ILiquidConduit.class);
    }

    public void connectionChanged(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
        NetworkTankKey key = new NetworkTankKey(con, conDir);
        NetworkTank tank = new NetworkTank(con, conDir);
        boolean sort = false;
        NetworkTank oldTank = this.tankMap.get(key);
        if (oldTank != null && oldTank.priority != tank.priority) {
            sort = true;
        }
        this.tanks.remove(tank);
        this.tankMap.remove(key);
        this.tanks.add(tank);
        this.tankMap.put(key, tank);
        if (sort) {
            this.tanks.sort(new Comparator<NetworkTank>(){

                @Override
                public int compare(NetworkTank arg0, NetworkTank arg1) {
                    return arg1.priority - arg0.priority;
                }
            });
        }
    }

    public boolean extractFrom(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
        NetworkTank tank = this.getTank(con, conDir);
        if (!tank.isValid()) {
            return false;
        }
        FluidStack drained = tank.externalTank.getAvailableFluid();
        if (drained == null || drained.amount <= 0 || !this.matchedFilter(drained, con, conDir, true)) {
            return false;
        }
        drained = drained.copy();
        drained.amount = Math.min(drained.amount, (Integer)ConduitConfig.fluid_tier3_extractRate.get() * this.getExtractSpeedMultiplier(tank) / 2);
        int amountAccepted = this.fillFrom(tank, drained.copy(), true);
        if (amountAccepted <= 0) {
            return false;
        }
        drained.amount = amountAccepted;
        return (drained = tank.externalTank.drain(drained)) != null && drained.amount > 0;
    }

    @Nonnull
    private NetworkTank getTank(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
        return this.tankMap.get(new NetworkTankKey(con, conDir));
    }

    public int fillFrom(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir, FluidStack resource, boolean doFill) {
        return this.fillFrom(this.getTank(con, conDir), resource, doFill);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fillFrom(@Nonnull NetworkTank tank, FluidStack resource, boolean doFill) {
        if (this.filling) {
            return 0;
        }
        try {
            this.filling = true;
            if (resource == null || !this.matchedFilter(resource, tank.con, tank.conDir, true)) {
                int n = 0;
                return n;
            }
            resource = resource.copy();
            resource.amount = Math.min(resource.amount, (Integer)ConduitConfig.fluid_tier3_maxIO.get() * this.getExtractSpeedMultiplier(tank) / 2);
            int filled = 0;
            int remaining = resource.amount;
            for (NetworkTank target : this.getIteratorForTank(tank)) {
                if (target.equals(tank) && !tank.selfFeed || !target.acceptsOuput || !target.isValid() || target.inputColor != tank.outputColor || !this.matchedFilter(resource, target.con, target.conDir, false)) continue;
                int vol = doFill ? target.externalTank.fill(resource.copy()) : target.externalTank.offer(resource.copy());
                filled += vol;
                if ((remaining -= vol) <= 0) {
                    int n = filled;
                    return n;
                }
                resource.amount = remaining;
            }
            int n = filled;
            return n;
        }
        finally {
            if (!tank.roundRobin) {
                this.getIteratorForTank(tank).reset();
            }
            this.filling = false;
        }
    }

    private int getExtractSpeedMultiplier(NetworkTank tank) {
        int extractSpeedMultiplier = 2;
        ItemStack upgradeStack = tank.con.getFunctionUpgrade(tank.conDir);
        if (!upgradeStack.func_190926_b()) {
            FunctionUpgrade upgrade = ItemFunctionUpgrade.getFunctionUpgrade(upgradeStack);
            if (upgrade == FunctionUpgrade.EXTRACT_SPEED_UPGRADE) {
                extractSpeedMultiplier += 2 * Math.min(upgrade.maxStackSize, upgradeStack.func_190916_E());
            } else if (upgrade == FunctionUpgrade.EXTRACT_SPEED_DOWNGRADE) {
                extractSpeedMultiplier = 1;
            }
        }
        return extractSpeedMultiplier;
    }

    private boolean matchedFilter(FluidStack drained, @Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir, boolean isInput) {
        if (drained == null) {
            return false;
        }
        IFluidFilter filter = con.getFilter(conDir, isInput);
        if (filter == null || filter.isEmpty()) {
            return true;
        }
        return filter.matchesFilter(drained);
    }

    private RoundRobinIterator<NetworkTank> getIteratorForTank(@Nonnull NetworkTank tank) {
        RoundRobinIterator res;
        if (this.iterators == null) {
            this.iterators = new HashMap<NetworkTank, RoundRobinIterator<NetworkTank>>();
        }
        if ((res = this.iterators.get(tank)) == null) {
            res = new RoundRobinIterator(this.tanks);
            this.iterators.put(tank, (RoundRobinIterator<NetworkTank>)res);
        }
        return res;
    }

    public IFluidTankProperties[] getTankProperties(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
        ArrayList<IFluidTankProperties> res = new ArrayList<IFluidTankProperties>(this.tanks.size());
        NetworkTank tank = this.getTank(con, conDir);
        for (NetworkTank target : this.tanks) {
            if (target.equals(tank) || !target.isValid()) continue;
            for (IFluidWrapper.ITankInfoWrapper info : target.externalTank.getTankInfoWrappers()) {
                res.add(info.getIFluidTankProperties());
            }
        }
        return res.toArray(new IFluidTankProperties[res.size()]);
    }

    static class NetworkTankKey {
        EnumFacing conDir;
        BlockPos conduitLoc;

        public NetworkTankKey(@Nonnull EnderLiquidConduit con, @Nonnull EnumFacing conDir) {
            this(con.getBundle().getLocation(), conDir);
        }

        public NetworkTankKey(@Nonnull BlockPos conduitLoc, @Nonnull EnumFacing conDir) {
            this.conDir = conDir;
            this.conduitLoc = conduitLoc;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.conDir == null ? 0 : this.conDir.hashCode());
            result = 31 * result + (this.conduitLoc == null ? 0 : this.conduitLoc.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NetworkTankKey other = (NetworkTankKey)obj;
            if (this.conDir != other.conDir) {
                return false;
            }
            return !(this.conduitLoc == null ? other.conduitLoc != null : !this.conduitLoc.equals((Object)other.conduitLoc));
        }
    }
}

