/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.config.recipes.xml;

import crazypants.enderio.base.config.recipes.InvalidRecipeConfigException;
import crazypants.enderio.base.config.recipes.StaxFactory;
import crazypants.enderio.base.config.recipes.xml.Fluid;
import javax.annotation.Nonnull;
import javax.xml.stream.XMLStreamException;
import net.minecraftforge.fluids.FluidStack;

public class FluidAmount
extends Fluid {
    protected int amount = 1000;

    @Override
    public Object readResolve() throws InvalidRecipeConfigException {
        super.readResolve();
        if (this.amount < 1) {
            throw new InvalidRecipeConfigException("Invalid negative fluid amount");
        }
        return this;
    }

    @Override
    public boolean setAttribute(StaxFactory factory, String name, String value) throws InvalidRecipeConfigException, XMLStreamException {
        if ("amount".equals(name)) {
            try {
                this.amount = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InvalidRecipeConfigException("Invalid value in 'amount': Not a number");
            }
            return true;
        }
        return super.setAttribute(factory, name, value);
    }

    @Override
    @Nonnull
    public FluidStack getFluidStack() {
        return new FluidStack(this.fluid, this.amount, this.tag);
    }
}

