/*
 * Decompiled with CFR 0.152.
 */
package leviathan143.loottweaker.common.lib;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import crafttweaker.api.data.DataBool;
import crafttweaker.api.data.DataByte;
import crafttweaker.api.data.DataByteArray;
import crafttweaker.api.data.DataDouble;
import crafttweaker.api.data.DataFloat;
import crafttweaker.api.data.DataInt;
import crafttweaker.api.data.DataIntArray;
import crafttweaker.api.data.DataList;
import crafttweaker.api.data.DataLong;
import crafttweaker.api.data.DataMap;
import crafttweaker.api.data.DataShort;
import crafttweaker.api.data.DataString;
import crafttweaker.api.data.IData;
import crafttweaker.api.data.IDataConverter;
import java.util.List;
import java.util.Map;

public class DataToJSONConverter
implements IDataConverter<JsonElement> {
    private static final DataToJSONConverter INSTANCE = new DataToJSONConverter();
    private static final Gson SERIALISER = new GsonBuilder().registerTypeAdapter(DataBool.class, (src, srcType, context) -> new JsonPrimitive(Boolean.valueOf(src.asBool()))).registerTypeAdapter(DataByte.class, (src, srcType, context) -> new JsonPrimitive((Number)src.asByte())).registerTypeAdapter(DataShort.class, (src, srcType, context) -> new JsonPrimitive((Number)src.asShort())).registerTypeAdapter(DataInt.class, (src, srcType, context) -> new JsonPrimitive((Number)src.asInt())).registerTypeAdapter(DataLong.class, (src, srcType, context) -> new JsonPrimitive((Number)src.asLong())).registerTypeAdapter(DataFloat.class, (src, srcType, context) -> new JsonPrimitive((Number)Float.valueOf(src.asFloat()))).registerTypeAdapter(DataDouble.class, (src, srcType, context) -> new JsonPrimitive((Number)src.asDouble())).registerTypeAdapter(DataString.class, (src, srcType, context) -> new JsonPrimitive(src.asString())).registerTypeAdapter(DataByteArray.class, (src, srcType, context) -> context.serialize((Object)src.asByteArray())).registerTypeAdapter(DataIntArray.class, (src, srcType, context) -> context.serialize((Object)src.asIntArray())).registerTypeAdapter(DataList.class, (src, srcType, context) -> context.serialize((Object)src.asList())).registerTypeAdapter(DataMap.class, (src, srcType, context) -> context.serialize((Object)src.asMap())).create();

    public static JsonElement from(IData data) {
        return (JsonElement)data.convert((IDataConverter)INSTANCE);
    }

    public JsonElement fromBool(boolean bool) {
        return new JsonPrimitive(Boolean.valueOf(bool));
    }

    public JsonElement fromByte(byte b) {
        return new JsonPrimitive((Number)b);
    }

    public JsonElement fromByteArray(byte[] b) {
        return SERIALISER.toJsonTree((Object)b);
    }

    public JsonElement fromDouble(double d) {
        return new JsonPrimitive((Number)d);
    }

    public JsonElement fromFloat(float f) {
        return new JsonPrimitive((Number)Float.valueOf(f));
    }

    public JsonElement fromInt(int i) {
        return new JsonPrimitive((Number)i);
    }

    public JsonElement fromIntArray(int[] i) {
        return SERIALISER.toJsonTree((Object)i);
    }

    public JsonElement fromList(List<IData> list) {
        return SERIALISER.toJsonTree(list);
    }

    public JsonElement fromLong(long l) {
        return new JsonPrimitive((Number)l);
    }

    public JsonElement fromMap(Map<String, IData> map) {
        return SERIALISER.toJsonTree(map);
    }

    public JsonElement fromShort(short s) {
        return new JsonPrimitive((Number)s);
    }

    public JsonElement fromString(String str) {
        return new JsonPrimitive(str);
    }
}

