/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.plugins.vanilla.ingredients.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class ItemStackRenderer
implements IIngredientRenderer<ItemStack> {
    @Override
    public void render(Minecraft minecraft, int xPosition, int yPosition, @Nullable ItemStack ingredient) {
        if (ingredient != null) {
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            FontRenderer font = this.getFontRenderer(minecraft, ingredient);
            minecraft.func_175599_af().func_184391_a(null, ingredient, xPosition, yPosition);
            minecraft.func_175599_af().func_180453_a(font, ingredient, xPosition, yPosition, null);
            GlStateManager.func_179084_k();
            RenderHelper.func_74518_a();
        }
    }

    @Override
    public List<String> getTooltip(Minecraft minecraft, ItemStack ingredient, ITooltipFlag tooltipFlag) {
        EnumRarity rarity;
        List list;
        EntityPlayerSP player = minecraft.field_71439_g;
        try {
            list = ingredient.func_82840_a((EntityPlayer)player, tooltipFlag);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            Log.get().error("Failed to get tooltip: {}", (Object)itemStackInfo, (Object)e);
            ArrayList<String> list2 = new ArrayList<String>();
            list2.add(TextFormatting.RED + Translator.translateToLocal("jei.tooltip.error.crash"));
            return list2;
        }
        try {
            rarity = ingredient.func_77953_t();
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(ingredient);
            Log.get().error("Failed to get rarity: {}", (Object)itemStackInfo, (Object)e);
            rarity = EnumRarity.COMMON;
        }
        for (int k = 0; k < list.size(); ++k) {
            if (k == 0) {
                list.set(k, rarity.field_77937_e + (String)list.get(k));
                continue;
            }
            list.set(k, TextFormatting.GRAY + (String)list.get(k));
        }
        return list;
    }

    @Override
    public FontRenderer getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
        FontRenderer fontRenderer = ingredient.func_77973_b().getFontRenderer(ingredient);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }
}

